/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.engine.security.IAuthenticationRoleMapper;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.plugin.services.security.userrole.ldap.search.LdapSearch;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.util.Assert;

public class DefaultLdapUserRoleListService
implements IUserRoleListService,
InitializingBean {
    private LdapSearch allUsernamesSearch;
    private LdapSearch allAuthoritiesSearch;
    private LdapSearch usernamesInRoleSearch;
    private Comparator<String> roleComparator;
    private Comparator<String> usernameComparator;
    private UserDetailsService userDetailsService;
    private ITenantedPrincipleNameResolver userNameUtils;
    private ITenantedPrincipleNameResolver roleNameUtils;
    private List<String> systemRoles;
    private List<String> extraRoles;
    private IAuthenticationRoleMapper roleMapper;

    public DefaultLdapUserRoleListService() {
    }

    public DefaultLdapUserRoleListService(Comparator<String> usernameComparator, Comparator<String> roleComparator) {
        this.usernameComparator = usernameComparator;
        this.roleComparator = roleComparator;
    }

    public DefaultLdapUserRoleListService(Comparator<String> usernameComparator, Comparator<String> roleComparator, IAuthenticationRoleMapper roleMapper) {
        this(usernameComparator, roleComparator);
        this.roleMapper = roleMapper;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public List<String> getAllRoles() {
        List results = this.allAuthoritiesSearch.search(new Object[0]);
        ArrayList<String> roles = new ArrayList<String>(results.size());
        for (GrantedAuthority role : results) {
            String roleString = this.roleMapper != null ? this.roleMapper.toPentahoRole(role.getAuthority()) : role.getAuthority();
            if (roleString == null || this.extraRoles == null || this.extraRoles.contains(roleString)) continue;
            roles.add(roleString);
        }
        if (null != this.roleComparator) {
            Collections.sort(roles, this.roleComparator);
        }
        return roles;
    }

    public List<String> getAllUsers() {
        List results = this.allUsernamesSearch.search(new Object[0]);
        if (null != this.usernameComparator) {
            Collections.sort(results, this.usernameComparator);
        }
        return results;
    }

    public List<String> getUsersInRole(ITenant tenant, String role) {
        if (tenant != null && !tenant.equals(JcrTenantUtils.getDefaultTenant())) {
            throw new UnsupportedOperationException("only allowed to access to default tenant");
        }
        String updateRole = this.roleNameUtils.getPrincipleName(role);
        List results = this.usernamesInRoleSearch.search(new Object[]{this.roleMapper.fromPentahoRole(updateRole)});
        if (null != this.usernameComparator) {
            Collections.sort(results, this.usernameComparator);
        }
        return results;
    }

    public List<String> getRolesForUser(ITenant tenant, String username) {
        if (tenant != null && !tenant.equals(JcrTenantUtils.getDefaultTenant())) {
            throw new UnsupportedOperationException("only allowed to access to default tenant");
        }
        UserDetails user = this.userDetailsService.loadUserByUsername(this.userNameUtils.getPrincipleName(username));
        List<GrantedAuthority> results = Arrays.asList(user.getAuthorities());
        ArrayList<String> roles = new ArrayList<String>(results.size());
        for (GrantedAuthority role : results) {
            roles.add(role.getAuthority());
        }
        if (null != this.roleComparator) {
            Collections.sort(roles, this.roleComparator);
        }
        return roles;
    }

    public void setAllUsernamesSearch(LdapSearch allUsernamesSearch) {
        this.allUsernamesSearch = allUsernamesSearch;
    }

    public void setAllAuthoritiesSearch(LdapSearch allAuthoritiesSearch) {
        this.allAuthoritiesSearch = allAuthoritiesSearch;
    }

    public void setUsernamesInRoleSearch(LdapSearch usernamesInRoleSearch) {
        this.usernamesInRoleSearch = usernamesInRoleSearch;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setRoleComparator(Comparator<String> roleComparator) {
        this.roleComparator = roleComparator;
    }

    public void setUsernameComparator(Comparator<String> usernameComparator) {
        Assert.notNull(usernameComparator);
        this.usernameComparator = usernameComparator;
    }

    public ITenantedPrincipleNameResolver getUserNameUtils() {
        return this.userNameUtils;
    }

    public void setUserNameUtils(ITenantedPrincipleNameResolver userNameUtils) {
        this.userNameUtils = userNameUtils;
    }

    public ITenantedPrincipleNameResolver getRoleNameUtils() {
        return this.roleNameUtils;
    }

    public void setRoleNameUtils(ITenantedPrincipleNameResolver roleNameUtils) {
        this.roleNameUtils = roleNameUtils;
    }

    public List<String> getAllRoles(ITenant tenant) {
        if (tenant != null && !tenant.equals(JcrTenantUtils.getDefaultTenant())) {
            throw new UnsupportedOperationException("only allowed to access to default tenant");
        }
        return this.getAllRoles();
    }

    public List<String> getAllUsers(ITenant tenant) {
        if (tenant != null && !tenant.equals(JcrTenantUtils.getDefaultTenant())) {
            throw new UnsupportedOperationException("only allowed to access to default tenant");
        }
        return this.getAllUsers();
    }

    public List<String> getSystemRoles() {
        return this.systemRoles;
    }

    public void setSystemRoles(List<String> systemRoles) {
        this.systemRoles = systemRoles;
    }

    public void setExtraRoles(List<String> extraRoles) {
        this.extraRoles = extraRoles;
    }

    public List<String> getExtraRoles() {
        return this.extraRoles;
    }
}

