/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport.exportManifest;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.plugin.services.importexport.exportManifest.ExportManifestFormatException;
import org.pentaho.platform.plugin.services.importexport.exportManifest.XmlGregorianCalendarConverter;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.CustomProperty;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.EntityAcl;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.EntityMetaData;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestEntityDto;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestProperty;
import org.pentaho.platform.repository2.messages.Messages;
import org.pentaho.platform.security.userroledao.DefaultTenantedPrincipleNameResolver;
import org.pentaho.platform.util.messages.LocaleHelper;

public class ExportManifestEntity {
    private ExportManifestEntityDto rawExportManifestEntity;
    private EntityMetaData entityMetaData;
    private EntityAcl entityAcl;
    private List<CustomProperty> customProperties;

    protected ExportManifestEntity() {
        this.rawExportManifestEntity = new ExportManifestEntityDto();
    }

    protected ExportManifestEntity(String rootFolder, RepositoryFile repositoryFile, RepositoryFileAcl repositoryFileAcl) throws ExportManifestFormatException {
        this();
        ExportManifestProperty rawExportManifestProperty = new ExportManifestProperty();
        this.createEntityMetaData(rootFolder, repositoryFile);
        this.createEntityAcl(repositoryFileAcl);
        rawExportManifestProperty.setEntityMetaData(this.entityMetaData);
        rawExportManifestProperty.setEntityAcl(this.entityAcl);
    }

    protected ExportManifestEntity(File file, String userId, String projectId, Boolean isFolder, Boolean isHidden) {
        this();
        ExportManifestProperty rawExportManifestProperty = new ExportManifestProperty();
        this.createEntityMetaData(file, userId, projectId, isFolder, isHidden);
        this.createEntityAcl(userId);
        rawExportManifestProperty.setEntityMetaData(this.entityMetaData);
        rawExportManifestProperty.setEntityAcl(this.entityAcl);
    }

    private void createEntityAcl(String userId) {
        this.entityAcl = new EntityAcl();
        this.entityAcl.setEntriesInheriting(true);
    }

    private void createEntityMetaData(File file, String userId, String projectId, Boolean isFolder, Boolean isHidden) {
        if (LocaleHelper.getLocale() == null) {
            LocaleHelper.setLocale((Locale)Locale.getDefault());
        }
        this.entityMetaData = new EntityMetaData();
        this.entityMetaData.setCreatedBy(userId);
        this.entityMetaData.setCreatedDate(XmlGregorianCalendarConverter.asXMLGregorianCalendar(new Date()));
        this.entityMetaData.setDescription("Project folder for AgileBi Project named: " + projectId);
        this.entityMetaData.setIsHidden(isHidden);
        this.entityMetaData.setIsFolder(isFolder);
        this.entityMetaData.setLocale(LocaleHelper.getLocale().toString());
        this.entityMetaData.setName(file.getName());
        this.entityMetaData.setPath(StringUtils.replaceChars((String)file.getPath(), (String)"/\\", (String)"//"));
        this.entityMetaData.setTitle(file.getName());
        this.setPath(StringUtils.replaceChars((String)file.getPath(), (String)"/\\", (String)"//"));
    }

    private void createEntityMetaData(String rootFolder, RepositoryFile repositoryFile) throws ExportManifestFormatException {
        if (LocaleHelper.getLocale() == null) {
            LocaleHelper.setLocale((Locale)Locale.getDefault());
        }
        this.entityMetaData = new EntityMetaData();
        this.entityMetaData.setCreatedBy(repositoryFile.getCreatorId());
        this.entityMetaData.setCreatedDate(XmlGregorianCalendarConverter.asXMLGregorianCalendar(repositoryFile.getCreatedDate()));
        this.entityMetaData.setDescription(repositoryFile.getDescription());
        this.entityMetaData.setIsHidden(repositoryFile.isHidden());
        this.entityMetaData.setIsFolder(repositoryFile.isFolder());
        this.entityMetaData.setLocale(LocaleHelper.getLocale().toString());
        this.entityMetaData.setName(repositoryFile.getName());
        String testRootFolder = rootFolder;
        if (testRootFolder.endsWith("/")) {
            testRootFolder = testRootFolder.substring(0, testRootFolder.length() - 1);
        }
        if (!repositoryFile.getPath().startsWith(testRootFolder)) {
            throw new ExportManifestFormatException("File path does not start with rootFolder");
        }
        String adjustedPath = repositoryFile.getPath().substring(rootFolder.length());
        this.entityMetaData.setPath(adjustedPath);
        this.entityMetaData.setTitle(repositoryFile.getTitle());
        this.setPath(adjustedPath);
    }

    private void createEntityAcl(RepositoryFileAcl repositoryFileAcl) {
        DefaultTenantedPrincipleNameResolver nameResolver = new DefaultTenantedPrincipleNameResolver();
        if (repositoryFileAcl == null) {
            return;
        }
        this.entityAcl = new EntityAcl();
        this.entityAcl.setEntriesInheriting(repositoryFileAcl.isEntriesInheriting());
        this.entityAcl.setOwner(nameResolver.getPrincipleName(repositoryFileAcl.getOwner().getName()));
        this.entityAcl.setOwnerType(repositoryFileAcl.getOwner().getType().name());
        List<EntityAcl.Aces> aces = this.entityAcl.getAces();
        aces.clear();
        for (RepositoryFileAce repositoryFileAce : repositoryFileAcl.getAces()) {
            EntityAcl.Aces ace = new EntityAcl.Aces();
            ace.setRecipient(nameResolver.getPrincipleName(repositoryFileAce.getSid().getName()));
            ace.setRecipientType(repositoryFileAce.getSid().getType().name());
            List<String> permissions = ace.getPermissions();
            for (RepositoryFilePermission permission : repositoryFileAce.getPermissions()) {
                permissions.add(permission.toString());
            }
            aces.add(ace);
        }
    }

    public RepositoryFile getRepositoryFile() {
        EntityMetaData emd = this.getEntityMetaData();
        if (this.entityMetaData == null) {
            return null;
        }
        return new RepositoryFile(null, emd.getName(), emd.isIsFolder(), emd.isIsHidden(), false, null, emd.getPath(), XmlGregorianCalendarConverter.asDate(emd.getCreatedDate()), null, false, null, null, null, "en-US", emd.getTitle(), emd.getDescription(), null, null, 0L, emd.getOwner(), null);
    }

    public RepositoryFileAcl getRepositoryFileAcl() throws ExportManifestFormatException {
        EntityAcl entityAcl = this.getEntityAcl();
        if (entityAcl == null) {
            return null;
        }
        ArrayList<RepositoryFileAce> repositoryFileAces = new ArrayList<RepositoryFileAce>();
        for (EntityAcl.Aces ace : entityAcl.getAces()) {
            RepositoryFileSid rfs = this.getSid(ace.getRecipient(), ace.getRecipientType());
            HashSet<RepositoryFilePermission> permissionSet = new HashSet<RepositoryFilePermission>();
            for (String permission : ace.getPermissions()) {
                permissionSet.add(this.getPermission(permission));
            }
            RepositoryFileAce repositoryFileAce = new RepositoryFileAce(rfs, EnumSet.copyOf(permissionSet));
            repositoryFileAces.add(repositoryFileAce);
        }
        RepositoryFileAcl repositoryFileAcl = new RepositoryFileAcl((Serializable)((Object)""), this.getSid(entityAcl.getOwner(), entityAcl.getOwnerType()), entityAcl.isEntriesInheriting(), repositoryFileAces);
        return repositoryFileAcl;
    }

    private RepositoryFileSid getSid(String name, String type) throws ExportManifestFormatException {
        RepositoryFileSid.Type typevalue;
        try {
            typevalue = RepositoryFileSid.Type.valueOf((String)type);
        }
        catch (IllegalArgumentException e) {
            throw new ExportManifestFormatException(Messages.getInstance().getString("ExportManifestFormatException.invalidRepositoryFileSidType", new Object[]{type}), e);
        }
        return new RepositoryFileSid(name, typevalue);
    }

    private RepositoryFilePermission getPermission(String stringValue) throws ExportManifestFormatException {
        RepositoryFilePermission value;
        try {
            value = RepositoryFilePermission.valueOf((String)stringValue);
        }
        catch (IllegalArgumentException e) {
            throw new ExportManifestFormatException(Messages.getInstance().getString("ExportManifestFormatException.invalidPermissionType", new Object[]{stringValue}), e);
        }
        return value;
    }

    ExportManifestEntityDto getExportManifestEntityDto() {
        ExportManifestProperty exportManifestProperty;
        List<ExportManifestProperty> rawProperties = this.rawExportManifestEntity.getExportManifestProperty();
        rawProperties.clear();
        if (this.entityMetaData != null) {
            exportManifestProperty = new ExportManifestProperty();
            exportManifestProperty.setEntityMetaData(this.entityMetaData);
            rawProperties.add(exportManifestProperty);
        }
        if (this.entityAcl != null) {
            exportManifestProperty = new ExportManifestProperty();
            exportManifestProperty.setEntityAcl(this.entityAcl);
            rawProperties.add(exportManifestProperty);
        }
        if (this.customProperties != null && this.customProperties.size() > 0) {
            exportManifestProperty = new ExportManifestProperty();
            exportManifestProperty.getCustomProperty().addAll(this.customProperties);
            rawProperties.add(exportManifestProperty);
        }
        return this.rawExportManifestEntity;
    }

    public ExportManifestEntity(ExportManifestEntityDto exportManifestEntity) {
        this.rawExportManifestEntity = exportManifestEntity;
        for (ExportManifestProperty exportManifestProperty : exportManifestEntity.getExportManifestProperty()) {
            if (exportManifestProperty.getEntityMetaData() != null) {
                this.entityMetaData = exportManifestProperty.getEntityMetaData();
                continue;
            }
            if (exportManifestProperty.getEntityAcl() != null) {
                this.entityAcl = exportManifestProperty.getEntityAcl();
                continue;
            }
            if (exportManifestProperty.getCustomProperty() == null || exportManifestProperty.getCustomProperty().size() <= 0) continue;
            this.customProperties = exportManifestProperty.getCustomProperty();
        }
    }

    public boolean isValid() {
        return this.entityMetaData != null;
    }

    public EntityMetaData getEntityMetaData() {
        return this.entityMetaData;
    }

    public void setEntityMetaData(EntityMetaData entityMetaData) {
        this.entityMetaData = entityMetaData;
    }

    public EntityAcl getEntityAcl() {
        return this.entityAcl;
    }

    public void setEntityAcl(EntityAcl entityAcl) {
        this.entityAcl = entityAcl;
    }

    public List<CustomProperty> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(List<CustomProperty> customProperties) {
        this.customProperties = customProperties;
    }

    public String getPath() {
        return this.rawExportManifestEntity.getPath();
    }

    public void setPath(String path) {
        this.rawExportManifestEntity.setPath(path);
    }
}

