/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportFileHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XActionImportHandler
extends RepositoryFileImportFileHandler
implements IPlatformImportHandler {
    public XActionImportHandler(List<IMimeType> mimeTypes) {
        super(mimeTypes);
    }

    @Override
    public void importFile(IPlatformImportBundle bundle) throws PlatformImportException {
        try {
            RepositoryFileImportBundle importBundle = (RepositoryFileImportBundle)bundle;
            byte[] bytes = IOUtils.toByteArray((InputStream)bundle.getInputStream());
            importBundle.setInputStream(new ByteArrayInputStream(bytes));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(bytes));
            NodeList resultTypes = document.getElementsByTagName("result-type");
            if (resultTypes.getLength() > 0) {
                Node resultType = resultTypes.item(0);
                boolean isHidden = "none".equals(resultType.getTextContent());
                importBundle.setHidden(isHidden);
            }
            super.importFile(importBundle);
        }
        catch (Exception e) {
            throw new PlatformImportException(e.getMessage(), e);
        }
    }
}

