/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportFileHandler;
import org.pentaho.platform.plugin.services.importexport.ImportSession;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.w3c.dom.Document;

public class LocaleImportHandler
extends RepositoryFileImportFileHandler
implements IPlatformImportHandler {
    private static final String FILE_DESCRIPTION = "file.description";
    private static final String FILE_TITLE = "file.title";
    private static final String DIRECTORY_NAME = "directory_name";
    private static final String DIRECTORY_DESCRIPTION = "directory_description";
    private static final String LOCALE_FOLDER = "index";
    private static final String LOCALE_EXT = ".locale";
    private static final String OLD_LOCALE_EXT = ".properties";
    private static final String XML_LOCALE_EXT = ".xml";
    private static final String VARIABLE_SYMBOL_FROM_INDEX = "%";
    private static final String TITLE_PROPERTY_NAME = "name";
    private static final String DESC_PROPERTY_NAME = "description";
    private List<String> artifacts;
    private IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);

    public LocaleImportHandler(List<IMimeType> mimeTypes, List<String> artifacts) {
        super(mimeTypes);
        this.artifacts = artifacts;
    }

    @Override
    public void importFile(IPlatformImportBundle bundle) throws PlatformImportException {
        String bundleFileName;
        RepositoryFileImportBundle localeBundle = (RepositoryFileImportBundle)bundle;
        Properties localePropertiesFromIndex = this.loadPropertiesByXml(localeBundle);
        RepositoryFile localeParent = this.getLocaleParent(localeBundle, localePropertiesFromIndex);
        Properties localeProperties = this.buildLocaleProperties(localeBundle, localePropertiesFromIndex);
        String string = bundleFileName = localeBundle.getFile() != null ? localeBundle.getFile().getName() : localeBundle.getName();
        if (localeParent != null && this.unifiedRepository != null && bundleFileName != null) {
            String fullPath = RepositoryFilenameUtils.concat((String)localeBundle.getPath(), (String)localeParent.getName());
            if (ImportSession.getSession().getSkippedFiles().contains(fullPath)) {
                this.getLogger().trace((Object)("Not importing Locale [" + bundleFileName + "] since parent file not written "));
            } else {
                this.getLogger().trace((Object)("Processing Locale [" + bundleFileName + "]"));
                this.unifiedRepository.setLocalePropertiesForFile(localeParent, this.extractLocaleCode(localeBundle), localeProperties);
            }
        }
    }

    private Properties buildLocaleProperties(RepositoryFileImportBundle locale, Properties localePropertiesFromIndex) {
        Properties localeProperties = new Properties();
        PropertyResourceBundle rb = null;
        String comment = locale.getComment();
        String fileTitle = locale.getName();
        if (!localePropertiesFromIndex.isEmpty()) {
            comment = localePropertiesFromIndex.getProperty(DESC_PROPERTY_NAME);
            fileTitle = localePropertiesFromIndex.getProperty(TITLE_PROPERTY_NAME);
        } else {
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)locale.getInputStream());
                ByteArrayInputStream bundleInputStream = new ByteArrayInputStream(bytes);
                rb = new PropertyResourceBundle(bundleInputStream);
            }
            catch (Exception returnEmptyIfError) {
                this.getLogger().error((Object)returnEmptyIfError.getMessage());
                return localeProperties;
            }
            if (rb != null) {
                String string = rb.containsKey(DESC_PROPERTY_NAME) ? rb.getString(DESC_PROPERTY_NAME) : (rb.containsKey(FILE_DESCRIPTION) ? rb.getString(FILE_DESCRIPTION) : (comment = rb.containsKey(DIRECTORY_DESCRIPTION) ? rb.getString(DIRECTORY_DESCRIPTION) : comment));
                fileTitle = rb.containsKey(TITLE_PROPERTY_NAME) ? rb.getString(TITLE_PROPERTY_NAME) : (rb.containsKey("title") ? rb.getString("title") : (rb.containsKey(FILE_TITLE) ? rb.getString(FILE_TITLE) : (rb.containsKey(DIRECTORY_NAME) ? rb.getString(DIRECTORY_NAME) : fileTitle)));
            }
        }
        localeProperties.setProperty(FILE_DESCRIPTION, comment != null ? comment : "");
        localeProperties.setProperty(FILE_TITLE, fileTitle != null ? fileTitle : "");
        return localeProperties;
    }

    private String extractLocaleCode(RepositoryFileImportBundle localeBundle) {
        String localeCode = "default";
        String localeFileName = localeBundle.getName();
        if (localeBundle.getFile() != null) {
            localeFileName = localeBundle.getFile().getName();
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            if (!localeFileName.endsWith("_" + locale + LOCALE_EXT) && !localeFileName.endsWith("_" + locale + OLD_LOCALE_EXT)) continue;
            localeCode = locale.toString();
            break;
        }
        return localeCode;
    }

    private RepositoryFile getLocaleParent(RepositoryFileImportBundle locale, Properties localePropertiesFromIndex) {
        if (this.unifiedRepository == null) {
            return null;
        }
        RepositoryFile localeParent = null;
        String localeFileName = locale.getName();
        if (locale.getFile() != null) {
            localeFileName = locale.getFile().getName();
        }
        RepositoryFile localeFolder = this.unifiedRepository.getFile(locale.getPath());
        if (this.isLocaleFolder(localeFileName, localePropertiesFromIndex)) {
            localeParent = localeFolder;
        } else if (localeFolder != null) {
            List localeFolderChildren = this.unifiedRepository.getChildren(localeFolder.getId());
            for (RepositoryFile localeChild : localeFolderChildren) {
                String localeChildName = this.extractFileName(localeChild.getName());
                String localeChildExtension = this.extractExtension(localeChild.getName());
                boolean localeFileNameAlsoContainsFileExtension = this.checkIfLocaleFileNameAlsoContainsAFileExtension(localeFileName);
                if (localeFileNameAlsoContainsFileExtension) {
                    String localeFileExtension = FilenameUtils.getExtension((String)FilenameUtils.getBaseName((String)localeFileName));
                    String localeFileNameWithoutExtensions = FilenameUtils.getBaseName((String)FilenameUtils.getBaseName((String)localeFileName));
                    if (localeFileExtension.contains("_")) {
                        localeFileExtension = localeFileExtension.substring(0, localeFileExtension.indexOf("_"));
                    }
                    if (!localeFileNameWithoutExtensions.equals(localeChildName) || !localeFileExtension.equalsIgnoreCase(localeChildExtension) || !this.artifacts.contains(localeChildExtension)) continue;
                    localeParent = localeChild;
                    break;
                }
                if (!this.extractFileName(localeFileName).equals(localeChildName) || !this.artifacts.contains(localeChildExtension)) continue;
                localeParent = localeChild;
                break;
            }
        }
        return localeParent;
    }

    private boolean isLocaleFolder(String localeFileName, Properties localePropertiesFromIndex) {
        return localeFileName.startsWith(LOCALE_FOLDER) && localeFileName.endsWith(LOCALE_EXT) || localeFileName.startsWith(LOCALE_FOLDER) && localeFileName.endsWith(OLD_LOCALE_EXT) || localeFileName.equals("index.xml") && !localePropertiesFromIndex.isEmpty();
    }

    private String extractExtension(String name) {
        int idx = name.lastIndexOf(".");
        if (idx == -1 || idx == name.length()) {
            return name;
        }
        return name.substring(idx + 1);
    }

    private String extractFileName(String name) {
        int idx = name.lastIndexOf(".");
        if (idx == -1 || idx == name.length()) {
            return name;
        }
        return name.substring(0, idx);
    }

    private boolean checkIfLocaleFileNameAlsoContainsAFileExtension(String locale) {
        if (StringUtils.isNotEmpty((String)locale)) {
            return StringUtils.isNotEmpty((String)FilenameUtils.getExtension((String)FilenameUtils.getBaseName((String)locale)));
        }
        return false;
    }

    private Properties loadPropertiesByXml(RepositoryFileImportBundle localeBundle) {
        Properties properties = new Properties();
        String fileTitle = localeBundle.getName();
        if ("index.xml".equals(fileTitle)) {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = builderFactory.newDocumentBuilder();
                Document document = builder.parse(localeBundle.getInputStream());
                XPath xPath = XPathFactory.newInstance().newXPath();
                String name = xPath.compile("/index/name").evaluate(document);
                String desc = xPath.compile("/index/description").evaluate(document);
                if (StringUtils.isNotBlank((String)name) && !name.equals("%name")) {
                    properties.put(TITLE_PROPERTY_NAME, name);
                }
                if (StringUtils.isNotBlank((String)desc) && !desc.equals("%description")) {
                    properties.put(DESC_PROPERTY_NAME, desc);
                }
            }
            catch (Exception e) {
                this.getLogger().error((Object)e.getMessage());
            }
        }
        return properties;
    }
}

