/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importexport.ImportSession;
import org.pentaho.platform.util.logging.Logger;

public class ArchiveLoader {
    public static final FilenameFilter ZIPS_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".zip");
        }
    };
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(".yyyyMMddHHmm");
    private IPlatformImporter importer;
    private Date loadStamp;

    public ArchiveLoader(IPlatformImporter importer) {
        this(importer, new Date());
    }

    ArchiveLoader(IPlatformImporter importer, Date loadStamp) {
        this.importer = importer;
        ImportSession.getSession().setAclProperties(true, true, false);
        this.loadStamp = loadStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll(File directory, FilenameFilter filenameFilter) {
        File[] files = directory.listFiles(filenameFilter);
        if (files != null) {
            for (File file : files) {
                try {
                    Logger.debug((String)this.getClass().getName(), (String)(this.getClass().getName() + ": importing " + file.getName()));
                    this.importer.importFile(this.createBundle(file));
                }
                catch (Exception e) {
                    Logger.error((String)this.getClass().getName(), (String)e.getMessage(), (Throwable)e);
                }
                finally {
                    file.renameTo(new File(file.getPath() + DATE_FORMAT.format(this.loadStamp)));
                }
            }
        }
    }

    private IPlatformImportBundle createBundle(File file) throws FileNotFoundException {
        RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder();
        bundleBuilder.input(this.createInputStream(file));
        bundleBuilder.charSet("UTF-8");
        bundleBuilder.hidden(true);
        bundleBuilder.path("/");
        bundleBuilder.overwriteFile(true);
        bundleBuilder.name(file.getName());
        bundleBuilder.applyAclSettings(true);
        bundleBuilder.overwriteAclSettings(false);
        bundleBuilder.retainOwnership(true);
        bundleBuilder.preserveDsw(true);
        return bundleBuilder.build();
    }

    FileInputStream createInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }
}

