/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.exporter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class MetaStoreExportUtil {
    private static final String SINGLE_DI_SERVER_INSTANCE = "singleDiServerInstance";

    public static Repository connectToRepository(String repositoryName) throws KettleException {
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        boolean singleDiServerInstance = "true".equals(PentahoSystem.getSystemSetting((String)SINGLE_DI_SERVER_INSTANCE, (String)"true"));
        try {
            if (singleDiServerInstance) {
                String repositoriesXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><repositories><repository><id>PentahoEnterpriseRepository</id><name>singleDiServerInstance</name><description>singleDiServerInstance</description><repository_location_url>" + PentahoSystem.getApplicationContext().getFullyQualifiedServerURL() + "</repository_location_url>" + "<version_comment_mandatory>N</version_comment_mandatory>" + "</repository>" + "</repositories>";
                ByteArrayInputStream sbis = new ByteArrayInputStream(repositoriesXml.getBytes("UTF8"));
                repositoriesMeta.readDataFromInputStream((InputStream)sbis);
            } else {
                repositoriesMeta.readData();
            }
        }
        catch (Exception e) {
            throw new KettleException("Meta repository not populated", (Throwable)e);
        }
        RepositoryMeta repositoryMeta = null;
        try {
            repositoryMeta = singleDiServerInstance ? repositoriesMeta.findRepository(SINGLE_DI_SERVER_INSTANCE) : repositoriesMeta.findRepository(repositoryName);
        }
        catch (Exception e) {
            throw new KettleException("Repository not found", (Throwable)e);
        }
        if (repositoryMeta == null) {
            throw new KettleException("RepositoryMeta is null");
        }
        Repository repository = null;
        try {
            repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
            repository.init(repositoryMeta);
        }
        catch (Exception e) {
            throw new KettleException("Could not get repository instance", (Throwable)e);
        }
        repository.connect(PentahoSessionHolder.getSession().getName(), "password");
        return repository;
    }
}

