/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.userroledao.jackrabbit;

import java.io.IOException;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.pentaho.platform.api.engine.security.userroledao.AlreadyExistsException;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.engine.security.userroledao.NotFoundException;
import org.pentaho.platform.api.engine.security.userroledao.UncategorizedUserRoleDaoException;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.api.repository2.unified.IRepositoryDefaultAclHandler;
import org.pentaho.platform.repository2.unified.IRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.IRepositoryFileDao;
import org.pentaho.platform.repository2.unified.jcr.ILockHelper;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.security.userroledao.jackrabbit.AbstractJcrBackedUserRoleDao;
import org.pentaho.platform.security.userroledao.messages.Messages;
import org.springframework.dao.DataAccessException;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrSystemException;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.security.providers.dao.UserCache;

public class JcrUserRoleDao
extends AbstractJcrBackedUserRoleDao {
    NameFactory NF = NameFactoryImpl.getInstance();
    Name P_PRINCIPAL_NAME = this.NF.create("internal", "principalName");
    JcrTemplate adminJcrTemplate;

    public JcrUserRoleDao(JcrTemplate adminJcrTemplate, ITenantedPrincipleNameResolver userNameUtils, ITenantedPrincipleNameResolver roleNameUtils, String authenticatedRoleName, String tenantAdminRoleName, String repositoryAdminUsername, IRepositoryFileAclDao repositoryFileAclDao, IRepositoryFileDao repositoryFileDao, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, IRepositoryDefaultAclHandler defaultAclHandler, List<String> systemRoles, List<String> extraRoles, UserCache userCache) throws NamespaceException {
        super(userNameUtils, roleNameUtils, authenticatedRoleName, tenantAdminRoleName, repositoryAdminUsername, repositoryFileAclDao, repositoryFileDao, pathConversionHelper, lockHelper, defaultAclHandler, systemRoles, extraRoles, userCache);
        this.adminJcrTemplate = adminJcrTemplate;
    }

    public void setRoleMembers(final ITenant tenant, final String roleName, final String[] memberUserNames) {
        try {
            this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    JcrUserRoleDao.this.setRoleMembers(session, tenant, roleName, memberUserNames);
                    return null;
                }
            });
        }
        catch (DataAccessException e) {
            if (e instanceof JcrSystemException && e.getCause() instanceof NotFoundException) {
                throw (NotFoundException)e.getCause();
            }
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0001_UPDATING_ROLE", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public void setUserRoles(final ITenant tenant, final String userName, final String[] roles) throws NotFoundException, UncategorizedUserRoleDaoException {
        try {
            this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    JcrUserRoleDao.this.setUserRoles(session, tenant, userName, roles);
                    return null;
                }
            });
        }
        catch (DataAccessException e) {
            if (e instanceof JcrSystemException && e.getCause() instanceof NotFoundException) {
                throw (NotFoundException)e.getCause();
            }
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0001_UPDATING_ROLE", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public IPentahoRole createRole(final ITenant tenant, final String roleName, final String description, final String[] memberUserNames) throws AlreadyExistsException, UncategorizedUserRoleDaoException {
        try {
            return (IPentahoRole)this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    return JcrUserRoleDao.this.createRole(session, tenant, roleName, description, memberUserNames);
                }
            });
        }
        catch (DataAccessException e) {
            if (e instanceof JcrSystemException && e.getCause() instanceof AuthorizableExistsException) {
                throw new AlreadyExistsException("");
            }
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0002_CREATING_ROLE", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public IPentahoUser createUser(final ITenant tenant, final String userName, final String password, final String description, final String[] roles) throws AlreadyExistsException, UncategorizedUserRoleDaoException {
        IPentahoUser user;
        try {
            user = (IPentahoUser)this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    return JcrUserRoleDao.this.createUser(session, tenant, userName, password, description, roles);
                }
            });
        }
        catch (DataAccessException e) {
            if (e instanceof JcrSystemException && e.getCause() instanceof AuthorizableExistsException) {
                throw new AlreadyExistsException("");
            }
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0003_CREATING_USER", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
        return user;
    }

    public void deleteRole(final IPentahoRole role) throws NotFoundException, UncategorizedUserRoleDaoException {
        try {
            this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    JcrUserRoleDao.this.deleteRole(session, role);
                    return null;
                }
            });
        }
        catch (DataAccessException e) {
            if (e instanceof JcrSystemException && e.getCause() instanceof NotFoundException) {
                throw (NotFoundException)e.getCause();
            }
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0004_DELETING_ROLE", new Object[]{role.getName(), e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public void deleteUser(final IPentahoUser user) throws NotFoundException, UncategorizedUserRoleDaoException {
        try {
            this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    JcrUserRoleDao.this.deleteUser(session, user);
                    return null;
                }
            });
        }
        catch (DataAccessException e) {
            if (e instanceof JcrSystemException && e.getCause() instanceof NotFoundException) {
                throw (NotFoundException)e.getCause();
            }
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0005_DELETING_USER", new Object[]{user.getUsername(), e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public List<IPentahoRole> getRoles() throws UncategorizedUserRoleDaoException {
        return this.getRoles(JcrTenantUtils.getTenant());
    }

    public List<IPentahoUser> getUsers() throws UncategorizedUserRoleDaoException {
        return this.getUsers(JcrTenantUtils.getTenant());
    }

    public void setRoleDescription(final ITenant tenant, final String roleName, final String description) throws NotFoundException, UncategorizedUserRoleDaoException {
        try {
            this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    JcrUserRoleDao.this.setRoleDescription(session, tenant, roleName, description);
                    return null;
                }
            });
        }
        catch (DataAccessException e) {
            if (e instanceof JcrSystemException && e.getCause() instanceof NotFoundException) {
                throw (NotFoundException)e.getCause();
            }
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0001_UPDATING_ROLE", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public void setUserDescription(final ITenant tenant, final String userName, final String description) throws NotFoundException, UncategorizedUserRoleDaoException {
        try {
            this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    JcrUserRoleDao.this.setUserDescription(session, tenant, userName, description);
                    return null;
                }
            });
        }
        catch (DataAccessException e) {
            if (e instanceof JcrSystemException && e.getCause() instanceof NotFoundException) {
                throw (NotFoundException)e.getCause();
            }
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0006_UPDATING_USER", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public void setPassword(final ITenant tenant, final String userName, final String password) throws NotFoundException, UncategorizedUserRoleDaoException {
        try {
            this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    JcrUserRoleDao.this.setPassword(session, tenant, userName, password);
                    return null;
                }
            });
        }
        catch (DataAccessException e) {
            if (e instanceof JcrSystemException && e.getCause() instanceof NotFoundException) {
                throw (NotFoundException)e.getCause();
            }
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0007_UPDATING_USER_PASSWORD", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public List<IPentahoRole> getRoles(ITenant tenant) throws UncategorizedUserRoleDaoException {
        return this.getRoles(tenant, false);
    }

    public List<IPentahoRole> getRoles(final ITenant tenant, final boolean includeSubtenants) throws UncategorizedUserRoleDaoException {
        try {
            return (List)this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    return JcrUserRoleDao.this.getRoles(session, tenant, includeSubtenants);
                }
            });
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0008_LISTING_ROLES", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public List<IPentahoUser> getUsers(ITenant tenant) throws UncategorizedUserRoleDaoException {
        return this.getUsers(tenant, false);
    }

    public List<IPentahoUser> getUsers(final ITenant tenant, final boolean includeSubtenants) throws UncategorizedUserRoleDaoException {
        try {
            return (List)this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    return JcrUserRoleDao.this.getUsers(session, tenant, includeSubtenants);
                }
            });
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0009_LISTING_USERS", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public IPentahoRole getRole(final ITenant tenant, final String name) throws UncategorizedUserRoleDaoException {
        try {
            return (IPentahoRole)this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    return JcrUserRoleDao.this.getRole(session, tenant, name);
                }
            });
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0010_GETTING_ROLE", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public IPentahoUser getUser(final ITenant tenant, final String name) throws UncategorizedUserRoleDaoException {
        try {
            return (IPentahoUser)this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    return JcrUserRoleDao.this.getUser(session, tenant, name);
                }
            });
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0010_GETTING_ROLE", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public List<IPentahoUser> getRoleMembers(final ITenant tenant, final String roleName) throws UncategorizedUserRoleDaoException {
        try {
            return (List)this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    return JcrUserRoleDao.this.getRoleMembers(session, tenant, roleName);
                }
            });
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0011_LISTING_ROLE_MEMBERS", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public List<IPentahoRole> getUserRoles(final ITenant tenant, final String userName) throws UncategorizedUserRoleDaoException {
        try {
            return (List)this.adminJcrTemplate.execute(new JcrCallback(){

                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    return JcrUserRoleDao.this.getUserRoles(session, tenant, userName);
                }
            });
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getInstance().getString("JcrUserRoleDao.ERROR_0011_LISTING_ROLE_MEMBERS", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }
}

