/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.model.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.query.model.Selection;

public class QueryModelMetaData
extends MemoryMetaData {
    private List<? extends Selection> columns;

    public QueryModelMetaData(Map columnsMap, Object[][] columnHeaders, Object[][] rowHeaders, List<? extends Selection> selections) {
        super(columnHeaders, rowHeaders);
        this.columns = selections;
        Object[][] newHeaders = columnHeaders;
        if (columnsMap != null) {
            Map<String, String> upperColumnMap = null;
            TreeSet<String> existingHeaders = new TreeSet<String>();
            newHeaders = new Object[columnHeaders.length][];
            String newHeader = null;
            for (int i = 0; i < columnHeaders.length; ++i) {
                newHeaders[i] = new Object[columnHeaders[i].length];
                for (int j = 0; j < columnHeaders[i].length; ++j) {
                    Object key = columnHeaders[i][j];
                    if (key == null) continue;
                    newHeader = (String)columnsMap.get(key.toString().toUpperCase());
                    if (newHeader == null) {
                        newHeader = (String)columnsMap.get(key.toString());
                    }
                    if (newHeader == null) {
                        if (upperColumnMap == null) {
                            upperColumnMap = this.upperCaseKeys(columnsMap);
                        }
                        newHeader = upperColumnMap.get(key.toString().toUpperCase());
                    }
                    if (newHeader == null) {
                        throw new RuntimeException(Messages.getErrorString("QueryModelMetaData.ERROR_0001_MetadataColumnNotFound", key.toString()));
                    }
                    newHeader = this.getUniqueHeader(newHeader, existingHeaders);
                    existingHeaders.add(newHeader);
                    newHeaders[i][j] = newHeader;
                }
            }
            this.columnHeaders = newHeaders;
        }
    }

    private Map<String, String> upperCaseKeys(Map<?, ?> source) {
        HashMap<String, String> result = new HashMap<String, String>(source.size());
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            String key = null;
            if (entry.getKey() != null) {
                key = String.valueOf(entry.getKey()).toUpperCase();
            }
            String value = null;
            if (entry.getValue() != null) {
                value = String.valueOf(entry.getValue());
            }
            result.put(key, value);
        }
        return result;
    }

    private String getUniqueHeader(String header, TreeSet<String> existingHeaders) {
        String newHeader = header;
        int count = 1;
        while (existingHeaders.contains(newHeader)) {
            newHeader = header + "_" + count++;
        }
        return newHeader;
    }

    public Object getAttribute(int rowNo, int columnNo, String attributeName) {
        if (rowNo == 0 && columnNo < this.columns.size()) {
            LogicalColumn column = this.columns.get(columnNo).getLogicalColumn();
            return column.getProperty(attributeName);
        }
        return null;
    }
}

