/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mondrian.rolap.SqlStatement;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class OracleDialect
extends JdbcDialectImpl {
    private final String flagsRegexp = "^(\\(\\?([a-zA-Z])\\)).*$";
    private final Pattern flagsPattern = Pattern.compile("^(\\(\\?([a-zA-Z])\\)).*$");
    private final String escapeRegexp = "(\\\\Q([^\\\\Q]+)\\\\E)";
    private final Pattern escapePattern = Pattern.compile("(\\\\Q([^\\\\Q]+)\\\\E)");
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(OracleDialect.class, Dialect.DatabaseProduct.ORACLE);

    public OracleDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public OracleDialect() {
    }

    @Override
    public boolean allowsAs() {
        return false;
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, " from dual", false);
    }

    @Override
    public boolean supportsGroupingSets() {
        return true;
    }

    @Override
    public String generateOrderByNulls(String expr, boolean ascending, boolean collateNullsLast) {
        return this.generateOrderByNullsAnsi(expr, ascending, collateNullsLast);
    }

    @Override
    public boolean allowsJoinOn() {
        return false;
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return true;
    }

    @Override
    public String generateRegularExpression(String source, String javaRegex) {
        String suffix;
        try {
            Pattern.compile(javaRegex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        Matcher flagsMatcher = this.flagsPattern.matcher(javaRegex);
        if (flagsMatcher.matches()) {
            StringBuilder suffixSb = new StringBuilder();
            String flags = flagsMatcher.group(2);
            if (flags.contains("i")) {
                suffixSb.append("i");
            }
            if (flags.contains("c")) {
                suffixSb.append("c");
            }
            if (flags.contains("m")) {
                suffixSb.append("m");
            }
            suffix = suffixSb.toString();
            javaRegex = javaRegex.substring(0, flagsMatcher.start(1)) + javaRegex.substring(flagsMatcher.end(1));
        } else {
            suffix = "";
        }
        Matcher escapeMatcher = this.escapePattern.matcher(javaRegex);
        while (escapeMatcher.find()) {
            javaRegex = javaRegex.replace(escapeMatcher.group(1), escapeMatcher.group(2));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("REGEXP_LIKE(");
        sb.append(source);
        sb.append(", ");
        this.quoteStringLiteral(sb, javaRegex);
        sb.append(", ");
        this.quoteStringLiteral(sb, suffix);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public SqlStatement.Type getType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        int columnType = metaData.getColumnType(columnIndex + 1);
        int precision = metaData.getPrecision(columnIndex + 1);
        int scale = metaData.getScale(columnIndex + 1);
        String columnName = metaData.getColumnName(columnIndex + 1);
        SqlStatement.Type type = columnType == 2 || columnType == 3 ? (scale == -127 && precision != 0 ? SqlStatement.Type.DOUBLE : (columnType == 2 && (scale == 0 || scale == -127) && precision == 0 && columnName.startsWith("m") ? SqlStatement.Type.OBJECT : (scale == -127 && precision == 0 ? SqlStatement.Type.INT : (scale == 0 && (precision == 38 || precision == 0) ? SqlStatement.Type.INT : (scale == 0 && precision <= 9 ? SqlStatement.Type.INT : SqlStatement.Type.DOUBLE))))) : super.getType(metaData, columnIndex);
        this.logTypeInfo(metaData, columnIndex, type);
        return type;
    }
}

