/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Access;
import mondrian.olap.Member;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.resource.MondrianResource;
import mondrian.rolap.DelegatingMemberReader;
import mondrian.rolap.DelegatingRolapMember;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

class RestrictedMemberReader
extends DelegatingMemberReader {
    private final Role.HierarchyAccess hierarchyAccess;
    private final boolean ragged;
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    final Role role;

    RestrictedMemberReader(MemberReader memberReader, Role role) {
        super(memberReader);
        this.role = role;
        RolapHierarchy hierarchy = memberReader.getHierarchy();
        this.ragged = hierarchy.isRagged();
        if (role.getAccessDetails(hierarchy) == null) {
            assert (this.ragged);
            this.hierarchyAccess = RoleImpl.createAllAccess(hierarchy);
        } else {
            this.hierarchyAccess = role.getAccessDetails(hierarchy);
        }
    }

    @Override
    public boolean setCache(MemberCache cache) {
        return false;
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        int i = 0;
        int increment = 1;
        if (n < 0) {
            increment = -1;
            n = -n;
        }
        while (i < n) {
            if ((member = this.memberReader.getLeadMember(member, increment)).isNull()) {
                return member;
            }
            if (!this.canSee(member)) continue;
            ++i;
        }
        return member;
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    @Override
    public Map<? extends Member, Access> getMemberChildren(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> fullChildren = new ArrayList<RolapMember>();
        this.memberReader.getMemberChildren(parentMember, fullChildren, constraint);
        return this.processMemberChildren(fullChildren, children, constraint);
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public Map<? extends Member, Access> getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> fullChildren = new ArrayList<RolapMember>();
        this.memberReader.getMemberChildren(parentMembers, fullChildren, constraint);
        return this.processMemberChildren(fullChildren, children, constraint);
    }

    private Map<RolapMember, Access> processMemberChildren(List<RolapMember> fullChildren, List<RolapMember> children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> grandChildren = null;
        LinkedHashMap<RolapMember, Access> memberToAccessMap = new LinkedHashMap<RolapMember, Access>();
        block3: for (int i = 0; i < fullChildren.size(); ++i) {
            RolapMember member = fullChildren.get(i);
            if (this.ragged && member.isHidden()) {
                fullChildren.remove(i);
                if (grandChildren == null) {
                    grandChildren = new ArrayList<RolapMember>();
                } else {
                    grandChildren.clear();
                }
                this.memberReader.getMemberChildren(member, grandChildren, constraint);
                fullChildren.addAll(i, grandChildren);
                --i;
                continue;
            }
            Access access = this.hierarchyAccess != null ? this.hierarchyAccess.getAccess(member) : Access.ALL;
            switch (access) {
                case NONE: {
                    continue block3;
                }
                default: {
                    children.add(member);
                    memberToAccessMap.put(member, access);
                }
            }
        }
        return memberToAccessMap;
    }

    private void filterMembers(List<RolapMember> members, List<RolapMember> filteredMembers) {
        for (RolapMember member : members) {
            if (!this.canSee(member)) continue;
            filteredMembers.add(member);
        }
    }

    private boolean canSee(RolapMember member) {
        if (this.ragged && member.isHidden()) {
            return false;
        }
        if (this.hierarchyAccess != null) {
            Access access = this.hierarchyAccess.getAccess(member);
            return access != Access.NONE;
        }
        return true;
    }

    @Override
    public List<RolapMember> getRootMembers() {
        int topLevelDepth = this.hierarchyAccess.getTopLevelDepth();
        if (topLevelDepth > 0) {
            RolapLevel topLevel = (RolapLevel)this.getHierarchy().getLevels()[topLevelDepth];
            List<RolapMember> memberList = this.getMembersInLevel(topLevel);
            if (memberList.isEmpty()) {
                throw MondrianResource.instance().HierarchyHasNoAccessibleMembers.ex(this.getHierarchy().getUniqueName());
            }
            return memberList;
        }
        return super.getRootMembers();
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, constraint);
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, TupleConstraint constraint) {
        if (this.hierarchyAccess != null) {
            int depth = level.getDepth();
            if (depth < this.hierarchyAccess.getTopLevelDepth()) {
                return Collections.emptyList();
            }
            if (depth > this.hierarchyAccess.getBottomLevelDepth()) {
                return Collections.emptyList();
            }
        }
        List<RolapMember> membersInLevel = this.memberReader.getMembersInLevel(level, constraint);
        ArrayList<RolapMember> filteredMembers = new ArrayList<RolapMember>();
        this.filterMembers(membersInLevel, filteredMembers);
        return filteredMembers;
    }

    @Override
    public RolapMember getDefaultMember() {
        Access i;
        RolapMember defaultMember = (RolapMember)this.getHierarchy().getDefaultMember();
        if (defaultMember != null && (i = this.hierarchyAccess.getAccess(defaultMember)) != Access.NONE) {
            return defaultMember;
        }
        List<RolapMember> rootMembers = this.getRootMembers();
        if (rootMembers.size() == 1) {
            return rootMembers.get(0);
        }
        return new MultiCardinalityDefaultMember(rootMembers.get(0));
    }

    @Override
    public RolapMember getMemberParent(RolapMember member) {
        RolapMember parentMember;
        for (parentMember = member.getParentMember(); parentMember != null && parentMember.isHidden(); parentMember = parentMember.getParentMember()) {
        }
        if (parentMember != null && this.hierarchyAccess.getAccess(parentMember) == Access.NONE) {
            return null;
        }
        return parentMember;
    }

    static class MultiCardinalityDefaultMember
    extends DelegatingRolapMember {
        protected MultiCardinalityDefaultMember(RolapMember member) {
            super(member);
        }
    }
}

