/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.AbstractColorChooserPanel;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ColorChooserMessages;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ColorChooserPane;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ColorSchema;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ExtendedColorModel;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.SwatchColorChooser;

public class ColorChooserDialog
extends CommonDialog {
    private ColorChooserPane colorChooserPane;

    public ColorChooserDialog() {
        this.init();
    }

    public ColorChooserDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public ColorChooserDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public void addColorChooserPanel(AbstractColorChooserPanel panel) {
        this.colorChooserPane.addColorChooserPanel(panel);
    }

    public AbstractColorChooserPanel getColorChooserPanel(int index) {
        return this.colorChooserPane.getColorChooserPanel(index);
    }

    public void clearSwatches() {
        this.colorChooserPane.clearSwatches();
    }

    public SwatchColorChooser getSwatchColorChooser() {
        return this.colorChooserPane.getSwatchColorChooser();
    }

    public int getColorChooserPanelCount() {
        return this.colorChooserPane.getColorChooserPanelCount();
    }

    public void removeAllColorChooserPanels() {
        this.colorChooserPane.removeAllColorChooserPanels();
    }

    public void removeColorChooserPanel(AbstractColorChooserPanel panel) {
        this.colorChooserPane.removeColorChooserPanel(panel);
    }

    public ExtendedColorModel getModel() {
        return this.colorChooserPane.getModel();
    }

    protected ColorChooserPane getColorChooserPane() {
        return this.colorChooserPane;
    }

    @Override
    protected void init() {
        this.setTitle(ColorChooserMessages.getInstance().getString("ColorChooserDialog.Title"));
        this.colorChooserPane = new ColorChooserPane();
        super.init();
    }

    @Override
    protected String getDialogId() {
        return "LibSwing.ColorChooser";
    }

    @Override
    protected Component createContentPane() {
        return this.colorChooserPane;
    }

    public Color performEdit(Color color, ColorSchema[] colorSchemas) {
        if (colorSchemas != null) {
            this.colorChooserPane.clearSwatches();
            for (ColorSchema colorSchema : colorSchemas) {
                this.colorChooserPane.addSwatches(colorSchema);
            }
        }
        this.getModel().setSelectedColor(color);
        if (this.performEdit()) {
            return this.getModel().getSelectedColor();
        }
        return null;
    }
}

