/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.util.Iterator;
import org.pentaho.dictionary.DictionaryHelper;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseLink;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.MetaverseObjectFactory;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class MetaverseBuilder
extends MetaverseObjectFactory
implements IMetaverseBuilder {
    private static final String ENTITY_PREFIX = "entity_";
    private static final String ENTITY_NODE_ID = "entity";
    private static final String SEPARATOR = "~";
    private Graph graph;
    private IMetaverseObjectFactory metaverseObjectFactory = this;

    public MetaverseBuilder(Graph graph) {
        this.graph = graph;
        this.registerStaticNodes();
    }

    protected void registerStaticNodes() {
        this.addEntityType("External Connection", null);
        this.addEntityType("Database Connection", "External Connection");
        this.addEntityType("Database Table", null);
        this.addEntityType("Database Column", null);
        this.addEntityType("MongoDB Connection", "External Connection");
        this.addEntityType("MongoDB Collection", null);
        this.addEntityType("Job", null);
        this.addEntityType("Job Entry", null);
        this.addEntityType("Logical Model", null);
        this.addEntityType("Transformation", null);
        this.addEntityType("Transformation Step", null);
        this.addEntityType("Transformation Stream field", null);
        this.addEntityType("User Content", null);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public IMetaverseBuilder addLink(IMetaverseLink link) {
        Vertex fromVertex = this.getVertexForNode(link.getFromNode());
        Vertex toVertex = this.getVertexForNode(link.getToNode());
        if (fromVertex == null) {
            fromVertex = this.addVertex(link.getFromNode());
            fromVertex.setProperty("virtual", (Object)true);
        }
        this.copyNodePropertiesToVertex(link.getFromNode(), fromVertex);
        if (toVertex == null) {
            toVertex = this.addVertex(link.getToNode());
            toVertex.setProperty("virtual", (Object)true);
        }
        this.copyNodePropertiesToVertex(link.getToNode(), toVertex);
        String label = link.getLabel();
        String edgeId = this.getEdgeId(fromVertex, label, toVertex);
        Edge edge = this.graph.getEdge((Object)edgeId);
        if (edge == null) {
            edge = this.graph.addEdge((Object)edgeId, fromVertex, toVertex, label);
            edge.setProperty("text", (Object)label);
        }
        this.copyLinkPropertiesToEdge(link, edge);
        return this;
    }

    protected String getEdgeId(Vertex fromVertex, String label, Vertex toVertex) {
        return fromVertex.getId() + SEPARATOR + label + SEPARATOR + toVertex.getId();
    }

    public IMetaverseBuilder addNode(IMetaverseNode node) {
        Vertex v = this.getVertexForNode(node);
        if (v == null) {
            v = this.addVertex(node);
        }
        v.setProperty("virtual", (Object)false);
        this.copyNodePropertiesToVertex(node, v);
        return this;
    }

    private Vertex addVertex(IMetaverseNode node) {
        Vertex v = this.graph.addVertex((Object)node.getStringID());
        if (DictionaryHelper.isEntityType((String)node.getType())) {
            this.graph.addEdge(null, this.addEntityType(node.getType(), null), v, "parentconcept");
        }
        return v;
    }

    protected Vertex addEntityType(String entityName, String parent) {
        if (this.graph == null) {
            return null;
        }
        Vertex entityType = this.graph.getVertex((Object)(ENTITY_PREFIX + entityName));
        if (entityType == null) {
            Vertex rootEntity;
            DictionaryHelper.registerEntityType((String)entityName);
            entityType = this.graph.addVertex((Object)(ENTITY_PREFIX + entityName));
            entityType.setProperty("type", (Object)"Entity");
            entityType.setProperty("name", (Object)entityName);
            if (entityName.equals("Transformation") || entityName.equals("Job")) {
                entityType.setProperty("description", (Object)"Pentaho Data Integration");
            }
            if ((rootEntity = this.graph.getVertex((Object)ENTITY_NODE_ID)) == null) {
                rootEntity = this.createRootEntity();
            }
            if (parent != null) {
                Vertex parentEntity = this.addEntityType(parent, null);
                this.addLink(parentEntity, "parentconcept", entityType);
            } else {
                this.addLink(rootEntity, "parentconcept", entityType);
            }
        }
        return entityType;
    }

    protected Vertex createRootEntity() {
        Vertex rootEntity = this.graph.getVertex((Object)ENTITY_NODE_ID);
        if (rootEntity == null) {
            rootEntity = this.graph.addVertex((Object)ENTITY_NODE_ID);
            rootEntity.setProperty("type", (Object)"Root_Entity");
            rootEntity.setProperty("name", (Object)"METAVERSE");
            rootEntity.setProperty("division", (Object)"Engineering");
            rootEntity.setProperty("project", (Object)"Pentaho Data Lineage");
            rootEntity.setProperty("description", (Object)"Data lineage is tracing the path that data has traveled upstream from its destination, through Pentaho systems and artifacts as well as external systems and artifacts.");
        }
        return rootEntity;
    }

    private void copyNodePropertiesToVertex(IMetaverseNode node, Vertex v) {
        Boolean nodeIsVirtual = (Boolean)node.getProperty("virtual");
        nodeIsVirtual = nodeIsVirtual == null ? true : nodeIsVirtual;
        Boolean vertexIsVirtual = (Boolean)v.getProperty("virtual");
        vertexIsVirtual = vertexIsVirtual == null ? false : vertexIsVirtual;
        String vertexLogicalId = (String)v.getProperty("logicalId");
        boolean skipLogicalId = false;
        if (vertexLogicalId != null && nodeIsVirtual.booleanValue() && !vertexIsVirtual.booleanValue()) {
            skipLogicalId = true;
        }
        for (String propertyKey : node.getPropertyKeys()) {
            Object value;
            if (propertyKey.equals("id") || propertyKey.equals("virtual") || skipLogicalId && propertyKey.equals("logicalId") || (value = node.getProperty(propertyKey)) == null) continue;
            v.setProperty(propertyKey, value);
        }
        node.setDirty(false);
    }

    protected void copyLinkPropertiesToEdge(IMetaverseLink link, Edge e) {
        if (link != null && link.getPropertyKeys() != null && e != null) {
            for (String propertyKey : link.getPropertyKeys()) {
                Object value;
                if ("label".equals(propertyKey) || (value = link.getProperty(propertyKey)) == null) continue;
                e.setProperty(propertyKey, value);
            }
        }
    }

    protected Vertex getVertexForNode(IMetaverseNode node) {
        if (node != null) {
            Iterable logicalMatches;
            Iterator i$;
            String logicalId = node.getLogicalId();
            Vertex vertex = this.graph.getVertex((Object)node.getStringID());
            if (vertex == null && !logicalId.equals(node.getStringID()) && (i$ = (logicalMatches = this.graph.getVertices("logicalId", (Object)logicalId)).iterator()).hasNext()) {
                Vertex match;
                vertex = match = (Vertex)i$.next();
            }
            return vertex;
        }
        return null;
    }

    public IMetaverseBuilder deleteLink(IMetaverseLink link) {
        this.deleteLink(link, true);
        return this;
    }

    private boolean deleteLink(IMetaverseLink link, boolean removeVirtualNodes) {
        if (link == null) {
            return false;
        }
        Vertex fromVertex = this.getVertexForNode(link.getFromNode());
        Vertex toVertex = null;
        Edge deleteMe = null;
        boolean result = false;
        if (fromVertex != null) {
            for (Edge edge : fromVertex.getEdges(Direction.OUT, new String[]{link.getLabel()})) {
                toVertex = edge.getVertex(Direction.IN);
                if (!toVertex.getId().equals(link.getToNode().getStringID())) continue;
                deleteMe = edge;
                break;
            }
            if (deleteMe != null) {
                this.graph.removeEdge(deleteMe);
                result = true;
            }
            if (removeVirtualNodes) {
                Vertex[] fromAndTo;
                for (Vertex v : fromAndTo = new Vertex[]{fromVertex, toVertex}) {
                    if (!this.isVirtual(v)) continue;
                    this.graph.removeVertex(v);
                }
            }
        }
        return result;
    }

    public IMetaverseBuilder deleteNode(IMetaverseNode node) {
        Vertex v = this.getVertexForNode(node);
        if (v != null) {
            this.graph.removeVertex(v);
        }
        return this;
    }

    public IMetaverseBuilder updateLinkLabel(IMetaverseLink link, String label) {
        if (label != null && this.deleteLink(link, false)) {
            link.setLabel(label);
            this.addLink(link);
        }
        return this;
    }

    public IMetaverseObjectFactory getMetaverseObjectFactory() {
        if (this.metaverseObjectFactory == null) {
            IMetaverseObjectFactory pentahoSystemMetaverseObjectFactory = (IMetaverseObjectFactory)PentahoSystem.get(IMetaverseObjectFactory.class);
            this.metaverseObjectFactory = pentahoSystemMetaverseObjectFactory != null ? pentahoSystemMetaverseObjectFactory : this;
        }
        return this.metaverseObjectFactory;
    }

    public void setMetaverseObjectFactory(IMetaverseObjectFactory metaverseObjectFactory) {
        this.metaverseObjectFactory = metaverseObjectFactory;
    }

    public IMetaverseBuilder updateNode(IMetaverseNode node) {
        Vertex v = this.getVertexForNode(node);
        if (v != null) {
            this.copyNodePropertiesToVertex(node, v);
        }
        return this;
    }

    public IMetaverseBuilder addLink(IMetaverseNode fromNode, String label, IMetaverseNode toNode) {
        IMetaverseLink link = this.createLinkObject();
        link.setFromNode(fromNode);
        link.setLabel(label);
        link.setToNode(toNode);
        return this.addLink(link);
    }

    protected void addLink(Vertex fromVertex, String label, Vertex toVertex) {
        String edgeId = this.getEdgeId(fromVertex, label, toVertex);
        if (this.graph.getEdge((Object)edgeId) == null) {
            Edge e = this.graph.addEdge((Object)edgeId, fromVertex, toVertex, label);
            e.setProperty("text", (Object)label);
        }
    }

    protected boolean isVirtual(Vertex vertex) {
        if (vertex == null) {
            return false;
        }
        Boolean isVirtual = (Boolean)vertex.getProperty("virtual");
        return isVirtual == null ? false : isVirtual;
    }
}

