/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl;

import com.tinkerpop.blueprints.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IDocumentAnalyzer;
import org.pentaho.metaverse.api.IDocumentController;
import org.pentaho.metaverse.api.IDocumentEvent;
import org.pentaho.metaverse.api.IDocumentListener;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseLink;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.IRequiresMetaverseBuilder;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.impl.MetaverseCompletionService;
import org.pentaho.metaverse.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentController
implements IDocumentController,
IDocumentListener,
IRequiresMetaverseBuilder {
    private IMetaverseBuilder metaverseBuilder;
    private IMetaverseObjectFactory metaverseObjectFactory;
    private List<IDocumentAnalyzer> documentAnalyzers = new ArrayList<IDocumentAnalyzer>();
    private Map<String, HashSet<IDocumentAnalyzer>> analyzerTypeMap = new HashMap<String, HashSet<IDocumentAnalyzer>>();
    private static final Logger log = LoggerFactory.getLogger(DocumentController.class);

    public DocumentController() {
    }

    public DocumentController(IMetaverseBuilder metaverseBuilder) {
        this.metaverseBuilder = metaverseBuilder;
    }

    public IMetaverseBuilder getMetaverseBuilder() {
        return this.metaverseBuilder;
    }

    public void setMetaverseBuilder(IMetaverseBuilder metaverseBuilder) {
        this.metaverseBuilder = metaverseBuilder;
    }

    public IMetaverseObjectFactory getMetaverseObjectFactory() {
        return this.metaverseBuilder == null ? null : this.metaverseBuilder.getMetaverseObjectFactory();
    }

    public void setMetaverseObjectFactory(IMetaverseObjectFactory metaverseObjectFactory) {
        if (this.metaverseBuilder != null) {
            this.metaverseBuilder.setMetaverseObjectFactory(metaverseObjectFactory);
        }
    }

    public Graph getGraph() {
        if (this.metaverseBuilder != null) {
            return this.metaverseBuilder.getGraph();
        }
        return null;
    }

    public void setGraph(Graph graph) {
        if (this.metaverseBuilder != null) {
            this.metaverseBuilder.setGraph(graph);
        }
    }

    public List<IDocumentAnalyzer> getAnalyzers() {
        return this.documentAnalyzers;
    }

    public List<IDocumentAnalyzer> getDocumentAnalyzers(String type) {
        if (type == null) {
            return this.getAnalyzers();
        }
        HashSet<IDocumentAnalyzer> documentAnalyzerHashSet = this.analyzerTypeMap.get(type);
        ArrayList<IDocumentAnalyzer> docAnalyzers = null;
        if (documentAnalyzerHashSet != null) {
            docAnalyzers = new ArrayList<IDocumentAnalyzer>(documentAnalyzerHashSet);
        }
        return docAnalyzers;
    }

    public List<IDocumentAnalyzer> getAnalyzers(Collection<Class<?>> types) {
        if (types == null || types.size() == 1 && types.contains(IDocumentAnalyzer.class)) {
            return this.getAnalyzers();
        }
        return null;
    }

    public void setDocumentAnalyzers(List<IDocumentAnalyzer> documentAnalyzers) {
        this.documentAnalyzers = documentAnalyzers;
        this.loadAnalyzerTypeMap();
    }

    public void onEvent(IDocumentEvent event) {
        List<IDocumentAnalyzer> matchingAnalyzers = this.getDocumentAnalyzers(event.getDocument().getExtension());
        if (matchingAnalyzers != null) {
            for (IDocumentAnalyzer analyzer : matchingAnalyzers) {
                this.fireDocumentEvent(event, analyzer);
            }
        } else {
            log.warn(Messages.getString("WARNING.NoMatchingDocumentAnalyzerFound", event.getDocument().getExtension()));
        }
    }

    protected void loadAnalyzerTypeMap() {
        this.analyzerTypeMap = new HashMap<String, HashSet<IDocumentAnalyzer>>();
        for (IDocumentAnalyzer analyzer : this.documentAnalyzers) {
            this.addAnalyzer(analyzer);
        }
    }

    public void addAnalyzer(IDocumentAnalyzer analyzer) {
        if (!this.documentAnalyzers.contains(analyzer)) {
            this.documentAnalyzers.add(analyzer);
        }
        Set types = analyzer.getSupportedTypes();
        analyzer.setMetaverseBuilder((IMetaverseBuilder)this);
        if (types != null) {
            for (String type : types) {
                HashSet<IDocumentAnalyzer> analyzerSet = null;
                analyzerSet = this.analyzerTypeMap.containsKey(type) ? this.analyzerTypeMap.get(type) : new HashSet<IDocumentAnalyzer>();
                analyzerSet.add(analyzer);
                this.analyzerTypeMap.put(type, analyzerSet);
            }
        }
    }

    public void removeAnalyzer(IDocumentAnalyzer analyzer) {
        if (this.documentAnalyzers.contains(analyzer)) {
            try {
                this.documentAnalyzers.remove(analyzer);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (analyzer != null) {
            Set types = analyzer.getSupportedTypes();
            analyzer.setMetaverseBuilder((IMetaverseBuilder)this);
            if (types != null) {
                for (String type : types) {
                    HashSet<IDocumentAnalyzer> analyzerSet = null;
                    if (!this.analyzerTypeMap.containsKey(type)) continue;
                    analyzerSet = this.analyzerTypeMap.get(type);
                    analyzerSet.remove(analyzer);
                    if (analyzerSet.size() != 0) continue;
                    this.analyzerTypeMap.remove(type);
                }
            }
        }
    }

    protected Future<?> fireDocumentEvent(final IDocumentEvent event, final IDocumentAnalyzer analyzer) {
        Runnable analyzerRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    analyzer.analyze((IComponentDescriptor)new MetaverseComponentDescriptor(event.getDocument().getName(), event.getDocument().getType(), (INamespace)event.getDocument()), (Object)event.getDocument());
                }
                catch (MetaverseAnalyzerException mae) {
                    log.error(Messages.getString("ERROR.AnalyzingDocument", event.getDocument().getStringID()), (Throwable)mae);
                }
            }
        };
        return MetaverseCompletionService.getInstance().submit(analyzerRunner, event.getDocument().getStringID());
    }

    public IMetaverseBuilder addNode(IMetaverseNode iMetaverseNode) {
        return this.metaverseBuilder.addNode(iMetaverseNode);
    }

    public IMetaverseBuilder addLink(IMetaverseLink iMetaverseLink) {
        return this.metaverseBuilder.addLink(iMetaverseLink);
    }

    public IMetaverseBuilder deleteNode(IMetaverseNode iMetaverseNode) {
        return this.metaverseBuilder.deleteNode(iMetaverseNode);
    }

    public IMetaverseBuilder deleteLink(IMetaverseLink iMetaverseLink) {
        return this.metaverseBuilder.deleteLink(iMetaverseLink);
    }

    public IMetaverseBuilder updateNode(IMetaverseNode iMetaverseNode) {
        return this.metaverseBuilder.updateNode(iMetaverseNode);
    }

    public IMetaverseBuilder updateLinkLabel(IMetaverseLink iMetaverseLink, String newLabel) {
        return this.metaverseBuilder.updateLinkLabel(iMetaverseLink, newLabel);
    }

    public IMetaverseBuilder addLink(IMetaverseNode fromNode, String label, IMetaverseNode toNode) {
        return this.metaverseBuilder.addLink(fromNode, label, toNode);
    }
}

