/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.readonly;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.readonly.ReadOnlyEdgeIterable;
import com.tinkerpop.blueprints.util.wrappers.readonly.ReadOnlyVertexIterable;

class ReadOnlyIndex<T extends Element>
implements Index<T> {
    protected final Index<T> rawIndex;

    protected ReadOnlyIndex(Index<T> rawIndex) {
        this.rawIndex = rawIndex;
    }

    @Override
    public void remove(String key, Object value, T element) {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public void put(String key, Object value, T element) {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public CloseableIterable<T> get(String key, Object value) {
        if (Vertex.class.isAssignableFrom(this.getIndexClass())) {
            return new ReadOnlyVertexIterable(this.rawIndex.get(key, value));
        }
        return new ReadOnlyEdgeIterable(this.rawIndex.get(key, value));
    }

    @Override
    public CloseableIterable<T> query(String key, Object query) {
        if (Vertex.class.isAssignableFrom(this.getIndexClass())) {
            return new ReadOnlyVertexIterable(this.rawIndex.query(key, query));
        }
        return new ReadOnlyEdgeIterable(this.rawIndex.query(key, query));
    }

    @Override
    public long count(String key, Object value) {
        return this.rawIndex.count(key, value);
    }

    @Override
    public String getIndexName() {
        return this.rawIndex.getIndexName();
    }

    @Override
    public Class<T> getIndexClass() {
        return this.rawIndex.getIndexClass();
    }

    public String toString() {
        return StringFactory.indexString(this);
    }
}

