/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.auth.TSetIpAddressProcessor;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.log.LogManager;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionHook;
import org.apache.hive.service.cli.session.HiveSessionHookContextImpl;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.session.HiveSessionImplwithUGI;
import org.apache.hive.service.cli.session.HiveSessionProxy;
import org.apache.hive.service.cli.thrift.TProtocolVersion;

public class SessionManager
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(CompositeService.class);
    private HiveConf hiveConf;
    private final Map<SessionHandle, HiveSession> handleToSession = new ConcurrentHashMap<SessionHandle, HiveSession>();
    private final OperationManager operationManager = new OperationManager();
    private LogManager logManager = new LogManager();
    private ThreadPoolExecutor backgroundOperationPool;
    private static ThreadLocal<String> threadLocalIpAddress = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> threadLocalUserName = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> threadLocalProxyUserName = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };

    public SessionManager() {
        super("SessionManager");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        try {
            this.applyAuthorizationConfigPolicy(hiveConf);
        }
        catch (HiveException e) {
            throw new RuntimeException("Error applying authorization policy on hive configuration", e);
        }
        this.hiveConf = hiveConf;
        int backgroundPoolSize = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS);
        LOG.info((Object)("HiveServer2: Async execution thread pool size: " + backgroundPoolSize));
        int backgroundPoolQueueSize = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_WAIT_QUEUE_SIZE);
        LOG.info((Object)("HiveServer2: Async execution wait queue size: " + backgroundPoolQueueSize));
        int keepAliveTime = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_KEEPALIVE_TIME);
        LOG.info((Object)("HiveServer2: Async execution thread keepalive time: " + keepAliveTime));
        this.backgroundOperationPool = new ThreadPoolExecutor(backgroundPoolSize, backgroundPoolSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(backgroundPoolQueueSize));
        this.backgroundOperationPool.allowCoreThreadTimeOut(true);
        this.addService(this.operationManager);
        this.logManager = new LogManager();
        this.logManager.setSessionManager(this);
        this.addService(this.logManager);
        super.init(hiveConf);
    }

    private void applyAuthorizationConfigPolicy(HiveConf newHiveConf) throws HiveException {
        SessionState ss = SessionState.start((HiveConf)newHiveConf);
        ss.applyAuthorizationPolicy();
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        if (this.backgroundOperationPool != null) {
            this.backgroundOperationPool.shutdown();
            int timeout = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT);
            try {
                this.backgroundOperationPool.awaitTermination(timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT = " + timeout + " seconds has been exceeded. RUNNING background operations will be shut down"), (Throwable)e);
            }
        }
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, Map<String, String> sessionConf) throws HiveSQLException {
        return this.openSession(protocol, username, password, sessionConf, false, null);
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, Map<String, String> sessionConf, boolean withImpersonation, String delegationToken) throws HiveSQLException {
        HiveSession session;
        if (withImpersonation) {
            HiveSessionImplwithUGI hiveSessionUgi = new HiveSessionImplwithUGI(protocol, username, password, this.hiveConf, sessionConf, TSetIpAddressProcessor.getUserIpAddress(), delegationToken);
            session = HiveSessionProxy.getProxy(hiveSessionUgi, hiveSessionUgi.getSessionUgi());
            hiveSessionUgi.setProxySession(session);
        } else {
            session = new HiveSessionImpl(protocol, username, password, this.hiveConf, sessionConf, TSetIpAddressProcessor.getUserIpAddress());
        }
        session.setSessionManager(this);
        session.setOperationManager(this.operationManager);
        session.setLogManager(this.logManager);
        session.open();
        this.handleToSession.put(session.getSessionHandle(), session);
        try {
            this.executeSessionHooks(session);
        }
        catch (Exception e) {
            throw new HiveSQLException("Failed to execute session hooks", e);
        }
        return session.getSessionHandle();
    }

    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session = this.handleToSession.remove(sessionHandle);
        if (session == null) {
            throw new HiveSQLException("Session does not exist!");
        }
        session.close();
    }

    public HiveSession getSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session = this.handleToSession.get(sessionHandle);
        if (session == null) {
            throw new HiveSQLException("Invalid SessionHandle: " + sessionHandle);
        }
        return session;
    }

    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public static void setIpAddress(String ipAddress) {
        threadLocalIpAddress.set(ipAddress);
    }

    public static void clearIpAddress() {
        threadLocalIpAddress.remove();
    }

    public static String getIpAddress() {
        return threadLocalIpAddress.get();
    }

    public static void setUserName(String userName) {
        threadLocalUserName.set(userName);
    }

    public static void clearUserName() {
        threadLocalUserName.remove();
    }

    public static String getUserName() {
        return threadLocalUserName.get();
    }

    public static void setProxyUserName(String userName) {
        LOG.debug((Object)("setting proxy user name based on query param to: " + userName));
        threadLocalProxyUserName.set(userName);
    }

    public static String getProxyUserName() {
        return threadLocalProxyUserName.get();
    }

    public static void clearProxyUserName() {
        threadLocalProxyUserName.remove();
    }

    private void executeSessionHooks(HiveSession session) throws Exception {
        List sessionHooks = HookUtils.getHooks((HiveConf)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_SESSION_HOOK, HiveSessionHook.class);
        for (HiveSessionHook sessionHook : sessionHooks) {
            sessionHook.run(new HiveSessionHookContextImpl(session));
        }
    }

    public Future<?> submitBackgroundOperation(Runnable r) {
        return this.backgroundOperationPool.submit(r);
    }
}

