/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.PigWarning;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.builtin.FuncUtils;
import org.apache.pig.builtin.JsonMetadata;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonLoader
extends LoadFunc
implements LoadMetadata {
    protected RecordReader reader = null;
    protected ResourceSchema schema = null;
    private String udfcSignature = null;
    private JsonFactory jsonFactory = null;
    private TupleFactory tupleFactory = TupleFactory.getInstance();
    private BagFactory bagFactory = BagFactory.getInstance();
    private static final String SCHEMA_SIGNATURE = "pig.jsonloader.schema";

    public JsonLoader() {
    }

    public JsonLoader(String schemaString) throws IOException {
        this.schema = new ResourceSchema(Utils.parseSchema(schemaString));
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    @Override
    public InputFormat getInputFormat() throws IOException {
        return new TextInputFormat();
    }

    @Override
    public LoadCaster getLoadCaster() throws IOException {
        return null;
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.reader = reader;
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(this.getClass(), new String[]{this.udfcSignature});
        String strSchema = p.getProperty(SCHEMA_SIGNATURE);
        if (strSchema == null) {
            throw new IOException("Could not find schema in UDF context");
        }
        this.schema = new ResourceSchema(Utils.getSchemaFromString(strSchema));
        this.jsonFactory = new JsonFactory();
    }

    @Override
    public Tuple getNext() throws IOException {
        Text val = null;
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            val = (Text)this.reader.getCurrentValue();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        byte[] newBytes = new byte[val.getLength()];
        System.arraycopy(val.getBytes(), 0, newBytes, 0, val.getLength());
        ByteArrayInputStream bais = new ByteArrayInputStream(newBytes);
        JsonParser p = this.jsonFactory.createJsonParser((InputStream)bais);
        ResourceSchema.ResourceFieldSchema[] fields = this.schema.getFields();
        Tuple t = this.tupleFactory.newTuple(fields.length);
        if (p.nextToken() != JsonToken.START_OBJECT) {
            this.warn("Bad record, could not find start of record " + val.toString(), PigWarning.UDF_WARNING_1);
            return t;
        }
        for (int i = 0; i < fields.length; ++i) {
            t.set(i, this.readField(p, fields[i], i));
        }
        if (p.nextToken() != JsonToken.END_OBJECT) {
            this.warn("Bad record, could not find end of record " + val.toString(), PigWarning.UDF_WARNING_1);
            return t;
        }
        p.close();
        return t;
    }

    private Object readField(JsonParser p, ResourceSchema.ResourceFieldSchema field, int fieldnum) throws IOException {
        JsonToken tok = p.nextToken();
        if (tok == null) {
            this.warn("Early termination of record, expected " + this.schema.getFields().length + " fields bug found " + fieldnum, PigWarning.UDF_WARNING_1);
            return null;
        }
        if (tok == JsonToken.VALUE_NULL) {
            return null;
        }
        switch (field.getType()) {
            case 5: {
                tok = p.nextToken();
                if (tok == JsonToken.VALUE_NULL) {
                    return null;
                }
                return p.getBooleanValue();
            }
            case 10: {
                tok = p.nextToken();
                if (tok == JsonToken.VALUE_NULL) {
                    return null;
                }
                return p.getIntValue();
            }
            case 15: {
                tok = p.nextToken();
                if (tok == JsonToken.VALUE_NULL) {
                    return null;
                }
                return p.getLongValue();
            }
            case 20: {
                tok = p.nextToken();
                if (tok == JsonToken.VALUE_NULL) {
                    return null;
                }
                return Float.valueOf(p.getFloatValue());
            }
            case 25: {
                tok = p.nextToken();
                if (tok == JsonToken.VALUE_NULL) {
                    return null;
                }
                return p.getDoubleValue();
            }
            case 30: {
                tok = p.nextToken();
                if (tok == JsonToken.VALUE_NULL) {
                    return null;
                }
                DateTimeFormatter formatter = ISODateTimeFormat.dateTimeParser();
                return formatter.withOffsetParsed().parseDateTime(p.getText());
            }
            case 50: {
                tok = p.nextToken();
                if (tok == JsonToken.VALUE_NULL) {
                    return null;
                }
                byte[] b = p.getText().getBytes();
                return new DataByteArray(b, 0, b.length);
            }
            case 55: {
                tok = p.nextToken();
                if (tok == JsonToken.VALUE_NULL) {
                    return null;
                }
                return p.getText();
            }
            case 65: {
                tok = p.nextToken();
                if (tok == JsonToken.VALUE_NULL) {
                    return null;
                }
                return p.getBigIntegerValue();
            }
            case 70: {
                tok = p.nextToken();
                if (tok == JsonToken.VALUE_NULL) {
                    return null;
                }
                return p.getDecimalValue();
            }
            case 100: {
                if (p.nextToken() != JsonToken.START_OBJECT) {
                    this.warn("Bad map field, could not find start of object, field " + fieldnum, PigWarning.UDF_WARNING_1);
                    return null;
                }
                HashMap<String, String> m = new HashMap<String, String>();
                while (p.nextToken() != JsonToken.END_OBJECT) {
                    String k = p.getCurrentName();
                    String v = p.getCurrentToken() == JsonToken.VALUE_NULL ? null : p.getText();
                    m.put(k, v);
                }
                return m;
            }
            case 110: {
                if (p.nextToken() != JsonToken.START_OBJECT) {
                    this.warn("Bad tuple field, could not find start of object, field " + fieldnum, PigWarning.UDF_WARNING_1);
                    return null;
                }
                ResourceSchema s = field.getSchema();
                ResourceSchema.ResourceFieldSchema[] fs = s.getFields();
                Tuple t = this.tupleFactory.newTuple(fs.length);
                for (int j = 0; j < fs.length; ++j) {
                    t.set(j, this.readField(p, fs[j], j));
                }
                if (p.nextToken() != JsonToken.END_OBJECT) {
                    this.warn("Bad tuple field, could not find end of object, field " + fieldnum, PigWarning.UDF_WARNING_1);
                    return null;
                }
                return t;
            }
            case 120: {
                JsonToken innerTok;
                if (p.nextToken() != JsonToken.START_ARRAY) {
                    this.warn("Bad bag field, could not find start of array, field " + fieldnum, PigWarning.UDF_WARNING_1);
                    return null;
                }
                ResourceSchema s = field.getSchema();
                ResourceSchema.ResourceFieldSchema[] fs = s.getFields();
                s = fs[0].getSchema();
                fs = s.getFields();
                DataBag bag = this.bagFactory.newDefaultBag();
                while ((innerTok = p.nextToken()) != JsonToken.END_ARRAY) {
                    if (innerTok != JsonToken.START_OBJECT) {
                        this.warn("Bad bag tuple field, could not find start of object, field " + fieldnum, PigWarning.UDF_WARNING_1);
                        return null;
                    }
                    Tuple t = this.tupleFactory.newTuple(fs.length);
                    for (int j = 0; j < fs.length; ++j) {
                        t.set(j, this.readField(p, fs[j], j));
                    }
                    if (p.nextToken() != JsonToken.END_OBJECT) {
                        this.warn("Bad bag tuple field, could not find end of object, field " + fieldnum, PigWarning.UDF_WARNING_1);
                        return null;
                    }
                    bag.add(t);
                }
                return bag;
            }
        }
        throw new IOException("Unknown type in input schema: " + field.getType());
    }

    @Override
    public void setUDFContextSignature(String signature) {
        this.udfcSignature = signature;
    }

    @Override
    public ResourceSchema getSchema(String location, Job job) throws IOException {
        ResourceSchema s;
        if (this.schema != null) {
            s = this.schema;
        } else {
            s = new JsonMetadata().getSchema(location, job, true);
            if (s == null) {
                throw new IOException("Unable to parse schema found in file in " + location);
            }
        }
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(this.getClass(), new String[]{this.udfcSignature});
        p.setProperty(SCHEMA_SIGNATURE, s.toString());
        return s;
    }

    @Override
    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    @Override
    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    @Override
    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    @Override
    public List<String> getShipFiles() {
        ArrayList cacheFiles = new ArrayList();
        Class[] classList = new Class[]{JsonFactory.class};
        return FuncUtils.getShipFiles(classList);
    }
}

