/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.Utils;

public class StoreFuncWrapper
implements StoreFuncInterface {
    private StoreFuncInterface storeFunc;

    protected StoreFuncWrapper() {
    }

    protected void setStoreFunc(StoreFuncInterface storeFunc) {
        this.storeFunc = storeFunc;
    }

    public String relToAbsPathForStoreLocation(String location, Path path) throws IOException {
        return this.storeFunc().relToAbsPathForStoreLocation(location, path);
    }

    public OutputFormat getOutputFormat() throws IOException {
        return this.storeFunc().getOutputFormat();
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        this.storeFunc().setStoreLocation(location, job);
    }

    public void checkSchema(ResourceSchema resourceSchema) throws IOException {
        this.storeFunc().checkSchema(resourceSchema);
    }

    public void prepareToWrite(RecordWriter recordWriter) throws IOException {
        this.storeFunc().prepareToWrite(recordWriter);
    }

    public void putNext(Tuple tuple) throws IOException {
        this.storeFunc().putNext(tuple);
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.storeFunc().setStoreFuncUDFContextSignature(signature);
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
        this.storeFunc().cleanupOnFailure(location, job);
    }

    public void cleanupOnSuccess(String location, Job job) throws IOException {
        this.storeFunc().cleanupOnSuccess(location, job);
    }

    private StoreFuncInterface storeFunc() {
        if (this.storeFunc == null) {
            throw new IllegalArgumentException("Method calls can not be made on the StoreFuncWrapper object before the wrapped StoreFuncInterface object has been set. Failed on method call " + this.getMethodName(1));
        }
        return this.storeFunc;
    }

    protected String getMethodName(int depth) {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        int index = Utils.isVendorIBM() ? 3 + depth : 2 + depth;
        return ste[index].getMethodName();
    }
}

