/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="next_day", value="_FUNC_(start_date, day_of_week) - Returns the first date which is later than start_date and named as indicated.", extended="start_date is a string in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. day_of_week is day of the week (e.g. Mo, tue, FRIDAY).Example:\n  > SELECT _FUNC_('2015-01-14', 'TU') FROM src LIMIT 1;\n '2015-01-20'")
public class GenericUDFNextDay
extends GenericUDF {
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private transient PrimitiveObjectInspectorConverter.TimestampConverter timestampConverter;
    private transient ObjectInspectorConverters.Converter textConverter0;
    private transient ObjectInspectorConverters.Converter textConverter1;
    private transient ObjectInspectorConverters.Converter dateWritableConverter;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType1;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType2;
    private final Calendar calendar = Calendar.getInstance();
    private final Text output = new Text();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("next_day() requires 2 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + arguments[0].getTypeName() + " is passed as first arguments");
        }
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + arguments[1].getTypeName() + " is passed as second arguments");
        }
        this.inputType1 = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        switch (this.inputType1) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                this.inputType1 = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                this.textConverter0 = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[0]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                break;
            }
            case TIMESTAMP: {
                this.timestampConverter = new PrimitiveObjectInspectorConverter.TimestampConverter((PrimitiveObjectInspector)arguments[0], PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                break;
            }
            case DATE: {
                this.dateWritableConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[0]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "next_day() only takes STRING/TIMESTAMP/DATEWRITABLE types as first argument, got " + (Object)((Object)this.inputType1));
            }
        }
        this.inputType2 = ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory();
        if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping(this.inputType2) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            throw new UDFArgumentTypeException(1, "next_day() only takes STRING_GROUP types as second argument, got " + (Object)((Object)this.inputType2));
        }
        this.textConverter1 = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[1]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Date date;
        if (arguments[0].get() == null || arguments[1].get() == null) {
            return null;
        }
        String dayOfWeek = this.textConverter1.convert(arguments[1].get()).toString();
        int dayOfWeekInt = this.getIntDayOfWeek(dayOfWeek);
        if (dayOfWeekInt == -1) {
            return null;
        }
        switch (this.inputType1) {
            case STRING: {
                String dateString = this.textConverter0.convert(arguments[0].get()).toString();
                try {
                    date = this.formatter.parse(dateString);
                    break;
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case TIMESTAMP: {
                Timestamp ts;
                date = ts = ((TimestampWritable)this.timestampConverter.convert(arguments[0].get())).getTimestamp();
                break;
            }
            case DATE: {
                DateWritable dw = (DateWritable)this.dateWritableConverter.convert(arguments[0].get());
                date = dw.get();
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "next_day() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + (Object)((Object)this.inputType1));
            }
        }
        this.nextDay(date, dayOfWeekInt);
        Date newDate = this.calendar.getTime();
        this.output.set(this.formatter.format(newDate));
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("next_day(");
        if (children.length > 0) {
            sb.append(children[0]);
            for (int i = 1; i < children.length; ++i) {
                sb.append(", ");
                sb.append(children[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected Calendar nextDay(Date date, int dayOfWeek) {
        this.calendar.setTime(date);
        int currDayOfWeek = this.calendar.get(7);
        int daysToAdd = currDayOfWeek < dayOfWeek ? dayOfWeek - currDayOfWeek : 7 - currDayOfWeek + dayOfWeek;
        this.calendar.add(5, daysToAdd);
        return this.calendar;
    }

    protected int getIntDayOfWeek(String dayOfWeek) throws UDFArgumentException {
        if (DayOfWeek.MON.matches(dayOfWeek)) {
            return 2;
        }
        if (DayOfWeek.TUE.matches(dayOfWeek)) {
            return 3;
        }
        if (DayOfWeek.WED.matches(dayOfWeek)) {
            return 4;
        }
        if (DayOfWeek.THU.matches(dayOfWeek)) {
            return 5;
        }
        if (DayOfWeek.FRI.matches(dayOfWeek)) {
            return 6;
        }
        if (DayOfWeek.SAT.matches(dayOfWeek)) {
            return 7;
        }
        if (DayOfWeek.SUN.matches(dayOfWeek)) {
            return 1;
        }
        return -1;
    }

    public static enum DayOfWeek {
        MON("MO", "MON", "MONDAY"),
        TUE("TU", "TUE", "TUESDAY"),
        WED("WE", "WED", "WEDNESDAY"),
        THU("TH", "THU", "THURSDAY"),
        FRI("FR", "FRI", "FRIDAY"),
        SAT("SA", "SAT", "SATURDAY"),
        SUN("SU", "SUN", "SUNDAY");

        private String name2;
        private String name3;
        private String fullName;

        private DayOfWeek(String name2, String name3, String fullName) {
            this.name2 = name2;
            this.name3 = name3;
            this.fullName = fullName;
        }

        public String getName2() {
            return this.name2;
        }

        public String getName3() {
            return this.name3;
        }

        public String getFullName() {
            return this.fullName;
        }

        public boolean matches(String dayOfWeek) {
            if (dayOfWeek.length() == 2) {
                return this.name2.equalsIgnoreCase(dayOfWeek);
            }
            if (dayOfWeek.length() == 3) {
                return this.name3.equalsIgnoreCase(dayOfWeek);
            }
            return this.fullName.equalsIgnoreCase(dayOfWeek);
        }
    }
}

