/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.DepthFirstWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCube;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.visitor.ProjectStarExpanderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectStarExpander
extends LogicalRelationalNodesVisitor {
    public ProjectStarExpander(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    @Override
    public void visit(LOSort sort) throws FrontendException {
        int i;
        List<LogicalExpressionPlan> expPlans = sort.getSortColPlans();
        List<Boolean> ascOrder = sort.getAscendingCols();
        ArrayList<LogicalExpressionPlan> newExpPlans = new ArrayList<LogicalExpressionPlan>();
        ArrayList<Boolean> newAscOrder = new ArrayList<Boolean>();
        if (expPlans.size() != ascOrder.size()) {
            throw new AssertionError((Object)"Size of expPlans and ascorder should be same");
        }
        for (i = 0; i < expPlans.size(); ++i) {
            LogicalExpressionPlan ithExpPlan = expPlans.get(i);
            List<LogicalExpressionPlan> expandedPlans = this.expandPlan(ithExpPlan, 0);
            newExpPlans.addAll(expandedPlans);
            Boolean isAsc = ascOrder.get(i);
            for (int j = 0; j < expandedPlans.size(); ++j) {
                newAscOrder.add(isAsc);
            }
        }
        for (i = 0; i < newExpPlans.size(); ++i) {
            ProjectExpression proj = this.getProjectStar((LogicalExpressionPlan)newExpPlans.get(i));
            if (proj == null || !proj.isRangeProject() || proj.getEndCol() != -1 || i == newExpPlans.size() - 1) continue;
            String msg = "Project-range to end (eg. x..) is supported in order-by only as last sort column";
            throw new FrontendException(msg, 1128, 2);
        }
        sort.setSortColPlans(newExpPlans);
        sort.setAscendingCols(newAscOrder);
    }

    @Override
    public void visit(LORank rank) throws FrontendException {
        int i;
        List<LogicalExpressionPlan> expPlans = rank.getRankColPlans();
        List<Boolean> ascOrder = rank.getAscendingCol();
        ArrayList<LogicalExpressionPlan> newExpPlans = new ArrayList<LogicalExpressionPlan>();
        ArrayList<Boolean> newAscOrder = new ArrayList<Boolean>();
        if (expPlans.size() != ascOrder.size()) {
            throw new AssertionError((Object)"Size of expPlans and ascorder should be same");
        }
        for (i = 0; i < expPlans.size(); ++i) {
            LogicalExpressionPlan ithExpPlan = expPlans.get(i);
            List<LogicalExpressionPlan> expandedPlans = this.expandPlan(ithExpPlan, 0);
            newExpPlans.addAll(expandedPlans);
            Boolean isAsc = ascOrder.get(i);
            for (int j = 0; j < expandedPlans.size(); ++j) {
                newAscOrder.add(isAsc);
            }
        }
        for (i = 0; i < newExpPlans.size(); ++i) {
            ProjectExpression proj = this.getProjectStar((LogicalExpressionPlan)newExpPlans.get(i));
            if (proj == null || !proj.isRangeProject() || proj.getEndCol() != -1 || i == newExpPlans.size() - 1) continue;
            String msg = "Project-range to end (eg. x..) is supported in rank-by only as last rank column";
            throw new FrontendException(msg, 1128, 2);
        }
        rank.setRankColPlan(newExpPlans);
        rank.setAscendingCol(newAscOrder);
    }

    private List<LogicalExpressionPlan> expandPlan(LogicalExpressionPlan plan, int inputNum) throws FrontendException {
        ProjectExpression projStar = this.getProjectStar(plan);
        if (projStar != null) {
            return this.expandPlan(plan, projStar, inputNum);
        }
        ArrayList<LogicalExpressionPlan> expandedPlans = new ArrayList<LogicalExpressionPlan>();
        expandedPlans.add(plan);
        return expandedPlans;
    }

    @Override
    public void visit(LOCogroup cg) throws FrontendException {
        MultiMap<Integer, LogicalExpressionPlan> inpExprPlans = cg.getExpressionPlans();
        this.expandPlans(inpExprPlans);
        List<Operator> inputs = cg.getInputs((LogicalPlan)cg.getPlan());
        if (inputs.size() > 1) {
            for (int i = 0; i < inputs.size(); ++i) {
                for (LogicalExpressionPlan lp : inpExprPlans.get(i)) {
                    if (this.getProjectStar(lp) == null) continue;
                    String msg = "Cogroup/Group by '*' or 'x..' (range of columns to the end) is only allowed if the input has a schema";
                    throw new VisitorException((Operator)cg, msg, 1123, 2);
                }
            }
        }
        int arity = inpExprPlans.get(0).size();
        for (int i = 1; i < inputs.size(); ++i) {
            if (arity == inpExprPlans.get(i).size()) continue;
            String msg = "The arity of cogroup/group by columns do not match";
            throw new VisitorException((Operator)cg, msg, 1122, 2);
        }
    }

    @Override
    public void visit(LOCube cu) throws FrontendException {
        MultiMap<Integer, LogicalExpressionPlan> inpExprPlans = cu.getExpressionPlans();
        this.expandPlans(inpExprPlans);
    }

    @Override
    public void visit(LOJoin join) throws FrontendException {
        this.expandPlans(join.getExpressionPlans());
    }

    @Override
    public void visit(LOForEach foreach) throws FrontendException {
        LogicalPlan innerPlan = foreach.getInnerPlan();
        PlanWalker newWalker = this.currentWalker.spawnChildWalker(innerPlan);
        this.pushWalker(newWalker);
        this.currentWalker.walk(this);
        this.popWalker();
        List<Operator> feOutputs = innerPlan.getSinks();
        LOGenerate gen = null;
        for (Operator op : feOutputs) {
            if (!(op instanceof LOGenerate)) continue;
            if (gen != null) {
                String msg = "Expected single LOGenerate output in innerplan of foreach";
                throw new VisitorException((Operator)foreach, msg, 2266, 4);
            }
            gen = (LOGenerate)op;
        }
        List<LogicalExpressionPlan> expPlans = gen.getOutputPlans();
        ArrayList<LogicalExpressionPlan> newExpPlans = new ArrayList<LogicalExpressionPlan>();
        List<Operator> loGenPreds = innerPlan.getPredecessors(gen);
        if (loGenPreds == null) {
            return;
        }
        List<LogicalSchema> userSchema = gen.getUserDefinedSchema();
        ArrayList<LogicalSchema> newUserSchema = null;
        if (userSchema != null) {
            newUserSchema = new ArrayList<LogicalSchema>();
        }
        boolean[] flattens = gen.getFlattenFlags();
        ArrayList<Boolean> newFlattens = new ArrayList<Boolean>(flattens.length);
        HashMap<Integer, LogicalRelationalOperator> oldPos2Rel = new HashMap<Integer, LogicalRelationalOperator>();
        for (int i = 0; i < loGenPreds.size(); ++i) {
            oldPos2Rel.put(i, (LogicalRelationalOperator)loGenPreds.get(i));
        }
        LogicalRelationalOperator pred = (LogicalRelationalOperator)foreach.getPlan().getPredecessors(foreach).get(0);
        LogicalSchema inpSch = pred.getSchema();
        HashMap<ProjectExpression, LOInnerLoad> proj2InpRel = new HashMap<ProjectExpression, LOInnerLoad>();
        for (int i = 0; i < expPlans.size(); ++i) {
            LogicalExpressionPlan expPlan = expPlans.get(i);
            ProjectExpression projStar = this.getProjectLonelyStar(expPlan, oldPos2Rel);
            boolean foundExpandableProject = false;
            if (projStar != null) {
                boolean isProjectToEnd;
                LogicalSchema userStarSch = null;
                if (userSchema != null && userSchema.get(i) != null) {
                    userStarSch = userSchema.get(i);
                }
                ProjectExpression loInnerProj = ((LOInnerLoad)oldPos2Rel.get(projStar.getInputNum())).getProjection();
                int firstProjCol = 0;
                int lastProjCol = 0;
                if (loInnerProj.isRangeProject()) {
                    loInnerProj.setColumnNumberFromAlias();
                    firstProjCol = loInnerProj.getStartCol();
                    lastProjCol = loInnerProj.getEndCol();
                }
                boolean bl = isProjectToEnd = loInnerProj.isProjectStar() || loInnerProj.isRangeProject() && lastProjCol == -1;
                if (inpSch != null || !isProjectToEnd) {
                    foundExpandableProject = true;
                    if (isProjectToEnd) {
                        lastProjCol = inpSch.size() - 1;
                    }
                    expPlan.remove(projStar);
                    LOInnerLoad oldLOInnerLoad = (LOInnerLoad)oldPos2Rel.get(projStar.getInputNum());
                    innerPlan.disconnect(oldLOInnerLoad, gen);
                    innerPlan.remove(oldLOInnerLoad);
                    for (int j = firstProjCol; j <= lastProjCol; ++j) {
                        LOInnerLoad newInLoad = new LOInnerLoad((OperatorPlan)innerPlan, foreach, j);
                        innerPlan.add(newInLoad);
                        innerPlan.connect(newInLoad, gen);
                        LogicalExpressionPlan newExpPlan = new LogicalExpressionPlan();
                        newExpPlans.add(newExpPlan);
                        ProjectExpression newProj = new ProjectExpression(newExpPlan, -2, -1, gen);
                        proj2InpRel.put(newProj, newInLoad);
                        newFlattens.add(flattens[i]);
                        if (newUserSchema == null) continue;
                        int schIdx = j - firstProjCol;
                        if (userStarSch != null && userStarSch.getFields().size() > schIdx && userStarSch.getField(schIdx) != null) {
                            LogicalSchema sch = new LogicalSchema();
                            sch.addField(new LogicalSchema.LogicalFieldSchema(userStarSch.getField(schIdx)));
                            newUserSchema.add(sch);
                            continue;
                        }
                        newUserSchema.add(null);
                    }
                }
            }
            if (foundExpandableProject) continue;
            FindProjects findProjs = new FindProjects(expPlan);
            findProjs.visit();
            List<ProjectExpression> projs = findProjs.getProjs();
            for (ProjectExpression proj : projs) {
                proj2InpRel.put(proj, (LOInnerLoad)oldPos2Rel.get(proj.getInputNum()));
            }
            newExpPlans.add(expPlan);
            newFlattens.add(flattens[i]);
            if (newUserSchema == null) continue;
            newUserSchema.add(userSchema.get(i));
        }
        HashMap<LogicalRelationalOperator, Integer> rel2pos = new HashMap<LogicalRelationalOperator, Integer>();
        List<Operator> newGenPreds = innerPlan.getPredecessors(gen);
        int numNewGenPreds = 0;
        if (newGenPreds != null) {
            numNewGenPreds = newGenPreds.size();
        }
        for (int i = 0; i < numNewGenPreds; ++i) {
            rel2pos.put((LogicalRelationalOperator)newGenPreds.get(i), i);
        }
        for (Map.Entry projAndInp : proj2InpRel.entrySet()) {
            ProjectExpression proj = (ProjectExpression)projAndInp.getKey();
            LogicalRelationalOperator rel = (LogicalRelationalOperator)projAndInp.getValue();
            proj.setInputNum((Integer)rel2pos.get(rel));
        }
        gen.setOutputPlans(newExpPlans);
        gen.setFlattenFlags(Booleans.toArray(newFlattens));
        gen.setUserDefinedSchema(newUserSchema);
        gen.resetSchema();
        foreach.resetSchema();
    }

    private ProjectExpression getProjectLonelyStar(LogicalExpressionPlan expPlan, Map<Integer, LogicalRelationalOperator> oldPos2Rel) throws FrontendException {
        ProjectExpression proj;
        if (expPlan.size() == 0 || expPlan.size() > 1) {
            return null;
        }
        Operator outputOp = expPlan.getOperators().next();
        if (outputOp instanceof ProjectExpression && (proj = (ProjectExpression)outputOp).isProjectStar()) {
            LogicalRelationalOperator inputRel = oldPos2Rel.get(proj.getInputNum());
            if (!(inputRel instanceof LOInnerLoad)) {
                return null;
            }
            ProjectExpression innerProj = ((LOInnerLoad)inputRel).getProjection();
            if (innerProj.isRangeOrStarProject()) {
                return proj;
            }
        }
        return null;
    }

    private void expandPlans(MultiMap<Integer, LogicalExpressionPlan> inpExprPlans) throws FrontendException {
        for (int i = 0; i < inpExprPlans.size(); ++i) {
            List<LogicalExpressionPlan> plans = inpExprPlans.get(i);
            ArrayList<LogicalExpressionPlan> newPlans = new ArrayList<LogicalExpressionPlan>();
            for (LogicalExpressionPlan plan : plans) {
                newPlans.addAll(this.expandPlan(plan, i));
            }
            inpExprPlans.removeKey(i);
            inpExprPlans.put((Integer)i, newPlans);
        }
    }

    private List<LogicalExpressionPlan> expandPlan(LogicalExpressionPlan expPlan, ProjectExpression proj, int inputNum) throws FrontendException {
        Pair<Integer, Integer> startAndEndProjs = ProjectStarExpanderUtil.getProjectStartEndCols(expPlan, proj);
        ArrayList<LogicalExpressionPlan> newPlans = new ArrayList<LogicalExpressionPlan>();
        if (startAndEndProjs == null) {
            newPlans.add(expPlan);
            return newPlans;
        }
        int firstProjCol = (Integer)startAndEndProjs.first;
        int lastProjCol = (Integer)startAndEndProjs.second;
        LogicalRelationalOperator relOp = proj.getAttachedRelationalOp();
        for (int i = firstProjCol; i <= lastProjCol; ++i) {
            newPlans.add(this.createExpPlanWithProj(relOp, inputNum, i));
        }
        return newPlans;
    }

    private LogicalExpressionPlan createExpPlanWithProj(LogicalRelationalOperator attachRel, int inputNum, int colNum) {
        LogicalExpressionPlan newExpPlan = new LogicalExpressionPlan();
        ProjectExpression newProj = new ProjectExpression(newExpPlan, inputNum, colNum, attachRel);
        newExpPlan.add(newProj);
        return newExpPlan;
    }

    private ProjectExpression getProjectStar(LogicalExpressionPlan expPlan) throws FrontendException {
        List<Operator> outputs = expPlan.getSources();
        ProjectExpression projStar = null;
        for (Operator outputOp : outputs) {
            ProjectExpression proj;
            if (!(outputOp instanceof ProjectExpression) || !(proj = (ProjectExpression)outputOp).isRangeOrStarProject()) continue;
            if (outputs.size() > 1) {
                String msg = "More than one operator in an expression plan containing project star(*)/project-range (..)";
                throw new VisitorException((Operator)proj, msg, 2264, 4);
            }
            projStar = proj;
        }
        return projStar;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FindProjects
    extends LogicalExpressionVisitor {
        private List<ProjectExpression> projs = new ArrayList<ProjectExpression>();

        protected FindProjects(LogicalExpressionPlan plan) throws FrontendException {
            super(plan, new DepthFirstWalker(plan));
        }

        @Override
        public void visit(ProjectExpression proj) {
            this.projs.add(proj);
        }

        public List<ProjectExpression> getProjs() {
            return this.projs;
        }
    }
}

