/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.BinSedesTuple;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.InternalMap;
import org.apache.pig.data.SchemaTupleFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.data.TupleRawComparator;
import org.apache.pig.data.TypeAwareTuple;
import org.apache.pig.data.utils.SedesHelper;
import org.apache.pig.impl.util.ObjectSerializer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Private
@InterfaceStability.Stable
public class BinInterSedes
implements InterSedes {
    private static final int ONE_MINUTE = 60000;
    public static final byte BOOLEAN_TRUE = 0;
    public static final byte BOOLEAN_FALSE = 1;
    public static final byte BYTE = 2;
    public static final byte INTEGER = 3;
    public static final byte INTEGER_0 = 4;
    public static final byte INTEGER_1 = 5;
    public static final byte INTEGER_INSHORT = 6;
    public static final byte INTEGER_INBYTE = 7;
    public static final byte LONG = 8;
    public static final byte FLOAT = 9;
    public static final byte DOUBLE = 10;
    public static final byte BYTEARRAY = 11;
    public static final byte SMALLBYTEARRAY = 12;
    public static final byte TINYBYTEARRAY = 13;
    public static final byte CHARARRAY = 14;
    public static final byte SMALLCHARARRAY = 15;
    public static final byte MAP = 16;
    public static final byte SMALLMAP = 17;
    public static final byte TINYMAP = 18;
    public static final byte TUPLE = 19;
    public static final byte SMALLTUPLE = 20;
    public static final byte TINYTUPLE = 21;
    public static final byte BAG = 22;
    public static final byte SMALLBAG = 23;
    public static final byte TINYBAG = 24;
    public static final byte GENERIC_WRITABLECOMPARABLE = 25;
    public static final byte INTERNALMAP = 26;
    public static final byte NULL = 27;
    public static final byte SCHEMA_TUPLE_BYTE_INDEX = 28;
    public static final byte SCHEMA_TUPLE_SHORT_INDEX = 29;
    public static final byte SCHEMA_TUPLE = 30;
    public static final byte LONG_INBYTE = 31;
    public static final byte LONG_INSHORT = 32;
    public static final byte LONG_ININT = 33;
    public static final byte LONG_0 = 34;
    public static final byte LONG_1 = 35;
    public static final byte TUPLE_0 = 36;
    public static final byte TUPLE_1 = 37;
    public static final byte TUPLE_2 = 38;
    public static final byte TUPLE_3 = 39;
    public static final byte TUPLE_4 = 40;
    public static final byte TUPLE_5 = 41;
    public static final byte TUPLE_6 = 42;
    public static final byte TUPLE_7 = 43;
    public static final byte TUPLE_8 = 44;
    public static final byte TUPLE_9 = 45;
    public static final byte BIGINTEGER = 46;
    public static final byte BIGDECIMAL = 47;
    public static final byte DATETIME = 48;
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private static BagFactory mBagFactory = BagFactory.getInstance();
    public static final int UNSIGNED_SHORT_MAX = 65535;
    public static final int UNSIGNED_BYTE_MAX = 255;
    public static final String UTF8 = "UTF-8";

    public Tuple readTuple(DataInput in, byte type) throws IOException {
        switch (type) {
            case 19: 
            case 20: 
            case 21: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return SedesHelper.readGenericTuple(in, type);
            }
            case 28: 
            case 29: 
            case 30: {
                return this.readSchemaTuple(in, type);
            }
        }
        throw new ExecException("Unknown Tuple type found in stream: " + type);
    }

    private Tuple readSchemaTuple(DataInput in, byte type) throws IOException {
        int id;
        switch (type) {
            case 28: {
                id = in.readUnsignedByte();
                break;
            }
            case 29: {
                id = in.readUnsignedShort();
                break;
            }
            case 30: {
                id = in.readInt();
                break;
            }
            default: {
                throw new RuntimeException("Invalid type given to readSchemaTuple: " + type);
            }
        }
        Tuple st = SchemaTupleFactory.getInstance(id).newTuple();
        st.readFields(in);
        return st;
    }

    public int getTupleSize(DataInput in, byte type) throws IOException {
        int sz;
        switch (type) {
            case 36: {
                return 0;
            }
            case 37: {
                return 1;
            }
            case 38: {
                return 2;
            }
            case 39: {
                return 3;
            }
            case 40: {
                return 4;
            }
            case 41: {
                return 5;
            }
            case 42: {
                return 6;
            }
            case 43: {
                return 7;
            }
            case 44: {
                return 8;
            }
            case 45: {
                return 9;
            }
            case 21: {
                sz = in.readUnsignedByte();
                break;
            }
            case 20: {
                sz = in.readUnsignedShort();
                break;
            }
            case 19: {
                sz = in.readInt();
                break;
            }
            default: {
                int errCode = 2112;
                String msg = "Unexpected datatype " + type + " while reading tuple" + "from binary file.";
                throw new ExecException(msg, errCode, 4);
            }
        }
        if (sz < 0) {
            throw new IOException("Invalid size " + sz + " for a tuple");
        }
        return sz;
    }

    private DataBag readBag(DataInput in, byte type) throws IOException {
        long size;
        DataBag bag = mBagFactory.newDefaultBag();
        switch (type) {
            case 24: {
                size = in.readUnsignedByte();
                break;
            }
            case 23: {
                size = in.readUnsignedShort();
                break;
            }
            case 22: {
                size = in.readLong();
                break;
            }
            default: {
                int errCode = 2219;
                String msg = "Unexpected data while reading bag from binary file.";
                throw new ExecException(msg, errCode, 4);
            }
        }
        for (long i = 0L; i < size; ++i) {
            Object o = this.readDatum(in);
            bag.add((Tuple)o);
            continue;
        }
        return bag;
    }

    private Map<String, Object> readMap(DataInput in, byte type) throws IOException {
        int size;
        switch (type) {
            case 18: {
                size = in.readUnsignedByte();
                break;
            }
            case 17: {
                size = in.readUnsignedShort();
                break;
            }
            case 16: {
                size = in.readInt();
                break;
            }
            default: {
                int errCode = 2220;
                String msg = "Unexpected data while reading mapfrom binary file.";
                throw new ExecException(msg, errCode, 4);
            }
        }
        HashMap<String, Object> m = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            String key = (String)this.readDatum(in);
            m.put(key, this.readDatum(in));
        }
        return m;
    }

    private InternalMap readInternalMap(DataInput in) throws IOException {
        int size = in.readInt();
        InternalMap m = new InternalMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = this.readDatum(in);
            m.put(key, this.readDatum(in));
        }
        return m;
    }

    private WritableComparable readWritable(DataInput in) throws IOException {
        String className = (String)this.readDatum(in);
        Class<?> objClass = null;
        try {
            objClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not find class " + className + ", while attempting to de-serialize it ", e);
        }
        WritableComparable writable = null;
        try {
            writable = (WritableComparable)objClass.newInstance();
        }
        catch (Exception e) {
            String msg = "Could create instance of class " + className + ", while attempting to de-serialize it. (no default constructor ?)";
            throw new IOException(msg, e);
        }
        writable.readFields(in);
        return writable;
    }

    @Override
    public Object readDatum(DataInput in) throws IOException, ExecException {
        byte b = in.readByte();
        return this.readDatum(in, b);
    }

    private static Object readBytes(DataInput in, int size) throws IOException {
        byte[] ba = new byte[size];
        in.readFully(ba);
        return new DataByteArray(ba);
    }

    @Override
    public Object readDatum(DataInput in, byte type) throws IOException, ExecException {
        switch (type) {
            case 19: 
            case 20: 
            case 21: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return SedesHelper.readGenericTuple(in, type);
            }
            case 22: 
            case 23: 
            case 24: {
                return this.readBag(in, type);
            }
            case 16: 
            case 17: 
            case 18: {
                return this.readMap(in, type);
            }
            case 26: {
                return this.readInternalMap(in);
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 7: {
                return (int)in.readByte();
            }
            case 6: {
                return (int)in.readShort();
            }
            case 3: {
                return in.readInt();
            }
            case 34: {
                return 0L;
            }
            case 35: {
                return 1L;
            }
            case 31: {
                return (long)in.readByte();
            }
            case 32: {
                return (long)in.readShort();
            }
            case 33: {
                return (long)in.readInt();
            }
            case 8: {
                return in.readLong();
            }
            case 48: {
                return new DateTime(in.readLong(), DateTimeZone.forOffsetMillis((int)(in.readShort() * 60000)));
            }
            case 9: {
                return Float.valueOf(in.readFloat());
            }
            case 10: {
                return in.readDouble();
            }
            case 46: {
                return this.readBigInteger(in);
            }
            case 47: {
                return this.readBigDecimal(in);
            }
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return in.readByte();
            }
            case 11: 
            case 12: 
            case 13: {
                return new DataByteArray(SedesHelper.readBytes(in, type));
            }
            case 14: 
            case 15: {
                return SedesHelper.readChararray(in, type);
            }
            case 25: {
                return this.readWritable(in);
            }
            case 28: 
            case 29: 
            case 30: {
                return this.readSchemaTuple(in, type);
            }
            case 27: {
                return null;
            }
        }
        throw new RuntimeException("Unexpected data type " + type + " found in stream.");
    }

    private Object readBigDecimal(DataInput in) throws IOException {
        return new BigDecimal((String)this.readDatum(in));
    }

    private Object readBigInteger(DataInput in) throws IOException {
        return new BigInteger((String)this.readDatum(in));
    }

    private void writeBigInteger(DataOutput out, BigInteger bi) throws IOException {
        this.writeDatum(out, bi.toString());
    }

    private void writeBigDecimal(DataOutput out, BigDecimal bd) throws IOException {
        this.writeDatum(out, bd.toString());
    }

    @Override
    public void writeDatum(DataOutput out, Object val) throws IOException {
        byte type = DataType.findType(val);
        this.writeDatum(out, val, type);
    }

    @Override
    public void writeDatum(DataOutput out, Object val, byte type) throws IOException {
        switch (type) {
            case 110: {
                this.writeTuple(out, (Tuple)val);
                break;
            }
            case 120: {
                this.writeBag(out, (DataBag)val);
                break;
            }
            case 100: {
                this.writeMap(out, (Map)val);
                break;
            }
            case 127: {
                out.writeByte(26);
                Map m = (Map)val;
                out.writeInt(m.size());
                for (Map.Entry entry : m.entrySet()) {
                    this.writeDatum(out, entry.getKey());
                    this.writeDatum(out, entry.getValue());
                }
                break;
            }
            case 10: {
                int i = (Integer)val;
                if (i == 0) {
                    out.writeByte(4);
                    break;
                }
                if (i == 1) {
                    out.writeByte(5);
                    break;
                }
                if (-128 <= i && i <= 127) {
                    out.writeByte(7);
                    out.writeByte(i);
                    break;
                }
                if (Short.MIN_VALUE <= i && i <= Short.MAX_VALUE) {
                    out.writeByte(6);
                    out.writeShort(i);
                    break;
                }
                out.writeByte(3);
                out.writeInt(i);
                break;
            }
            case 15: {
                long lng = (Long)val;
                if (lng == 0L) {
                    out.writeByte(34);
                    break;
                }
                if (lng == 1L) {
                    out.writeByte(35);
                    break;
                }
                if (-128L <= lng && lng <= 127L) {
                    out.writeByte(31);
                    out.writeByte((int)lng);
                    break;
                }
                if (-32768L <= lng && lng <= 32767L) {
                    out.writeByte(32);
                    out.writeShort((int)lng);
                    break;
                }
                if (Integer.MIN_VALUE <= lng && lng <= Integer.MAX_VALUE) {
                    out.writeByte(33);
                    out.writeInt((int)lng);
                    break;
                }
                out.writeByte(8);
                out.writeLong(lng);
                break;
            }
            case 30: {
                out.writeByte(48);
                out.writeLong(((DateTime)val).getMillis());
                out.writeShort(((DateTime)val).getZone().getOffset((ReadableInstant)((DateTime)val)) / 60000);
                break;
            }
            case 20: {
                out.writeByte(9);
                out.writeFloat(((Float)val).floatValue());
                break;
            }
            case 65: {
                out.writeByte(46);
                this.writeBigInteger(out, (BigInteger)val);
                break;
            }
            case 70: {
                out.writeByte(47);
                this.writeBigDecimal(out, (BigDecimal)val);
                break;
            }
            case 25: {
                out.writeByte(10);
                out.writeDouble((Double)val);
                break;
            }
            case 5: {
                if (((Boolean)val).booleanValue()) {
                    out.writeByte(0);
                    break;
                }
                out.writeByte(1);
                break;
            }
            case 6: {
                out.writeByte(2);
                out.writeByte(((Byte)val).byteValue());
                break;
            }
            case 50: {
                DataByteArray bytes = (DataByteArray)val;
                SedesHelper.writeBytes(out, bytes.mData);
                break;
            }
            case 55: {
                SedesHelper.writeChararray(out, (String)val);
                break;
            }
            case 123: {
                out.writeByte(25);
                this.writeDatum(out, val.getClass().getName());
                Writable writable = (Writable)val;
                writable.write(out);
                break;
            }
            case 1: {
                out.writeByte(27);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected data type " + val.getClass().getName() + " found in stream. " + "Note only standard Pig type is supported when you output from UDF/LoadFunc");
            }
        }
    }

    private void writeMap(DataOutput out, Map<String, Object> m) throws IOException {
        int sz = m.size();
        if (sz < 255) {
            out.writeByte(18);
            out.writeByte(sz);
        } else if (sz < 65535) {
            out.writeByte(17);
            out.writeShort(sz);
        } else {
            out.writeByte(16);
            out.writeInt(sz);
        }
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            this.writeDatum(out, entry.getKey());
            this.writeDatum(out, entry.getValue());
        }
    }

    private void writeBag(DataOutput out, DataBag bag) throws IOException {
        long sz = bag.size();
        if (sz < 255L) {
            out.writeByte(24);
            out.writeByte((int)sz);
        } else if (sz < 65535L) {
            out.writeByte(23);
            out.writeShort((int)sz);
        } else {
            out.writeByte(22);
            out.writeLong(sz);
        }
        Iterator<Tuple> it = bag.iterator();
        while (it.hasNext()) {
            this.writeTuple(out, it.next());
        }
    }

    private void writeTuple(DataOutput out, Tuple t) throws IOException {
        if (t instanceof TypeAwareTuple) {
            t.write(out);
        } else {
            SedesHelper.writeGenericTuple(out, t);
        }
    }

    @Override
    public void addColsToTuple(DataInput in, Tuple t) throws IOException {
        byte type = in.readByte();
        int sz = this.getTupleSize(in, type);
        for (int i = 0; i < sz; ++i) {
            t.append(this.readDatum(in));
        }
    }

    @Override
    public Class<? extends TupleRawComparator> getTupleRawComparatorClass() {
        return BinInterSedesTupleRawComparator.class;
    }

    public Tuple readTuple(DataInput in) throws IOException {
        return this.readTuple(in, in.readByte());
    }

    public static boolean isTupleByte(byte b) {
        return b == 19 || b == 20 || b == 21 || b == 30 || b == 28 || b == 29 || b == 36 || b == 37 || b == 38 || b == 39 || b == 40 || b == 41 || b == 42 || b == 43 || b == 44 || b == 45;
    }

    public static class BinInterSedesTupleRawComparator
    extends WritableComparator
    implements TupleRawComparator {
        private final Log mLog = LogFactory.getLog(this.getClass());
        private boolean[] mAsc;
        private boolean[] mSecondaryAsc;
        private static final boolean[] EMPTY_ASC = new boolean[0];
        private boolean mWholeTuple;
        private boolean mIsSecondarySort;
        private boolean mHasNullField;
        private TupleFactory mFact;
        private InterSedes mSedes;

        public BinInterSedesTupleRawComparator() {
            super(BinSedesTuple.class);
        }

        public Configuration getConf() {
            return null;
        }

        public void setConf(Configuration conf) {
            if (!(conf instanceof JobConf)) {
                this.mLog.warn((Object)("Expected jobconf in setConf, got " + conf.getClass().getName()));
                return;
            }
            try {
                this.mAsc = (boolean[])ObjectSerializer.deserialize(conf.get("pig.sortOrder"));
                this.mSecondaryAsc = (boolean[])ObjectSerializer.deserialize(conf.get("pig.secondarySortOrder"));
                this.mIsSecondarySort = true;
            }
            catch (IOException ioe) {
                this.mLog.error((Object)("Unable to deserialize sort order object" + ioe.getMessage()));
                throw new RuntimeException(ioe);
            }
            if (this.mAsc == null) {
                this.mAsc = new boolean[1];
                this.mAsc[0] = true;
            }
            if (this.mSecondaryAsc == null) {
                this.mIsSecondarySort = false;
            }
            this.mWholeTuple = this.mAsc.length == 1;
            this.mFact = TupleFactory.getInstance();
            this.mSedes = InterSedesFactory.getInterSedesInstance();
        }

        public boolean hasComparedTupleNull() {
            return this.mHasNullField;
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int rc = 0;
            ByteBuffer bb1 = ByteBuffer.wrap(b1, s1, l1);
            ByteBuffer bb2 = ByteBuffer.wrap(b2, s2, l2);
            try {
                rc = this.compareBinSedesTuple(bb1, bb2);
            }
            catch (IOException ioe) {
                this.mLog.error((Object)("I/O error during tuple comparison: " + ioe.getMessage()));
                throw new RuntimeException(ioe.getMessage(), ioe);
            }
            return rc;
        }

        private int compareBinSedesTuple(ByteBuffer bb1, ByteBuffer bb2) throws IOException {
            this.mHasNullField = false;
            int s1 = bb1.position();
            int s2 = bb2.position();
            int result = 0;
            try {
                int tsz1 = BinInterSedesTupleRawComparator.readSize(bb1);
                int tsz2 = BinInterSedesTupleRawComparator.readSize(bb2);
                if (tsz1 > tsz2) {
                    return 1;
                }
                if (tsz1 < tsz2) {
                    return -1;
                }
                if (this.mIsSecondarySort) {
                    assert (tsz1 == 2);
                    result = this.compareBinInterSedesDatum(bb1, bb2, this.mAsc);
                    if (result == 0) {
                        result = this.compareBinInterSedesDatum(bb1, bb2, this.mSecondaryAsc);
                    }
                } else {
                    for (int i = 0; i < tsz1 && result == 0; ++i) {
                        result = this.compareBinInterSedesDatum(bb1, bb2, EMPTY_ASC);
                        if (result == 0) continue;
                        if (!this.mWholeTuple && !this.mAsc[i]) {
                            result *= -1;
                            continue;
                        }
                        if (!this.mWholeTuple || this.mAsc[0]) continue;
                        result *= -1;
                    }
                }
            }
            catch (UnsupportedEncodingException uee) {
                Tuple t1 = this.mFact.newTuple();
                Tuple t2 = this.mFact.newTuple();
                t1.readFields(new DataInputStream(new ByteArrayInputStream(bb1.array(), s1, bb1.limit())));
                t2.readFields(new DataInputStream(new ByteArrayInputStream(bb2.array(), s2, bb2.limit())));
                result = this.compare(t1, t2);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int compareBinInterSedesDatum(ByteBuffer bb1, ByteBuffer bb2, boolean[] asc) throws IOException {
            byte type2;
            byte type1;
            int rc = 0;
            byte dt1 = bb1.get();
            byte dt2 = bb2.get();
            switch (dt1) {
                case 27: {
                    type1 = 1;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (asc != null) {
                        this.mHasNullField = true;
                    }
                    if (type1 != type2) break;
                    rc = 0;
                    break;
                }
                case 0: 
                case 1: {
                    type1 = 5;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int bv1 = dt1 == 0 ? 1 : 0;
                    int bv2 = dt2 == 0 ? 1 : 0;
                    rc = bv1 - bv2;
                    break;
                }
                case 2: {
                    byte bv2;
                    type1 = 6;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    byte bv1 = bb1.get();
                    rc = bv1 < (bv2 = bb2.get()) ? -1 : (bv1 == bv2 ? 0 : 1);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    int iv2;
                    type1 = 10;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int iv1 = BinInterSedesTupleRawComparator.readInt(bb1, dt1);
                    rc = iv1 < (iv2 = BinInterSedesTupleRawComparator.readInt(bb2, dt2)) ? -1 : (iv1 == iv2 ? 0 : 1);
                    break;
                }
                case 8: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    long lv2;
                    type1 = 15;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    long lv1 = BinInterSedesTupleRawComparator.readLong(bb1, dt1);
                    rc = lv1 < (lv2 = BinInterSedesTupleRawComparator.readLong(bb2, dt2)) ? -1 : (lv1 == lv2 ? 0 : 1);
                    break;
                }
                case 48: {
                    type1 = 30;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    long lv1 = bb1.getLong();
                    bb1.position(bb1.position() + 2);
                    long lv2 = bb2.getLong();
                    bb2.position(bb2.position() + 2);
                    rc = lv1 < lv2 ? -1 : (lv1 == lv2 ? 0 : 1);
                    break;
                }
                case 9: {
                    type1 = 20;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    float fv1 = bb1.getFloat();
                    float fv2 = bb2.getFloat();
                    rc = Float.compare(fv1, fv2);
                    break;
                }
                case 10: {
                    type1 = 25;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    double dv1 = bb1.getDouble();
                    double dv2 = bb2.getDouble();
                    rc = Double.compare(dv1, dv2);
                    break;
                }
                case 46: {
                    type1 = 65;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int sz1 = BinInterSedesTupleRawComparator.readSize(bb1, bb1.get());
                    int sz2 = BinInterSedesTupleRawComparator.readSize(bb2, bb2.get());
                    byte[] ca1 = new byte[sz1];
                    byte[] ca2 = new byte[sz2];
                    bb1.get(ca1);
                    bb2.get(ca2);
                    String str1 = null;
                    String str2 = null;
                    try {
                        str1 = new String(ca1, BinInterSedes.UTF8);
                        str2 = new String(ca2, BinInterSedes.UTF8);
                    }
                    catch (UnsupportedEncodingException uee) {
                        this.mLog.warn((Object)"Unsupported string encoding", (Throwable)uee);
                        uee.printStackTrace();
                    }
                    if (str1 == null || str2 == null) break;
                    rc = new BigInteger(str1).compareTo(new BigInteger(str2));
                    break;
                }
                case 47: {
                    type1 = 70;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int sz1 = BinInterSedesTupleRawComparator.readSize(bb1, bb1.get());
                    int sz2 = BinInterSedesTupleRawComparator.readSize(bb2, bb2.get());
                    byte[] ca1 = new byte[sz1];
                    byte[] ca2 = new byte[sz2];
                    bb1.get(ca1);
                    bb2.get(ca2);
                    String str1 = null;
                    String str2 = null;
                    try {
                        str1 = new String(ca1, BinInterSedes.UTF8);
                        str2 = new String(ca2, BinInterSedes.UTF8);
                    }
                    catch (UnsupportedEncodingException uee) {
                        this.mLog.warn((Object)"Unsupported string encoding", (Throwable)uee);
                        uee.printStackTrace();
                    }
                    if (str1 == null || str2 == null) break;
                    rc = new BigDecimal(str1).compareTo(new BigDecimal(str2));
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    type1 = 50;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int basz1 = BinInterSedesTupleRawComparator.readSize(bb1, dt1);
                    int basz2 = BinInterSedesTupleRawComparator.readSize(bb2, dt2);
                    rc = WritableComparator.compareBytes((byte[])bb1.array(), (int)bb1.position(), (int)basz1, (byte[])bb2.array(), (int)bb2.position(), (int)basz2);
                    bb1.position(bb1.position() + basz1);
                    bb2.position(bb2.position() + basz2);
                    break;
                }
                case 14: 
                case 15: {
                    type1 = 55;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int casz1 = BinInterSedesTupleRawComparator.readSize(bb1, dt1);
                    int casz2 = BinInterSedesTupleRawComparator.readSize(bb2, dt2);
                    String str1 = null;
                    String str2 = null;
                    try {
                        str1 = new String(bb1.array(), bb1.position(), casz1, BinInterSedes.UTF8);
                        str2 = new String(bb2.array(), bb2.position(), casz2, BinInterSedes.UTF8);
                    }
                    catch (UnsupportedEncodingException uee) {
                        this.mLog.warn((Object)"Unsupported string encoding", (Throwable)uee);
                        uee.printStackTrace();
                    }
                    finally {
                        bb1.position(bb1.position() + casz1);
                        bb2.position(bb2.position() + casz2);
                    }
                    if (str1 == null || str2 == null) break;
                    rc = str1.compareTo(str2);
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int tsz2;
                    type1 = 110;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int tsz1 = BinInterSedesTupleRawComparator.readSize(bb1, dt1);
                    if (tsz1 > (tsz2 = BinInterSedesTupleRawComparator.readSize(bb2, dt2))) {
                        return 1;
                    }
                    if (tsz1 < tsz2) {
                        return -1;
                    }
                    for (int i = 0; i < tsz1 && rc == 0; ++i) {
                        rc = this.compareBinInterSedesDatum(bb1, bb2, null);
                        if (rc == 0 || asc == null || asc.length <= 1 || asc[i]) continue;
                        rc *= -1;
                    }
                    break;
                }
                case 22: 
                case 23: 
                case 24: {
                    type1 = 120;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    rc = this.compareBinInterSedesBag(bb1, bb2, dt1, dt2);
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    type1 = 100;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    rc = this.compareBinInterSedesMap(bb1, bb2, dt1, dt2);
                    break;
                }
                case 25: {
                    type1 = 123;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    rc = this.compareBinInterSedesGenericWritableComparable(bb1, bb2);
                    break;
                }
                default: {
                    this.mLog.info((Object)("Unsupported DataType for binary comparison, switching to object deserialization: " + DataType.genTypeToNameMap().get(dt1) + "(" + dt1 + ")"));
                    throw new UnsupportedEncodingException();
                }
            }
            if (type1 != type2) {
                int n = rc = type1 < type2 ? -1 : 1;
            }
            if (asc != null && asc.length == 1 && !asc[0]) {
                rc *= -1;
            }
            return rc;
        }

        public int compare(WritableComparable o1, WritableComparable o2) {
            int tsz2;
            Tuple t1 = (Tuple)o1;
            Tuple t2 = (Tuple)o2;
            this.mHasNullField = false;
            int result = 0;
            int tsz1 = t1.size();
            if (tsz1 > (tsz2 = t2.size())) {
                return 1;
            }
            if (tsz1 < tsz2) {
                return -1;
            }
            try {
                if (this.mIsSecondarySort) {
                    assert (tsz1 == 3);
                    result = this.compareDatum(t1.get(0), t2.get(0), this.mAsc);
                    if (result == 0) {
                        result = this.compareDatum(t1.get(1), t2.get(1), this.mSecondaryAsc);
                    }
                } else {
                    result = this.compareDatum(t1, t2, this.mAsc);
                }
            }
            catch (ExecException e) {
                throw new RuntimeException("Unable to compare tuples", e);
            }
            return result;
        }

        private int compareDatum(Object o1, Object o2, boolean[] asc) {
            int rc = 0;
            if (o1 != null && o2 != null && o1 instanceof Tuple && o2 instanceof Tuple) {
                Tuple t1 = (Tuple)o1;
                Tuple t2 = (Tuple)o2;
                int sz1 = t1.size();
                int sz2 = t2.size();
                if (sz2 < sz1) {
                    return 1;
                }
                if (sz2 > sz1) {
                    return -1;
                }
                for (int i = 0; i < sz1; ++i) {
                    try {
                        rc = DataType.compare(t1.get(i), t2.get(i));
                        if (rc != 0 && asc != null && asc.length > 1 && !asc[i]) {
                            rc *= -1;
                        }
                        if (t1.get(i) == null) {
                            this.mHasNullField = true;
                        }
                        if (rc == 0) continue;
                        break;
                    }
                    catch (ExecException e) {
                        throw new RuntimeException("Unable to compare tuples", e);
                    }
                }
            } else {
                rc = DataType.compare(o1, o2);
            }
            if (asc != null && asc.length == 1 && !asc[0]) {
                rc *= -1;
            }
            return rc;
        }

        private int compareBinInterSedesGenericWritableComparable(ByteBuffer bb1, ByteBuffer bb2) throws ExecException, IOException {
            DataInputBuffer buffer1 = new DataInputBuffer();
            DataInputBuffer buffer2 = new DataInputBuffer();
            buffer1.reset(bb1.array(), bb1.position(), bb1.remaining());
            buffer2.reset(bb2.array(), bb2.position(), bb2.remaining());
            Comparable writable1 = (Comparable)this.mSedes.readDatum((DataInput)buffer1);
            Comparable writable2 = (Comparable)this.mSedes.readDatum((DataInput)buffer2);
            bb1.position(buffer1.getPosition());
            bb2.position(buffer2.getPosition());
            return writable1.compareTo(writable2);
        }

        private int compareBinInterSedesBag(ByteBuffer bb1, ByteBuffer bb2, byte dt1, byte dt2) throws IOException {
            int bsz2;
            int s1 = bb1.position();
            int s2 = bb2.position();
            int l1 = bb1.remaining();
            int l2 = bb2.remaining();
            int bsz1 = BinInterSedesTupleRawComparator.readSize(bb1, dt1);
            if (bsz1 > (bsz2 = BinInterSedesTupleRawComparator.readSize(bb2, dt2))) {
                return 1;
            }
            if (bsz1 < bsz2) {
                return -1;
            }
            DataInputBuffer buffer1 = new DataInputBuffer();
            DataInputBuffer buffer2 = new DataInputBuffer();
            buffer1.reset(bb1.array(), s1, l1);
            buffer2.reset(bb2.array(), s2, l2);
            DataBag bag1 = (DataBag)this.mSedes.readDatum((DataInput)buffer1, dt1);
            DataBag bag2 = (DataBag)this.mSedes.readDatum((DataInput)buffer2, dt2);
            bb1.position(buffer1.getPosition());
            bb2.position(buffer2.getPosition());
            return bag1.compareTo(bag2);
        }

        private int compareBinInterSedesMap(ByteBuffer bb1, ByteBuffer bb2, byte dt1, byte dt2) throws ExecException, IOException {
            int bsz2;
            int s1 = bb1.position();
            int s2 = bb2.position();
            int l1 = bb1.remaining();
            int l2 = bb2.remaining();
            int bsz1 = BinInterSedesTupleRawComparator.readSize(bb1, dt1);
            if (bsz1 > (bsz2 = BinInterSedesTupleRawComparator.readSize(bb2, dt2))) {
                return 1;
            }
            if (bsz1 < bsz2) {
                return -1;
            }
            DataInputBuffer buffer1 = new DataInputBuffer();
            DataInputBuffer buffer2 = new DataInputBuffer();
            buffer1.reset(bb1.array(), s1, l1);
            buffer2.reset(bb2.array(), s2, l2);
            Map map1 = (Map)this.mSedes.readDatum((DataInput)buffer1, dt1);
            Map map2 = (Map)this.mSedes.readDatum((DataInput)buffer2, dt2);
            bb1.position(buffer1.getPosition());
            bb2.position(buffer2.getPosition());
            return DataType.compare(map1, map2, (byte)100, (byte)100);
        }

        private static byte getGeneralizedDataType(byte type) {
            switch (type) {
                case 27: {
                    return 1;
                }
                case 0: 
                case 1: {
                    return 5;
                }
                case 2: {
                    return 6;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return 10;
                }
                case 8: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    return 15;
                }
                case 48: {
                    return 30;
                }
                case 9: {
                    return 20;
                }
                case 10: {
                    return 25;
                }
                case 46: {
                    return 65;
                }
                case 47: {
                    return 70;
                }
                case 11: 
                case 12: 
                case 13: {
                    return 50;
                }
                case 14: 
                case 15: {
                    return 55;
                }
                case 19: 
                case 20: 
                case 21: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    return 110;
                }
                case 22: 
                case 23: 
                case 24: {
                    return 120;
                }
                case 16: 
                case 17: 
                case 18: {
                    return 100;
                }
                case 26: {
                    return 127;
                }
                case 25: {
                    return 123;
                }
            }
            throw new RuntimeException("Unexpected data type " + type + " found in stream.");
        }

        private static long readLong(ByteBuffer bb, byte type) {
            boolean bytesToRead = false;
            switch (type) {
                case 34: {
                    return 0L;
                }
                case 35: {
                    return 1L;
                }
                case 31: {
                    return bb.get();
                }
                case 32: {
                    return bb.getShort();
                }
                case 33: {
                    return bb.getInt();
                }
                case 8: {
                    return bb.getLong();
                }
            }
            throw new RuntimeException("Unexpected data type " + type + " found in stream.");
        }

        private static int readInt(ByteBuffer bb, byte type) {
            switch (type) {
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 7: {
                    return bb.get();
                }
                case 6: {
                    return bb.getShort();
                }
                case 3: {
                    return bb.getInt();
                }
            }
            throw new RuntimeException("Unexpected data type " + type + " found in stream.");
        }

        private static int readSize(ByteBuffer bb) {
            return BinInterSedesTupleRawComparator.readSize(bb, bb.get());
        }

        private static int readSize(ByteBuffer bb, byte type) {
            switch (type) {
                case 13: 
                case 18: 
                case 21: 
                case 24: {
                    return BinInterSedesTupleRawComparator.getUnsignedByte(bb);
                }
                case 12: 
                case 15: 
                case 17: 
                case 20: 
                case 23: {
                    return BinInterSedesTupleRawComparator.getUnsignedShort(bb);
                }
                case 11: 
                case 14: 
                case 16: 
                case 19: 
                case 22: {
                    return bb.getInt();
                }
                case 36: {
                    return 0;
                }
                case 37: {
                    return 1;
                }
                case 38: {
                    return 2;
                }
                case 39: {
                    return 3;
                }
                case 40: {
                    return 4;
                }
                case 41: {
                    return 5;
                }
                case 42: {
                    return 6;
                }
                case 43: {
                    return 7;
                }
                case 44: {
                    return 8;
                }
                case 45: {
                    return 9;
                }
            }
            throw new RuntimeException("Unexpected data type " + type + " found in stream.");
        }

        private static int getUnsignedShort(ByteBuffer bb) {
            return (bb.get() & 0xFF) << 8 | bb.get() & 0xFF;
        }

        private static int getUnsignedByte(ByteBuffer bb) {
            return bb.get() & 0xFF;
        }
    }
}

