/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle.step;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepExternalResourceConsumer;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.messages.Messages;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalResourceStepAnalyzer<T extends BaseStepMeta>
extends StepAnalyzer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalResourceStepAnalyzer.class);
    public static final String RESOURCE = "_resource_";
    private IStepExternalResourceConsumer externalResourceConsumer;

    @Override
    protected void customAnalyze(T meta, IMetaverseNode node) throws MetaverseAnalyzerException {
        if (this.getExternalResourceConsumer() != null) {
            IAnalysisContext context = this.getDescriptor().getContext();
            Collection<IExternalResourceInfo> resources = this.getExternalResourceConsumer().getResourcesFromMeta(meta, context);
            for (IExternalResourceInfo resource : resources) {
                try {
                    IMetaverseNode resourceNode;
                    String label;
                    if (resource.isInput()) {
                        label = "isreadby";
                        resourceNode = this.createResourceNode(resource);
                        this.getMetaverseBuilder().addNode(resourceNode);
                        this.getMetaverseBuilder().addLink(resourceNode, label, node);
                    }
                    if (!resource.isOutput()) continue;
                    label = "writesto";
                    resourceNode = this.createResourceNode(resource);
                    this.getMetaverseBuilder().addNode(resourceNode);
                    this.getMetaverseBuilder().addLink(node, label, resourceNode);
                }
                catch (MetaverseException e) {
                    LOGGER.warn(e.getLocalizedMessage());
                    LOGGER.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected Map<String, RowMetaInterface> getOutputRowMetaInterfaces(T meta) {
        Map<String, RowMetaInterface> outputRows = super.getOutputRowMetaInterfaces(meta);
        if (MapUtils.isNotEmpty(outputRows) && this.isOutput()) {
            RowMetaInterface out = null;
            Set<String> outputResourceFields = this.getOutputResourceFields(meta);
            Iterator<RowMetaInterface> i$ = outputRows.values().iterator();
            if (i$.hasNext()) {
                RowMetaInterface rowMetaInterface = i$.next();
                if (outputResourceFields != null) {
                    out = rowMetaInterface.clone();
                    for (ValueMetaInterface field : rowMetaInterface.getValueMetaList()) {
                        if (outputResourceFields.contains(field.getName())) continue;
                        try {
                            out.removeValueMeta(field.getName());
                        }
                        catch (KettleValueException kettleValueException) {}
                    }
                } else {
                    out = rowMetaInterface;
                }
            }
            outputRows.put(RESOURCE, out);
        }
        return outputRows;
    }

    @Override
    protected Map<String, RowMetaInterface> getInputRowMetaInterfaces(T meta) {
        RowMetaInterface stepFields;
        Map<String, RowMetaInterface> inputRows = super.getInputRowMetaInterfaces(meta);
        if (inputRows == null) {
            inputRows = new HashMap<String, RowMetaInterface>();
        }
        if (this.isInput() && (stepFields = this.getOutputFields(meta)) != null) {
            RowMetaInterface clone = stepFields.clone();
            for (RowMetaInterface rowMetaInterface : inputRows.values()) {
                for (ValueMetaInterface valueMetaInterface : rowMetaInterface.getValueMetaList()) {
                    try {
                        clone.removeValueMeta(valueMetaInterface.getName());
                    }
                    catch (KettleValueException kettleValueException) {}
                }
            }
            inputRows.put(RESOURCE, clone);
        }
        return inputRows;
    }

    @Override
    protected IMetaverseNode createOutputFieldNode(IAnalysisContext context, ValueMetaInterface fieldMeta, String targetStepName, String nodeType) {
        nodeType = RESOURCE.equals(targetStepName) ? this.getResourceOutputNodeType() : nodeType;
        return super.createOutputFieldNode(context, fieldMeta, targetStepName, nodeType);
    }

    @Override
    protected IMetaverseNode createInputFieldNode(IAnalysisContext context, ValueMetaInterface fieldMeta, String previousStepName, String nodeType) {
        boolean isResource = RESOURCE.equals(previousStepName);
        nodeType = isResource ? this.getResourceInputNodeType() : nodeType;
        IMetaverseNode inputFieldNode = super.createInputFieldNode(context, fieldMeta, previousStepName, nodeType);
        inputFieldNode.setType(nodeType);
        if (isResource) {
            this.getMetaverseBuilder().addNode(inputFieldNode);
        }
        return inputFieldNode;
    }

    public IStepExternalResourceConsumer getExternalResourceConsumer() {
        return this.externalResourceConsumer;
    }

    public void setExternalResourceConsumer(IStepExternalResourceConsumer externalResourceConsumer) {
        this.externalResourceConsumer = externalResourceConsumer;
    }

    public Set<String> getOutputResourceFields(T meta) {
        return null;
    }

    @Override
    protected void linkChangeNodes(IMetaverseNode inputNode, IMetaverseNode outputNode) {
        boolean nodeTypesMatch = inputNode.getType().equals(outputNode.getType());
        if (!nodeTypesMatch && (this.isInput() || this.isOutput())) {
            this.getMetaverseBuilder().addLink(inputNode, "populates", outputNode);
        } else {
            this.getMetaverseBuilder().addLink(inputNode, this.getInputToOutputLinkLabel(), outputNode);
        }
    }

    public abstract IMetaverseNode createResourceNode(IExternalResourceInfo var1) throws MetaverseException;

    public abstract String getResourceInputNodeType();

    public abstract String getResourceOutputNodeType();

    public abstract boolean isOutput();

    public abstract boolean isInput();
}

