/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle.step;

import java.util.Set;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.analyzer.kettle.step.ExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepNodes;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public abstract class ConnectionExternalResourceStepAnalyzer<T extends BaseStepMeta>
extends ExternalResourceStepAnalyzer<T> {
    protected IMetaverseNode connectionNode = null;
    protected IMetaverseNode tableNode = null;

    @Override
    protected void customAnalyze(T meta, IMetaverseNode node) throws MetaverseAnalyzerException {
        super.customAnalyze(meta, node);
        IMetaverseNode connectionNode = this.getConnectionNode();
        this.getMetaverseBuilder().addNode(connectionNode);
        this.getMetaverseBuilder().addLink(connectionNode, "dependencyof", node);
    }

    @Override
    public IMetaverseNode createResourceNode(IExternalResourceInfo resource) throws MetaverseException {
        this.tableNode = this.createTableNode(resource);
        StepNodes stepNodes = this.isInput() ? this.getInputs() : this.getOutputs();
        this.linkResourceToFields(stepNodes);
        return this.tableNode;
    }

    public IMetaverseNode getConnectionNode() throws MetaverseAnalyzerException {
        if (this.connectionNode == null) {
            this.connectionNode = (IMetaverseNode)this.getConnectionAnalyzer().analyze(this.getDescriptor(), this.baseStepMeta);
        }
        return this.connectionNode;
    }

    protected abstract IMetaverseNode createTableNode(IExternalResourceInfo var1) throws MetaverseAnalyzerException;

    public IMetaverseNode getTableNode() {
        return this.tableNode;
    }

    public void linkResourceToFields(StepNodes stepNodes) {
        Set<String> fieldNames = stepNodes.getFieldNames("_resource_");
        if (fieldNames != null) {
            for (String fieldName : fieldNames) {
                IMetaverseNode resNode = stepNodes.findNode("_resource_", fieldName);
                if (resNode == null) continue;
                resNode.setProperty("namespace", this.getTableNode().getLogicalId());
                this.getMetaverseBuilder().updateNode(resNode);
                this.getMetaverseBuilder().addLink(this.getTableNode(), "contains", resNode);
            }
        }
    }
}

