/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.pentaho.bigdata.api.hbase.ByteConversionUtil;
import org.pentaho.bigdata.api.hbase.Result;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterfaceFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;

public class HBaseRowToKettleTuple {
    protected List<Object[]> m_decodedTuples;
    protected int m_keyIndex = -1;
    protected int m_familyIndex = -1;
    protected int m_colNameIndex = -1;
    protected int m_valueIndex = -1;
    protected int m_timestampIndex = -1;
    protected List<byte[]> m_userSpecifiedFamilies;
    protected List<String> m_userSpecifiedFamiliesHumanReadable;
    protected List<HBaseValueMetaInterface> m_tupleColsFromAliasMap;
    protected ByteConversionUtil m_bytesUtil;

    public HBaseRowToKettleTuple(ByteConversionUtil bytesUtil) {
        if (bytesUtil == null) {
            throw new NullPointerException();
        }
        this.m_bytesUtil = bytesUtil;
    }

    public void reset() {
        this.m_decodedTuples = null;
        this.m_keyIndex = -1;
        this.m_familyIndex = -1;
        this.m_colNameIndex = -1;
        this.m_valueIndex = -1;
        this.m_timestampIndex = -1;
        this.m_userSpecifiedFamilies = null;
        this.m_userSpecifiedFamiliesHumanReadable = null;
        this.m_tupleColsFromAliasMap = null;
        this.m_decodedTuples = null;
    }

    public List<Object[]> hbaseRowToKettleTupleMode(HBaseValueMetaInterfaceFactory hBaseValueMetaInterfaceFactory, Result result, Mapping mapping, Map<String, HBaseValueMetaInterface> tupleColsMappedByAlias, RowMetaInterface outputRowMeta) throws KettleException {
        if (this.m_decodedTuples == null) {
            this.m_tupleColsFromAliasMap = new ArrayList<HBaseValueMetaInterface>();
            HBaseValueMetaInterface keyMeta = hBaseValueMetaInterfaceFactory.createHBaseValueMetaInterface(null, mapping.getKeyName(), "dummy", 5, 0, 0);
            this.m_tupleColsFromAliasMap.add(keyMeta);
            for (String alias : tupleColsMappedByAlias.keySet()) {
                this.m_tupleColsFromAliasMap.add(tupleColsMappedByAlias.get(alias));
            }
        }
        return this.hbaseRowToKettleTupleMode(result, mapping, this.m_tupleColsFromAliasMap, outputRowMeta);
    }

    public List<Object[]> hbaseRowToKettleTupleMode(Result result, Mapping mapping, List<HBaseValueMetaInterface> tupleCols, RowMetaInterface outputRowMeta) throws KettleException {
        if (this.m_decodedTuples == null) {
            this.m_decodedTuples = new ArrayList<Object[]>();
            this.m_keyIndex = outputRowMeta.indexOfValue(mapping.getKeyName());
            this.m_familyIndex = outputRowMeta.indexOfValue(Mapping.TupleMapping.FAMILY.toString());
            this.m_colNameIndex = outputRowMeta.indexOfValue(Mapping.TupleMapping.COLUMN.toString());
            this.m_valueIndex = outputRowMeta.indexOfValue(Mapping.TupleMapping.VALUE.toString());
            this.m_timestampIndex = outputRowMeta.indexOfValue(Mapping.TupleMapping.TIMESTAMP.toString());
            if (!Const.isEmpty((String)mapping.getTupleFamilies())) {
                String[] familiesS = mapping.getTupleFamiliesSplit();
                this.m_userSpecifiedFamilies = new ArrayList<byte[]>();
                this.m_userSpecifiedFamiliesHumanReadable = new ArrayList<String>();
                String[] arr$ = familiesS;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Object family = arr$[i$];
                    this.m_userSpecifiedFamiliesHumanReadable.add((String)family);
                    this.m_userSpecifiedFamilies.add(this.m_bytesUtil.toBytes(((String)family).trim()));
                }
            }
        } else {
            this.m_decodedTuples.clear();
        }
        byte[] rawKey = null;
        try {
            rawKey = result.getRow();
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        Object decodedKey = mapping.decodeKeyValue(rawKey);
        NavigableMap rowData = null;
        try {
            rowData = result.getMap();
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        if (!Const.isEmpty((String)mapping.getTupleFamilies())) {
            int i = 0;
            for (byte[] family : this.m_userSpecifiedFamilies) {
                NavigableMap colMap = (NavigableMap)rowData.get(family);
                for (byte[] colName : colMap.keySet()) {
                    NavigableMap valuesByTimestamp = (NavigableMap)colMap.get(colName);
                    Object[] newTuple = RowDataUtil.allocateRowData((int)outputRowMeta.size());
                    if (this.m_keyIndex != -1) {
                        newTuple[this.m_keyIndex] = decodedKey;
                    }
                    Map.Entry mostRecentColVal = valuesByTimestamp.lastEntry();
                    if (this.m_timestampIndex != -1) {
                        newTuple[this.m_timestampIndex] = mostRecentColVal.getKey();
                    }
                    if (this.m_colNameIndex != -1) {
                        Object decodedColName;
                        HBaseValueMetaInterface colNameMeta = tupleCols.get(this.m_colNameIndex);
                        newTuple[this.m_colNameIndex] = decodedColName = colNameMeta.decodeColumnValue(colName);
                    }
                    if (this.m_valueIndex != -1) {
                        Object decodedValue;
                        HBaseValueMetaInterface colValueMeta = tupleCols.get(this.m_valueIndex);
                        newTuple[this.m_valueIndex] = decodedValue = colValueMeta.decodeColumnValue((byte[])mostRecentColVal.getValue());
                    }
                    if (this.m_familyIndex != -1) {
                        newTuple[this.m_familyIndex] = this.m_userSpecifiedFamiliesHumanReadable.get(i);
                    }
                    this.m_decodedTuples.add(newTuple);
                }
                ++i;
            }
        } else {
            for (Object family : rowData.keySet()) {
                Object decodedFamily = null;
                if (this.m_familyIndex != -1) {
                    HBaseValueMetaInterface colFamMeta = tupleCols.get(this.m_familyIndex);
                    decodedFamily = colFamMeta.decodeColumnValue((byte[])family);
                }
                NavigableMap colMap = (NavigableMap)rowData.get(family);
                for (byte[] colName : colMap.keySet()) {
                    NavigableMap valuesByTimestamp = (NavigableMap)colMap.get(colName);
                    Object[] newTuple = RowDataUtil.allocateRowData((int)outputRowMeta.size());
                    if (this.m_keyIndex != -1) {
                        newTuple[this.m_keyIndex] = decodedKey;
                    }
                    Map.Entry mostRecentColVal = valuesByTimestamp.lastEntry();
                    if (this.m_timestampIndex != -1) {
                        newTuple[this.m_timestampIndex] = mostRecentColVal.getKey();
                    }
                    if (this.m_colNameIndex != -1) {
                        Object decodedColName;
                        HBaseValueMetaInterface colNameMeta = tupleCols.get(this.m_colNameIndex);
                        newTuple[this.m_colNameIndex] = decodedColName = colNameMeta.decodeColumnValue(colName);
                    }
                    if (this.m_valueIndex != -1) {
                        Object decodedValue;
                        HBaseValueMetaInterface colValueMeta = tupleCols.get(this.m_valueIndex);
                        newTuple[this.m_valueIndex] = decodedValue = colValueMeta.decodeColumnValue((byte[])mostRecentColVal.getValue());
                    }
                    if (this.m_familyIndex != -1) {
                        newTuple[this.m_familyIndex] = decodedFamily;
                    }
                    this.m_decodedTuples.add(newTuple);
                }
            }
        }
        return this.m_decodedTuples;
    }
}

