/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.kettle.plugins.hbase.NamedClusterLoadSaveUtil;
import org.pentaho.big.data.kettle.plugins.hbase.input.HBaseInput;
import org.pentaho.big.data.kettle.plugins.hbase.input.HBaseInputData;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.MappingAdmin;
import org.pentaho.bigdata.api.hbase.HBaseConnection;
import org.pentaho.bigdata.api.hbase.HBaseService;
import org.pentaho.bigdata.api.hbase.mapping.ColumnFilter;
import org.pentaho.bigdata.api.hbase.mapping.ColumnFilterFactory;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.bigdata.api.hbase.mapping.MappingFactory;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterfaceFactory;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

@Step(id="HBaseInput", image="HB.svg", name="HBaseInput.Name", description="HBaseInput.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", i18nPackageName="org.pentaho.di.trans.steps.hbaseinput")
public class HBaseInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static Class<?> PKG = HBaseInputMeta.class;
    private final NamedClusterLoadSaveUtil namedClusterLoadSaveUtil;
    private final NamedClusterService namedClusterService;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    protected NamedCluster namedCluster;
    protected String m_coreConfigURL;
    protected String m_defaultConfigURL;
    protected String m_sourceTableName;
    protected String m_sourceMappingName;
    protected String m_keyStart;
    protected String m_keyStop;
    protected String m_scannerCacheSize;
    protected transient Mapping m_cachedMapping;
    protected List<HBaseValueMetaInterface> m_outputFields;
    protected List<ColumnFilter> m_filters;
    protected boolean m_matchAnyFilter;
    protected Mapping m_mapping;

    public HBaseInputMeta(NamedClusterService namedClusterService, NamedClusterServiceLocator namedClusterServiceLocator, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this.namedClusterService = namedClusterService;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.namedClusterLoadSaveUtil = new NamedClusterLoadSaveUtil();
    }

    public void setMapping(Mapping m) {
        this.m_mapping = m;
    }

    public Mapping getMapping() {
        return this.m_mapping;
    }

    public void setCoreConfigURL(String coreConfig) {
        this.m_coreConfigURL = coreConfig;
        this.m_cachedMapping = null;
    }

    public String getCoreConfigURL() {
        return this.m_coreConfigURL;
    }

    public void setDefaulConfigURL(String defaultConfig) {
        this.m_defaultConfigURL = defaultConfig;
        this.m_cachedMapping = null;
    }

    public String getDefaultConfigURL() {
        return this.m_defaultConfigURL;
    }

    public void setSourceTableName(String sourceTable) {
        this.m_sourceTableName = sourceTable;
        this.m_cachedMapping = null;
    }

    public String getSourceTableName() {
        return this.m_sourceTableName;
    }

    public void setSourceMappingName(String sourceMapping) {
        this.m_sourceMappingName = sourceMapping;
        this.m_cachedMapping = null;
    }

    public String getSourceMappingName() {
        return this.m_sourceMappingName;
    }

    public void setMatchAnyFilter(boolean a) {
        this.m_matchAnyFilter = a;
    }

    public boolean getMatchAnyFilter() {
        return this.m_matchAnyFilter;
    }

    public void setKeyStartValue(String start) {
        this.m_keyStart = start;
    }

    public String getKeyStartValue() {
        return this.m_keyStart;
    }

    public void setKeyStopValue(String stop) {
        this.m_keyStop = stop;
    }

    public String getKeyStopValue() {
        return this.m_keyStop;
    }

    public void setScannerCacheSize(String s) {
        this.m_scannerCacheSize = s;
    }

    public String getScannerCacheSize() {
        return this.m_scannerCacheSize;
    }

    public void setOutputFields(List<HBaseValueMetaInterface> fields) {
        this.m_outputFields = fields;
    }

    public List<HBaseValueMetaInterface> getOutputFields() {
        return this.m_outputFields;
    }

    public void setColumnFilters(List<ColumnFilter> list) {
        this.m_filters = list;
    }

    public List<ColumnFilter> getColumnFilters() {
        return this.m_filters;
    }

    public void setDefault() {
        this.m_coreConfigURL = null;
        this.m_defaultConfigURL = null;
        this.m_cachedMapping = null;
        this.m_sourceTableName = null;
        this.m_sourceMappingName = null;
        this.m_keyStart = null;
        this.m_keyStop = null;
        this.namedCluster = this.namedClusterService.getClusterTemplate();
    }

    private String getIndexValues(HBaseValueMetaInterface vm) {
        Object[] labels = vm.getIndex();
        StringBuffer vals = new StringBuffer();
        vals.append("{");
        for (int i = 0; i < labels.length; ++i) {
            if (i != labels.length - 1) {
                vals.append(labels[i].toString().trim()).append(",");
                continue;
            }
            vals.append(labels[i].toString().trim()).append("}");
        }
        return vals.toString();
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder();
        this.namedClusterLoadSaveUtil.getXml(retval, this.namedClusterService, this.namedCluster, this.repository == null ? null : this.repository.getMetaStore(), this.log);
        if (!Const.isEmpty((String)this.m_coreConfigURL)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"core_config_url", (String)this.m_coreConfigURL));
        }
        if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"default_config_url", (String)this.m_defaultConfigURL));
        }
        if (!Const.isEmpty((String)this.m_sourceTableName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"source_table_name", (String)this.m_sourceTableName));
        }
        if (!Const.isEmpty((String)this.m_sourceMappingName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"source_mapping_name", (String)this.m_sourceMappingName));
        }
        if (!Const.isEmpty((String)this.m_keyStart)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"key_start", (String)this.m_keyStart));
        }
        if (!Const.isEmpty((String)this.m_keyStop)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"key_stop", (String)this.m_keyStop));
        }
        if (!Const.isEmpty((String)this.m_scannerCacheSize)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"scanner_cache_size", (String)this.m_scannerCacheSize));
        }
        if (this.m_outputFields != null && this.m_outputFields.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"output_fields"));
            for (HBaseValueMetaInterface vm : this.m_outputFields) {
                vm.getXml(retval);
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"output_fields"));
        }
        if (this.m_filters != null && this.m_filters.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"column_filters"));
            for (ColumnFilter f : this.m_filters) {
                f.appendXML(retval);
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"column_filters"));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"match_any_filter", (boolean)this.m_matchAnyFilter));
        if (this.m_mapping != null) {
            retval.append(this.m_mapping.getXML());
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        Mapping tempMapping;
        HBaseService hBaseService;
        this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, null, this.repository, metaStore, stepnode, this.log);
        try {
            hBaseService = (HBaseService)this.namedClusterServiceLocator.getService(this.namedCluster, HBaseService.class);
        }
        catch (ClusterInitializationException e) {
            throw new KettleXMLException((Throwable)e);
        }
        HBaseValueMetaInterfaceFactory valueMetaInterfaceFactory = hBaseService.getHBaseValueMetaInterfaceFactory();
        ColumnFilterFactory columnFilterFactory = hBaseService.getColumnFilterFactory();
        MappingFactory mappingFactory = hBaseService.getMappingFactory();
        this.m_coreConfigURL = XMLHandler.getTagValue((Node)stepnode, (String)"core_config_url");
        this.m_defaultConfigURL = XMLHandler.getTagValue((Node)stepnode, (String)"default_config_url");
        this.m_sourceTableName = XMLHandler.getTagValue((Node)stepnode, (String)"source_table_name");
        this.m_sourceMappingName = XMLHandler.getTagValue((Node)stepnode, (String)"source_mapping_name");
        this.m_keyStart = XMLHandler.getTagValue((Node)stepnode, (String)"key_start");
        this.m_keyStop = XMLHandler.getTagValue((Node)stepnode, (String)"key_stop");
        this.m_scannerCacheSize = XMLHandler.getTagValue((Node)stepnode, (String)"scanner_cache_size");
        String m = XMLHandler.getTagValue((Node)stepnode, (String)"match_any_filter");
        if (!Const.isEmpty((String)m)) {
            this.m_matchAnyFilter = m.equalsIgnoreCase("Y");
        }
        this.m_outputFields = valueMetaInterfaceFactory.createListFromNode(stepnode);
        Node filters = XMLHandler.getSubNode((Node)stepnode, (String)"column_filters");
        if (filters != null && XMLHandler.countNodes((Node)filters, (String)"filter") > 0) {
            int nrFilters = XMLHandler.countNodes((Node)filters, (String)"filter");
            this.m_filters = new ArrayList<ColumnFilter>();
            for (int i = 0; i < nrFilters; ++i) {
                Node filterNode = XMLHandler.getSubNodeByNr((Node)filters, (String)"filter", (int)i);
                this.m_filters.add(columnFilterFactory.createFilter(filterNode));
            }
        }
        this.m_mapping = (tempMapping = mappingFactory.createMapping()).loadXML(stepnode) ? tempMapping : null;
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        int i;
        this.namedClusterLoadSaveUtil.saveRep(rep, metaStore, id_transformation, id_step, this.namedClusterService, this.namedCluster, this.log);
        if (!Const.isEmpty((String)this.m_coreConfigURL)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "core_config_url", this.m_coreConfigURL);
        }
        if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "default_config_url", this.m_defaultConfigURL);
        }
        if (!Const.isEmpty((String)this.m_sourceTableName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "source_table_name", this.m_sourceTableName);
        }
        if (!Const.isEmpty((String)this.m_sourceMappingName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "source_mapping_name", this.m_sourceMappingName);
        }
        if (!Const.isEmpty((String)this.m_keyStart)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "key_start", this.m_keyStart);
        }
        if (!Const.isEmpty((String)this.m_keyStop)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "key_stop", this.m_keyStop);
        }
        if (!Const.isEmpty((String)this.m_scannerCacheSize)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "scanner_cache_size", this.m_scannerCacheSize);
        }
        if (this.m_outputFields != null && this.m_outputFields.size() > 0) {
            for (i = 0; i < this.m_outputFields.size(); ++i) {
                this.m_outputFields.get(i).saveRep(rep, id_transformation, id_step, i);
            }
        }
        if (this.m_filters != null && this.m_filters.size() > 0) {
            for (i = 0; i < this.m_filters.size(); ++i) {
                ColumnFilter f = this.m_filters.get(i);
                f.saveRep(rep, id_transformation, id_step, i);
            }
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "match_any_filter", this.m_matchAnyFilter);
        if (this.m_mapping != null) {
            this.m_mapping.saveRep(rep, id_transformation, id_step);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        Mapping tempMapping;
        this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, id_step, rep, metaStore, null, this.log);
        HBaseService hBaseService = null;
        try {
            hBaseService = (HBaseService)this.namedClusterServiceLocator.getService(this.namedCluster, HBaseService.class);
        }
        catch (ClusterInitializationException e) {
            throw new KettleException((Throwable)e);
        }
        HBaseValueMetaInterfaceFactory valueMetaInterfaceFactory = hBaseService.getHBaseValueMetaInterfaceFactory();
        ColumnFilterFactory columnFilterFactory = hBaseService.getColumnFilterFactory();
        MappingFactory mappingFactory = hBaseService.getMappingFactory();
        this.m_coreConfigURL = rep.getStepAttributeString(id_step, 0, "core_config_url");
        this.m_defaultConfigURL = rep.getStepAttributeString(id_step, 0, "default_config_url");
        this.m_sourceTableName = rep.getStepAttributeString(id_step, 0, "source_table_name");
        this.m_sourceMappingName = rep.getStepAttributeString(id_step, 0, "source_mapping_name");
        this.m_keyStart = rep.getStepAttributeString(id_step, 0, "key_start");
        this.m_keyStop = rep.getStepAttributeString(id_step, 0, "key_stop");
        this.m_matchAnyFilter = rep.getStepAttributeBoolean(id_step, 0, "match_any_filter");
        this.m_scannerCacheSize = rep.getStepAttributeString(id_step, 0, "scanner_cache_size");
        this.m_outputFields = valueMetaInterfaceFactory.createListFromRepository(rep, id_step);
        int nrFilters = rep.countNrStepAttributes(id_step, "cf_comparison_opp");
        if (nrFilters > 0) {
            this.m_filters = new ArrayList<ColumnFilter>();
            for (int i = 0; i < nrFilters; ++i) {
                this.m_filters.add(columnFilterFactory.createFilter(rep, i, id_step));
            }
        }
        this.m_mapping = (tempMapping = mappingFactory.createMapping()).readRep(rep, id_step) ? tempMapping : null;
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace variableSpace, Repository repository, IMetaStore metaStore) {
        RowMeta r = new RowMeta();
        try {
            this.getFields((RowMetaInterface)r, "testName", null, null, null, repository, metaStore);
            CheckResult cr = new CheckResult(1, "Step can connect to HBase. Named mapping exists", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        catch (Exception ex) {
            CheckResult cr = new CheckResult(4, ex.getMessage(), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new HBaseInput(stepMeta, stepDataInterface, copyNr, transMeta, trans, this.namedClusterServiceLocator);
    }

    public StepDataInterface getStepData() {
        return new HBaseInputData();
    }

    private void setupCachedMapping(VariableSpace space) throws KettleStepException {
        HBaseService hBaseService = null;
        try {
            hBaseService = (HBaseService)this.namedClusterServiceLocator.getService(this.namedCluster, HBaseService.class);
        }
        catch (ClusterInitializationException e) {
            throw new KettleStepException((Throwable)e);
        }
        if (Const.isEmpty((String)this.m_coreConfigURL) && Const.isEmpty((String)this.namedCluster.getZooKeeperHost())) {
            throw new KettleStepException("No output fields available (missing connection details)!");
        }
        if (this.m_mapping == null && (Const.isEmpty((String)this.m_sourceTableName) || Const.isEmpty((String)this.m_sourceMappingName))) {
            throw new KettleStepException("No output fields available (missing table mapping details)!");
        }
        if (this.m_cachedMapping == null) {
            if (this.m_mapping != null) {
                this.m_cachedMapping = this.m_mapping;
            } else {
                String coreConf = null;
                String defaultConf = null;
                try {
                    if (!Const.isEmpty((String)this.m_coreConfigURL)) {
                        coreConf = space.environmentSubstitute(this.m_coreConfigURL);
                    }
                    if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
                        defaultConf = space.environmentSubstitute(this.m_defaultConfigURL);
                    }
                }
                catch (Exception ex) {
                    throw new KettleStepException(ex.getMessage(), (Throwable)ex);
                }
                ArrayList forLogging = new ArrayList();
                try (HBaseConnection conf = hBaseService.getHBaseConnection(space, coreConf, defaultConf, this.log);){
                    MappingAdmin mappingAdmin = null;
                    for (String m : forLogging) {
                        this.logBasic(m);
                    }
                    mappingAdmin = new MappingAdmin(conf);
                    this.m_cachedMapping = mappingAdmin.getMapping(this.m_sourceTableName, this.m_sourceMappingName);
                }
                catch (Exception ex) {
                    throw new KettleStepException(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        rowMeta.clear();
        if (this.m_outputFields != null && this.m_outputFields.size() > 0) {
            for (HBaseValueMetaInterface vm : this.m_outputFields) {
                vm.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)vm);
            }
        } else {
            this.setupCachedMapping(space);
            int kettleType = this.m_cachedMapping.getKeyType() == Mapping.KeyType.DATE || this.m_cachedMapping.getKeyType() == Mapping.KeyType.UNSIGNED_DATE ? 3 : (this.m_cachedMapping.getKeyType() == Mapping.KeyType.STRING ? 2 : (this.m_cachedMapping.getKeyType() == Mapping.KeyType.BINARY ? 8 : 5));
            ValueMeta keyMeta = new ValueMeta(this.m_cachedMapping.getKeyName(), kettleType);
            keyMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)keyMeta);
            Map mappedColumnsByAlias = this.m_cachedMapping.getMappedColumns();
            Set aliasSet = mappedColumnsByAlias.keySet();
            for (String alias : aliasSet) {
                HBaseValueMetaInterface columnMeta = (HBaseValueMetaInterface)mappedColumnsByAlias.get(alias);
                columnMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)columnMeta);
            }
        }
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = namedCluster;
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public NamedClusterServiceLocator getNamedClusterServiceLocator() {
        return this.namedClusterServiceLocator;
    }

    public RuntimeTestActionService getRuntimeTestActionService() {
        return this.runtimeTestActionService;
    }

    public RuntimeTester getRuntimeTester() {
        return this.runtimeTester;
    }
}

