/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.state.spring.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.bundle.core.BundleStateService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEvent;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextListener;
import org.springframework.osgi.context.event.OsgiBundleContextFailedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextRefreshedEvent;
import org.springframework.osgi.extender.event.BootstrappingDependencyEvent;

public class SpringStateService
implements OsgiBundleApplicationContextListener,
BundleListener,
BundleStateService {
    private static final Logger LOG = LoggerFactory.getLogger(SpringStateService.class);
    private final Map<Long, OsgiBundleApplicationContextEvent> states = new ConcurrentHashMap<Long, OsgiBundleApplicationContextEvent>();

    public SpringStateService(BundleContext bundleContext) {
    }

    public String getName() {
        return "Spring DM";
    }

    public BundleState getState(Bundle bundle) {
        OsgiBundleApplicationContextEvent event = this.states.get(bundle.getBundleId());
        BundleState state = this.mapEventToState(event);
        return bundle.getState() != 32 ? BundleState.Unknown : state;
    }

    public String getDiag(Bundle bundle) {
        OsgiBundleApplicationContextEvent event = this.states.get(bundle.getBundleId());
        if (event == null) {
            return null;
        }
        StringBuilder message = new StringBuilder();
        Date date = new Date(event.getTimestamp());
        SimpleDateFormat df = new SimpleDateFormat();
        message.append(df.format(date) + "\n");
        Throwable ex = this.getException(event);
        if (ex != null) {
            message.append("Exception: \n");
            this.addMessages(message, ex);
        }
        return message.toString();
    }

    private void addMessages(StringBuilder message, Throwable ex) {
        if (ex != null) {
            message.append(ex.getMessage());
            message.append("\n");
            StringWriter errorWriter = new StringWriter();
            ex.printStackTrace(new PrintWriter(errorWriter));
            message.append(errorWriter.toString());
            message.append("\n");
        }
    }

    private Throwable getException(OsgiBundleApplicationContextEvent event) {
        if (!(event instanceof OsgiBundleContextFailedEvent)) {
            return null;
        }
        OsgiBundleContextFailedEvent failureEvent = (OsgiBundleContextFailedEvent)event;
        return failureEvent.getFailureCause();
    }

    public void onOsgiApplicationEvent(OsgiBundleApplicationContextEvent event) {
        if (LOG.isDebugEnabled()) {
            BundleState state = this.mapEventToState(event);
            LOG.debug("Spring app state changed to " + state + " for bundle " + event.getBundle().getBundleId());
        }
        this.states.put(event.getBundle().getBundleId(), event);
    }

    private BundleState mapEventToState(OsgiBundleApplicationContextEvent event) {
        if (event == null) {
            return BundleState.Unknown;
        }
        if (event instanceof BootstrappingDependencyEvent) {
            return BundleState.Waiting;
        }
        if (event instanceof OsgiBundleContextFailedEvent) {
            return BundleState.Failure;
        }
        if (event instanceof OsgiBundleContextRefreshedEvent) {
            return BundleState.Active;
        }
        return BundleState.Unknown;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.states.remove(event.getBundle().getBundleId());
        }
    }
}

