/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.sql.Timestamp;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.StoreService;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.db.SLADbOperations;

public class CoordActionCheckCommand
extends CoordinatorCommand<Void> {
    private String actionId;
    private int actionCheckDelay;
    private final XLog log = XLog.getLog(this.getClass());
    private CoordinatorActionBean coordAction = null;

    public CoordActionCheckCommand(String actionId, int actionCheckDelay) {
        super("coord_action_check", "coord_action_check", 0, 4);
        this.actionId = actionId;
        this.actionCheckDelay = actionCheckDelay;
    }

    @Override
    protected Void call(CoordinatorStore cstore) throws StoreException, CommandException {
        try {
            Timestamp actionCheckTs = new Timestamp(System.currentTimeMillis() - (long)(this.actionCheckDelay * 1000));
            Timestamp cactionLmt = this.coordAction.getLastModifiedTimestamp();
            if (cactionLmt.after(actionCheckTs)) {
                this.log.info("The coord action :" + this.actionId + " has been udated. Ignore CoordActionCheckCommand!");
                return null;
            }
            if (!(this.coordAction.getStatus().equals((Object)CoordinatorAction.Status.SUCCEEDED) || this.coordAction.getStatus().equals((Object)CoordinatorAction.Status.FAILED) || this.coordAction.getStatus().equals((Object)CoordinatorAction.Status.KILLED))) {
                this.incrJobCounter(1);
                WorkflowStore wstore = Services.get().get(StoreService.class).getStore(WorkflowStore.class, cstore);
                WorkflowJobBean wf = wstore.getWorkflow(this.coordAction.getExternalId(), false);
                SLAEvent.Status slaStatus = null;
                if (wf.getStatus() == WorkflowJob.Status.SUCCEEDED) {
                    this.coordAction.setStatus(CoordinatorAction.Status.SUCCEEDED);
                    slaStatus = SLAEvent.Status.SUCCEEDED;
                } else if (wf.getStatus() == WorkflowJob.Status.FAILED) {
                    this.coordAction.setStatus(CoordinatorAction.Status.FAILED);
                    slaStatus = SLAEvent.Status.FAILED;
                } else if (wf.getStatus() == WorkflowJob.Status.KILLED) {
                    this.coordAction.setStatus(CoordinatorAction.Status.KILLED);
                    slaStatus = SLAEvent.Status.KILLED;
                } else {
                    this.log.warn("Unexpected workflow " + wf.getId() + " STATUS " + wf.getStatus());
                    cstore.updateCoordinatorAction(this.coordAction);
                    return null;
                }
                this.log.debug("Updating Coordintaor actionId :" + this.coordAction.getId() + "status to =" + this.coordAction.getStatus());
                cstore.updateCoordinatorAction(this.coordAction);
                if (slaStatus != null) {
                    SLADbOperations.writeStausEvent(this.coordAction.getSlaXml(), this.coordAction.getId(), cstore, slaStatus, SLAEvent.SlaAppType.COORDINATOR_ACTION);
                }
            }
        }
        catch (XException ex) {
            this.log.warn((Object)"CoordActionCheckCommand Failed ", ex);
            throw new CommandException(ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        this.log.info("STARTED CoordActionCheckCommand for actionId = " + this.actionId);
        try {
            this.coordAction = (CoordinatorActionBean)store.getEntityManager().find(CoordinatorActionBean.class, (Object)this.actionId);
            this.setLogInfo(this.coordAction);
            if (this.lock(this.coordAction.getJobId())) {
                this.call(store);
            } else {
                this.queueCallable(new CoordActionCheckCommand(this.actionId, this.actionCheckDelay), 30000L);
                this.log.warn("CoordActionCheckCommand lock was not acquired - failed jobId=" + this.coordAction.getJobId() + ", actionId=" + this.actionId + ". Requeing the same.");
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new CoordActionCheckCommand(this.actionId, this.actionCheckDelay), 30000L);
            this.log.warn("CoordActionCheckCommand lock acquiring failed with exception " + e.getMessage() + " for jobId=" + this.coordAction.getJobId() + ", actionId=" + this.actionId + " Requeing the same.");
        }
        finally {
            this.log.info("ENDED CoordActionCheckCommand for actionId:" + this.actionId);
        }
        return null;
    }
}

