/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.metadata;

import java.io.Serializable;
import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.docbundle.metadata.BundleManifest;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public class DefaultBundleManifest
implements BundleManifest,
Serializable,
Cloneable {
    private LinkedMap entries = new LinkedMap(10, 0.75f);
    private AttributeMap<String> entryAttributes = new AttributeMap();
    private static final long serialVersionUID = 5116035029040370976L;

    public void addEntry(String fullPath, String mediaType) {
        if (fullPath == null) {
            throw new NullPointerException();
        }
        if (mediaType == null) {
            this.entries.put((Object)fullPath, (Object)"");
        } else {
            this.entries.put((Object)fullPath, (Object)mediaType);
        }
    }

    public void setAttribute(String entryName, String attributeName, String value) {
        this.entryAttributes.setAttribute(entryName, attributeName, (Object)value);
    }

    @Override
    public String getAttribute(String entryName, String attributeName) {
        return (String)this.entryAttributes.getAttribute(entryName, attributeName);
    }

    @Override
    public String getMimeType(String entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        return (String)this.entries.get((Object)entry);
    }

    @Override
    public String[] getEntries() {
        return (String[])this.entries.keys((Object[])new String[this.entries.size()]);
    }

    public boolean removeEntry(String entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        boolean b = this.entries.remove((Object)entry) != null;
        String[] names = this.entryAttributes.getNames(entry);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            this.entryAttributes.setAttribute(entry, name, null);
        }
        return b;
    }

    @Override
    public String[] getAttributeNames(String entryName) {
        return this.entryAttributes.getNames(entryName);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultBundleManifest manifest = (DefaultBundleManifest)super.clone();
        manifest.entries = (LinkedMap)this.entries.clone();
        manifest.entryAttributes = this.entryAttributes.clone();
        return manifest;
    }
}

