/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageDelimitedTextWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
public class OfflineImageViewerPB {
    public static final Log LOG = LogFactory.getLog(OfflineImageViewerPB.class);
    private static final String usage = "Usage: bin/hdfs oiv [OPTIONS] -i INPUTFILE -o OUTPUTFILE\nOffline Image Viewer\nView a Hadoop fsimage INPUTFILE using the specified PROCESSOR,\nsaving the results in OUTPUTFILE.\n\nThe oiv utility will attempt to parse correctly formed image files\nand will abort fail with mal-formed image files.\n\nThe tool works offline and does not require a running cluster in\norder to process an image file.\n\nThe following image processors are available:\n  * XML: This processor creates an XML document with all elements of\n    the fsimage enumerated, suitable for further analysis by XML\n    tools.\n  * FileDistribution: This processor analyzes the file size\n    distribution in the image.\n    -maxSize specifies the range [0, maxSize] of file sizes to be\n     analyzed (128GB by default).\n    -step defines the granularity of the distribution. (2MB by default)\n  * Web: Run a viewer to expose read-only WebHDFS API.\n    -addr specifies the address to listen. (localhost:5978 by default)\n  * Delimited: Generate a text file with all of the elements common\n    to both inodes and inodes-under-construction, separated by a\n    delimiter. The default delimiter is \\t, though this may be\n    changed via the -delimiter argument.\n\nRequired command line arguments:\n-i,--inputFile <arg>   FSImage file to process.\n\nOptional command line arguments:\n-o,--outputFile <arg>  Name of output file. If the specified\n                       file exists, it will be overwritten.\n                       (output to stdout by default)\n-p,--processor <arg>   Select which type of processor to apply\n                       against image file. (XML|FileDistribution|Web|Delimited)\n                       (Web by default)\n-delimiter <arg>       Delimiting string to use with Delimited processor\n-t,--temp <arg>        Use temporary dir to cache intermediate result to generate\n                       Delimited outputs. If not set, Delimited processor constructs\n                       the namespace in memory before outputting text.-h,--help              Display usage information and exit\n";

    private static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"inputFile");
        options.addOption(OptionBuilder.create((String)"i"));
        options.addOption("o", "outputFile", true, "");
        options.addOption("p", "processor", true, "");
        options.addOption("h", "help", false, "");
        options.addOption("maxSize", true, "");
        options.addOption("step", true, "");
        options.addOption("addr", true, "");
        options.addOption("delimiter", true, "");
        options.addOption("t", "temp", true, "");
        return options;
    }

    public static void main(String[] args) throws Exception {
        int status = OfflineImageViewerPB.run(args);
        System.exit(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static int run(String[] args) throws Exception {
        int writer2222222222;
        CommandLine cmd;
        Options options = OfflineImageViewerPB.buildOptions();
        if (args.length == 0) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Error parsing command-line options: ");
            OfflineImageViewerPB.printUsage();
            return -1;
        }
        if (cmd.hasOption("h")) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        String inputFile = cmd.getOptionValue("i");
        String processor = cmd.getOptionValue("p", "Web");
        String outputFile = cmd.getOptionValue("o", "-");
        String delimiter = cmd.getOptionValue("delimiter", "\t");
        String tempPath = cmd.getOptionValue("t", "");
        PrintWriter out = outputFile.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new File(outputFile));
        Configuration conf = new Configuration();
        try {
            if (processor.equals("FileDistribution")) {
                long maxSize = Long.parseLong(cmd.getOptionValue("maxSize", "0"));
                int step = Integer.parseInt(cmd.getOptionValue("step", "0"));
                new FileDistributionCalculator(conf, maxSize, step, out).visit(new RandomAccessFile(inputFile, "r"));
            } else if (processor.equals("XML")) {
                new PBImageXmlWriter(conf, out).visit(new RandomAccessFile(inputFile, "r"));
            } else {
                if (processor.equals("Web")) {
                    String addr = cmd.getOptionValue("addr", "localhost:5978");
                    try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)addr));){
                        viewer.start(inputFile);
                    }
                }
                if (processor.equals("Delimited")) {
                    try (PBImageDelimitedTextWriter writer2222222222 = new PBImageDelimitedTextWriter(new PrintStream((OutputStream)new WriterOutputStream((Writer)out)), delimiter, tempPath);){
                        writer2222222222.visit(new RandomAccessFile(inputFile, "r"));
                    }
                }
            }
            writer2222222222 = 0;
        }
        catch (EOFException e) {
            System.err.println("Input file ended unexpectedly. Exiting");
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
        }
        catch (IOException e2) {
            System.err.println("Encountered exception.  Exiting: " + e2.getMessage());
            {
                catch (Throwable throwable) {
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
                    throw throwable;
                }
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
        return writer2222222222;
        return -1;
    }

    private static void printUsage() {
        System.out.println(usage);
    }
}

