/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Vector;
import netscape.ldap.LDAPSchemaElement;

public class LDAPNameFormSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = 1665316286199590403L;
    private Vector must = new Vector();
    private Vector may = new Vector();
    private String objectClass = null;
    static final String[] NOVALS = new String[]{"OBSOLETE"};
    static final String[] IGNOREVALS;

    static {
        int n = 0;
        while (n < NOVALS.length) {
            LDAPSchemaElement.novalsTable.put(NOVALS[n], NOVALS[n]);
            ++n;
        }
        IGNOREVALS = new String[]{"MUST", "MAY", "OBJECTCLASS", "OBSOLETE"};
    }

    public LDAPNameFormSchema(String string) {
        this.attrName = "objectclasses";
        this.parseValue(string);
        Object v = this.properties.get("MAY");
        if (v != null) {
            if (v instanceof Vector) {
                this.may = (Vector)v;
            } else {
                this.may.addElement(v);
            }
        }
        if ((v = this.properties.get("MUST")) != null) {
            if (v instanceof Vector) {
                this.must = (Vector)v;
            } else {
                this.must.addElement(v);
            }
        }
        if ((v = this.properties.get("OC")) != null) {
            this.objectClass = (String)v;
        }
    }

    public LDAPNameFormSchema(String string, String string2, String string3, boolean bl, String string4, String[] stringArray, String[] stringArray2) {
        super(string, string2, string3, null);
        int n;
        this.attrName = "nameforms";
        if (bl) {
            this.setQualifier("OBSOLETE", "");
        }
        this.objectClass = string4;
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                this.must.addElement(stringArray[n]);
                ++n;
            }
        }
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                this.may.addElement(stringArray2[n]);
                ++n;
            }
        }
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public String[] getOptionalNamingAttributes() {
        Object[] objectArray = new String[this.may.size()];
        this.may.copyInto(objectArray);
        return objectArray;
    }

    public String[] getRequiredNamingAttributes() {
        Object[] objectArray = new String[this.must.size()];
        this.must.copyInto(objectArray);
        return objectArray;
    }

    String getValue(boolean bl) {
        String string = this.getValuePrefix();
        String string2 = this.getOptionalValues(NOVALS);
        if (string2.length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        string = String.valueOf(string) + "OC " + this.objectClass + ' ';
        if (this.must.size() > 0) {
            string = String.valueOf(string) + "MUST " + this.vectorToList(this.must);
            string = String.valueOf(string) + ' ';
        }
        if (this.may.size() > 0) {
            string = String.valueOf(string) + "MAY " + this.vectorToList(this.may);
            string = String.valueOf(string) + ' ';
        }
        if ((string2 = this.getCustomValues()).length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        string = String.valueOf(string) + ')';
        return string;
    }

    public String toString() {
        String string = "Name: " + this.name + "; OID: " + this.oid;
        string = String.valueOf(string) + "; Description: " + this.description + "; Required: ";
        String[] stringArray = this.getRequiredNamingAttributes();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + stringArray[n];
            ++n;
        }
        string = String.valueOf(string) + "; Optional: ";
        stringArray = this.getOptionalNamingAttributes();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 > 0) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + stringArray[n2];
            ++n2;
        }
        if (this.isObsolete()) {
            string = String.valueOf(string) + "; OBSOLETE";
        }
        string = String.valueOf(string) + this.getQualifierString(IGNOREVALS);
        return string;
    }

    protected String vectorToList(Vector vector) {
        String string = "( ";
        int n = 0;
        while (n < vector.size()) {
            string = String.valueOf(string) + (String)vector.elementAt(n) + ' ';
            if (n < vector.size() - 1) {
                string = String.valueOf(string) + "$ ";
            }
            ++n;
        }
        string = String.valueOf(string) + ')';
        return string;
    }
}

