/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.baserver.utils.BAServerCommonDialog;
import org.pentaho.di.baserver.utils.CallEndpointMeta;
import org.pentaho.di.baserver.utils.widgets.TabFolderBuilder;
import org.pentaho.di.baserver.utils.widgets.callEndpointTabs.EndpointTab;
import org.pentaho.di.baserver.utils.widgets.callEndpointTabs.OutputFieldsTab;
import org.pentaho.di.baserver.utils.widgets.callEndpointTabs.ParametersTab;
import org.pentaho.di.baserver.utils.widgets.callEndpointTabs.ServerTab;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class CallEndpointDialog
extends BAServerCommonDialog<CallEndpointMeta> {
    private ServerTab serverTab;
    private EndpointTab endpointTab;
    private ParametersTab parametersTab;
    private OutputFieldsTab outputFieldsTab;

    public CallEndpointDialog(Shell parent, Object in, TransMeta transMeta, String name) {
        super(parent, (CallEndpointMeta)((Object)in), transMeta, name);
    }

    @Override
    protected boolean isValid() {
        return super.isValid() && this.serverTab.isValid() && this.endpointTab.isValid() && this.parametersTab.isValid() && this.outputFieldsTab.isValid();
    }

    @Override
    protected int getMinimumHeight() {
        if (Const.isLinux()) {
            return 600;
        }
        return 555;
    }

    @Override
    protected int getMinimumWidth() {
        return 664;
    }

    @Override
    protected String getTitleKey() {
        return "CallEndpointDialog.DialogTitle";
    }

    @Override
    public void buildContent(Composite parent) {
        CTabFolder tabFolder = (CTabFolder)new TabFolderBuilder(parent, this.props).setLeftPlacement(0).setRightPlacement(100).setTopPlacement(0).setBottomPlacement(100).build();
        this.props.setLook((Control)tabFolder, 5);
        this.serverTab = new ServerTab(tabFolder, this.props, this.transMeta, this.changeListener, (SelectionListener)this.selectionListener);
        this.endpointTab = new EndpointTab(tabFolder, this.props, this.transMeta, this.changeListener, (SelectionListener)this.selectionListener, this.stepname, this.log, this.serverTab);
        this.parametersTab = new ParametersTab(tabFolder, this.props, this.transMeta, (CallEndpointMeta)((Object)this.getMetaInfo()), this.changeListener, this.stepname, this.log);
        this.outputFieldsTab = new OutputFieldsTab(tabFolder, this.props, (VariableSpace)this.transMeta, this.changeListener);
        tabFolder.setSelection(0);
    }

    @Override
    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"icons/callendpoint.svg", (int)32, (int)32);
    }

    @Override
    protected void loadData(CallEndpointMeta meta) {
        super.loadData(meta);
        this.serverTab.loadData(meta);
        this.endpointTab.loadData(meta);
        this.parametersTab.loadData(meta);
        this.outputFieldsTab.loadData(meta);
    }

    @Override
    protected void saveData(CallEndpointMeta meta) {
        super.saveData(meta);
        this.serverTab.saveData(meta);
        this.endpointTab.saveData(meta);
        this.parametersTab.saveData(meta);
        this.outputFieldsTab.saveData(meta);
    }
}

