/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.xul;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.pentaho.di.core.SwtUniversalImageSvg;
import org.pentaho.di.core.svg.SvgImage;
import org.pentaho.di.core.svg.SvgSupport;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class KettleDialog
extends SwtDialog {
    private Map<String, Image[]> imagesCache = new HashMap<String, Image[]>();
    static final int[] IMAGE_SIZES = new int[]{256, 128, 64, 48, 32, 16};

    public KettleDialog(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super(self, parent, container, tagName);
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean force) {
        if (force || !this.buttonsCreated) {
            this.setButtons();
        }
        this.isDialogHidden = false;
        this.dialog.getShell().setText(this.title);
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            BaseStepDialog.setSize(this.getShell(), this.getWidth(), this.getHeight(), true);
        } else {
            BaseStepDialog.setSize(this.getShell());
        }
        this.width = this.getShell().getSize().x;
        this.height = this.getShell().getSize().y;
        this.dialog.getShell().layout(true, true);
        this.notifyListeners(555);
        this.setAppicon(this.appIcon);
        this.returnCode = this.dialog.open();
    }

    public void hide() {
        if (this.closing || this.dialog.getMainArea().isDisposed() || this.getParentShell(this.getParent()).isDisposed() || this.getParent() instanceof SwtDialog && ((SwtDialog)this.getParent()).isDisposing()) {
            return;
        }
        WindowProperty windowProperty = new WindowProperty(this.getShell());
        PropsUI.getInstance().setScreen(windowProperty);
        super.hide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppicon(String icon) {
        Image[] images;
        this.appIcon = icon;
        if (this.appIcon == null || this.dialog == null) {
            return;
        }
        Map<String, Image[]> map = this.imagesCache;
        synchronized (map) {
            images = this.imagesCache.get(icon);
        }
        if (images == null) {
            images = this.loadImages(icon);
            map = this.imagesCache;
            synchronized (map) {
                this.imagesCache.put(icon, images);
            }
        }
        if (images == null) {
            super.setAppicon(icon);
        } else if (images != null && this.dialog != null) {
            this.dialog.getShell().setImages(images);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image[] loadImages(String resource) {
        InputStream in;
        Display d = this.dialog.getShell().getDisplay();
        if (d == null) {
            Display display = d = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        }
        if (SvgSupport.isSvgEnabled() && (SvgSupport.isSvgName((String)resource) || SvgSupport.isPngName((String)resource))) {
            in = null;
            try {
                in = this.getResourceInputStream(resource);
                SvgImage svg = SvgSupport.loadSvgImage((InputStream)in);
                SwtUniversalImageSvg image = new SwtUniversalImageSvg(svg);
                Image[] result = new Image[IMAGE_SIZES.length];
                for (int i = 0; i < IMAGE_SIZES.length; ++i) {
                    result[i] = image.getAsBitmapForSize((Device)d, IMAGE_SIZES[i], IMAGE_SIZES[i]);
                }
                Image[] imageArray = result;
                return imageArray;
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            resource = SvgSupport.toPngName((String)resource);
        }
        in = null;
        try {
            in = this.getResourceInputStream(resource);
            Image[] imageArray = new Image[]{new Image((Device)d, in)};
            return imageArray;
        }
        catch (Throwable throwable) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return null;
    }

    private InputStream getResourceInputStream(String resource) throws IOException {
        InputStream in = ((KettleXulLoader)this.domContainer.getXulLoader()).getOriginalResourceAsStream(resource);
        return in;
    }
}

