/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.trans;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.performance.StepPerformanceSnapShot;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.di.ui.trans.dialog.TransDialog;
import org.pentaho.di.ui.util.ImageUtil;

public class TransPerfDelegate
extends SpoonDelegate {
    private static Class<?> PKG = Spoon.class;
    private static final int DATA_CHOICE_WRITTEN = 0;
    private static final int DATA_CHOICE_READ = 1;
    private static final int DATA_CHOICE_INPUT = 2;
    private static final int DATA_CHOICE_OUTPUT = 3;
    private static final int DATA_CHOICE_UPDATED = 4;
    private static final int DATA_CHOICE_REJECTED = 5;
    private static final int DATA_CHOICE_INPUT_BUFFER_SIZE = 6;
    private static final int DATA_CHOICE_OUTPUT_BUFFER_SIZE = 7;
    private static String[] dataChoices = new String[]{BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Written", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Read", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Input", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Output", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Updated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Rejected", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.InputBufferSize", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.OutputBufferSize", (String[])new String[0])};
    private TransGraph transGraph;
    private CTabItem transPerfTab;
    private Map<String, List<StepPerformanceSnapShot>> stepPerformanceSnapShots;
    private String[] steps;
    private org.eclipse.swt.widgets.List stepsList;
    private Canvas canvas;
    private Image image;
    private long timeDifference;
    private String title;
    private org.eclipse.swt.widgets.List dataList;
    private Composite perfComposite;
    private boolean emptyGraph;

    public TransPerfDelegate(Spoon spoon, TransGraph transGraph) {
        super(spoon);
        this.transGraph = transGraph;
    }

    public void addTransPerf() {
        if (this.transGraph.extraViewComposite == null || this.transGraph.extraViewComposite.isDisposed()) {
            this.transGraph.addExtraView();
        } else if (this.transPerfTab != null && !this.transPerfTab.isDisposed()) {
            this.transGraph.extraViewTabFolder.setSelection(this.transPerfTab);
            return;
        }
        this.transPerfTab = new CTabItem(this.transGraph.extraViewTabFolder, 0);
        this.transPerfTab.setImage(GUIResource.getInstance().getImageShowPerf());
        this.transPerfTab.setText(BaseMessages.getString(PKG, (String)"Spoon.TransGraph.PerfTab.Name", (String[])new String[0]));
        this.perfComposite = new Composite((Composite)this.transGraph.extraViewTabFolder, 0);
        this.perfComposite.setBackground(GUIResource.getInstance().getColorBackground());
        this.perfComposite.setLayout((Layout)new FormLayout());
        this.spoon.props.setLook((Control)this.perfComposite);
        this.transGraph.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TransPerfDelegate.this.setupContent();
            }
        });
        this.transPerfTab.setControl((Control)this.perfComposite);
        this.transGraph.extraViewTabFolder.setSelection(this.transPerfTab);
        this.transGraph.extraViewTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TransPerfDelegate.this.layoutPerfComposite();
                TransPerfDelegate.this.updateGraph();
            }
        });
    }

    public void setupContent() {
        if (!this.transGraph.isRunning() || this.transGraph.trans == null || !this.transGraph.trans.getTransMeta().isCapturingStepPerformanceSnapShots()) {
            this.showEmptyGraph();
            return;
        }
        if (this.perfComposite.isDisposed()) {
            return;
        }
        for (Control control : this.perfComposite.getChildren()) {
            if (control.isDisposed()) continue;
            control.dispose();
        }
        this.emptyGraph = false;
        this.title = this.transGraph.trans.getTransMeta().getName();
        this.timeDifference = this.transGraph.trans.getTransMeta().getStepPerformanceCapturingDelay();
        this.stepPerformanceSnapShots = this.transGraph.trans.getStepPerformanceSnapShots();
        while (this.stepPerformanceSnapShots == null || this.stepPerformanceSnapShots.isEmpty()) {
            this.stepPerformanceSnapShots = this.transGraph.trans.getStepPerformanceSnapShots();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException arr$) {}
        }
        Set<String> stepsSet = this.stepPerformanceSnapShots.keySet();
        this.steps = stepsSet.toArray(new String[stepsSet.size()]);
        Arrays.sort(this.steps);
        Label dataListLabel = new Label(this.perfComposite, 0);
        dataListLabel.setText(BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Metrics.Label", (String[])new String[0]));
        this.spoon.props.setLook((Control)dataListLabel);
        FormData fdDataListLabel = new FormData();
        fdDataListLabel.left = new FormAttachment(0, 0);
        fdDataListLabel.right = new FormAttachment(this.spoon.props.getMiddlePct() / 2, 4);
        fdDataListLabel.top = new FormAttachment(0, 9);
        dataListLabel.setLayoutData((Object)fdDataListLabel);
        this.dataList = new org.eclipse.swt.widgets.List(this.perfComposite, 19202);
        this.spoon.props.setLook((Control)this.dataList);
        this.dataList.setItems(dataChoices);
        this.dataList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TransPerfDelegate.this.dataList.getSelectionCount() > 1 && TransPerfDelegate.this.stepsList.getSelectionCount() > 1) {
                    TransPerfDelegate.this.stepsList.setSelection(TransPerfDelegate.this.stepsList.getSelectionIndices()[0]);
                }
                TransPerfDelegate.this.updateGraph();
            }
        });
        FormData fdDataList = new FormData();
        fdDataList.left = new FormAttachment(0, 0);
        fdDataList.right = new FormAttachment(this.spoon.props.getMiddlePct() / 2, 4);
        fdDataList.top = new FormAttachment((Control)dataListLabel, 4);
        fdDataList.bottom = new FormAttachment(40, 4);
        this.dataList.setLayoutData((Object)fdDataList);
        Label stepsListLabel = new Label(this.perfComposite, 0);
        stepsListLabel.setText(BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Steps.Label", (String[])new String[0]));
        this.spoon.props.setLook((Control)stepsListLabel);
        FormData fdStepsListLabel = new FormData();
        fdStepsListLabel.left = new FormAttachment(0, 0);
        fdStepsListLabel.right = new FormAttachment(this.spoon.props.getMiddlePct() / 2, 4);
        fdStepsListLabel.top = new FormAttachment((Control)this.dataList, 4);
        stepsListLabel.setLayoutData((Object)fdStepsListLabel);
        this.stepsList = new org.eclipse.swt.widgets.List(this.perfComposite, 19202);
        this.spoon.props.setLook((Control)this.stepsList);
        this.stepsList.setItems(this.steps);
        this.stepsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TransPerfDelegate.this.dataList.getSelectionCount() > 1 && TransPerfDelegate.this.stepsList.getSelectionCount() > 1) {
                    TransPerfDelegate.this.dataList.setSelection(TransPerfDelegate.this.dataList.getSelectionIndices()[0]);
                }
                TransPerfDelegate.this.updateGraph();
            }
        });
        FormData fdStepsList = new FormData();
        fdStepsList.left = new FormAttachment(0, 0);
        fdStepsList.right = new FormAttachment(this.spoon.props.getMiddlePct() / 2, 4);
        fdStepsList.top = new FormAttachment((Control)stepsListLabel, 4);
        fdStepsList.bottom = new FormAttachment(100, 4);
        this.stepsList.setLayoutData((Object)fdStepsList);
        this.canvas = new Canvas(this.perfComposite, 0);
        this.spoon.props.setLook((Control)this.canvas);
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(this.spoon.props.getMiddlePct() / 2, 4);
        fdCanvas.right = new FormAttachment(100, 0);
        fdCanvas.top = new FormAttachment(0, 4);
        fdCanvas.bottom = new FormAttachment(100, 0);
        this.canvas.setLayoutData((Object)fdCanvas);
        this.perfComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                TransPerfDelegate.this.updateGraph();
            }
        });
        this.perfComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (TransPerfDelegate.this.image != null) {
                    TransPerfDelegate.this.image.dispose();
                }
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (TransPerfDelegate.this.image != null && !TransPerfDelegate.this.image.isDisposed()) {
                    event.gc.drawImage(TransPerfDelegate.this.image, 0, 0);
                }
            }
        });
        final Timer timer = new Timer("TransPerfDelegate Timer");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                TransPerfDelegate.this.updateGraph();
            }
        }, 0L, 5000L);
        this.transPerfTab.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                timer.cancel();
            }
        });
    }

    private void showEmptyGraph() {
        if (this.perfComposite.isDisposed()) {
            return;
        }
        this.emptyGraph = true;
        Label label = new Label(this.perfComposite, 0x1000000);
        label.setText(BaseMessages.getString(PKG, (String)"TransLog.Dialog.PerformanceMonitoringNotEnabled.Message", (String[])new String[0]));
        label.setBackground(this.perfComposite.getBackground());
        label.setFont(GUIResource.getInstance().getFontMedium());
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(5, 0);
        fdLabel.right = new FormAttachment(95, 0);
        fdLabel.top = new FormAttachment(5, 0);
        label.setLayoutData((Object)fdLabel);
        Button button = new Button(this.perfComposite, 0x1000000);
        button.setText(BaseMessages.getString(PKG, (String)"TransLog.Dialog.PerformanceMonitoring.Button", (String[])new String[0]));
        button.setBackground(this.perfComposite.getBackground());
        button.setFont(GUIResource.getInstance().getFontMedium());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransGraph.editProperties(TransPerfDelegate.this.spoon.getActiveTransformation(), TransPerfDelegate.this.spoon, ((TransPerfDelegate)TransPerfDelegate.this).spoon.rep, true, TransDialog.Tabs.MONITOR_TAB);
            }
        });
        FormData fdButton = new FormData();
        fdButton.left = new FormAttachment(40, 0);
        fdButton.right = new FormAttachment(60, 0);
        fdButton.top = new FormAttachment((Control)label, 5);
        button.setLayoutData((Object)fdButton);
        this.perfComposite.layout(true, true);
    }

    public void showPerfView() {
        if (this.transPerfTab == null || this.transPerfTab.isDisposed()) {
            this.addTransPerf();
        } else {
            this.transPerfTab.dispose();
            this.transGraph.checkEmptyExtraView();
        }
    }

    private void updateGraph() {
        this.transGraph.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TransPerfDelegate.this.perfComposite != null && !TransPerfDelegate.this.perfComposite.isDisposed() && TransPerfDelegate.this.canvas != null && !TransPerfDelegate.this.canvas.isDisposed() && TransPerfDelegate.this.transPerfTab != null && !TransPerfDelegate.this.transPerfTab.isDisposed() && TransPerfDelegate.this.transPerfTab.isShowing()) {
                    TransPerfDelegate.this.updateCanvas();
                }
            }
        });
    }

    private void updateCanvas() {
        int[] dataIndices;
        Rectangle bounds = this.canvas.getBounds();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return;
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        String[] selectedSteps = this.stepsList.getSelection();
        if (selectedSteps == null || selectedSteps.length == 0) {
            selectedSteps = new String[]{this.steps[0]};
            this.stepsList.select(0);
        }
        if ((dataIndices = this.dataList.getSelectionIndices()) == null || dataIndices.length == 0) {
            dataIndices = new int[]{0};
            this.dataList.select(0);
        }
        boolean multiStep = this.stepsList.getSelectionCount() > 1;
        boolean multiData = this.dataList.getSelectionCount() > 1;
        boolean calcMoving = !multiStep && !multiData;
        ArrayList<Double> movingList = new ArrayList<Double>();
        int movingSize = 10;
        double movingTotal = 0.0;
        int totalTimeInSeconds = 0;
        for (int t = 0; t < selectedSteps.length; ++t) {
            String stepNameCopy = selectedSteps[t];
            List<StepPerformanceSnapShot> snapShotList = this.stepPerformanceSnapShots.get(stepNameCopy);
            if (snapShotList == null || snapShotList.size() <= 1) continue;
            totalTimeInSeconds = (int)Math.round((double)(snapShotList.get(snapShotList.size() - 1).getDate().getTime() - snapShotList.get(0).getDate().getTime()) / 1000.0);
            for (int i = 0; i < snapShotList.size(); ++i) {
                StepPerformanceSnapShot snapShot = snapShotList.get(i);
                if (snapShot.getTimeDifference() == 0L) continue;
                double factor = 1000.0 / (double)snapShot.getTimeDifference();
                for (int d = 0; d < dataIndices.length; ++d) {
                    String dataType = multiStep ? stepNameCopy : dataChoices[dataIndices[d]];
                    String xLabel = Integer.toString(Math.round((long)i * this.timeDifference / 1000L));
                    Double metric = null;
                    switch (dataIndices[d]) {
                        case 2: {
                            metric = (double)snapShot.getLinesInput() * factor;
                            break;
                        }
                        case 3: {
                            metric = (double)snapShot.getLinesOutput() * factor;
                            break;
                        }
                        case 1: {
                            metric = (double)snapShot.getLinesRead() * factor;
                            break;
                        }
                        case 0: {
                            metric = (double)snapShot.getLinesWritten() * factor;
                            break;
                        }
                        case 4: {
                            metric = (double)snapShot.getLinesUpdated() * factor;
                            break;
                        }
                        case 5: {
                            metric = (double)snapShot.getLinesRejected() * factor;
                            break;
                        }
                        case 6: {
                            metric = snapShot.getInputBufferSize();
                            break;
                        }
                        case 7: {
                            metric = snapShot.getOutputBufferSize();
                            break;
                        }
                    }
                    if (metric == null) continue;
                    dataset.addValue((Number)metric, (Comparable)((Object)dataType), (Comparable)((Object)xLabel));
                    if (!calcMoving) continue;
                    movingTotal += metric.doubleValue();
                    movingList.add(metric);
                    if (movingList.size() > movingSize) {
                        movingTotal -= ((Double)movingList.get(0)).doubleValue();
                        movingList.remove(0);
                    }
                    double movingAverage = movingTotal / (double)movingList.size();
                    dataset.addValue(movingAverage, (Comparable)((Object)(dataType + "(Avg)")), (Comparable)((Object)xLabel));
                }
            }
        }
        String chartTitle = this.title;
        chartTitle = multiStep ? chartTitle + " (" + dataChoices[dataIndices[0]] + ")" : chartTitle + " (" + selectedSteps[0] + ")";
        JFreeChart chart = ChartFactory.createLineChart((String)chartTitle, (String)BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.TimeInSeconds.Label", (String[])new String[]{Integer.toString(totalTimeInSeconds), Long.toString(this.timeDifference)}), (String)BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.RowsPerSecond.Label", (String[])new String[0]), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        TextTitle title = new TextTitle(chartTitle);
        title.setFont(new Font("SansSerif", 1, 12));
        chart.setTitle(title);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setForegroundAlpha(0.5f);
        plot.setRangeGridlinesVisible(true);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setTickLabelsVisible(false);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseShapesVisible(true);
        renderer.setDrawOutlines(true);
        renderer.setUseFillPaint(true);
        renderer.setBaseFillPaint((Paint)Color.white);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.5f));
        renderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(1.5f));
        renderer.setSeriesStroke(1, (Stroke)new BasicStroke(2.5f));
        renderer.setSeriesOutlineStroke(1, (Stroke)new BasicStroke(2.5f));
        renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        BufferedImage bufferedImage = chart.createBufferedImage(bounds.width, bounds.height, 1, null);
        ImageData imageData = ImageUtil.convertToSWT(bufferedImage);
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = new Image((Device)this.transGraph.getDisplay(), imageData);
        this.canvas.redraw();
    }

    public CTabItem getTransPerfTab() {
        return this.transPerfTab;
    }

    public boolean isEmptyGraph() {
        return this.emptyGraph;
    }

    public void layoutPerfComposite() {
        if (!this.perfComposite.isDisposed()) {
            this.perfComposite.layout(true, true);
        }
    }
}

