/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.SpoonPerspectiveImageProvider;
import org.pentaho.di.ui.spoon.SpoonPerspectiveListener;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.tags.SwtDeck;
import org.pentaho.ui.xul.swt.tags.SwtToolbarbutton;
import org.pentaho.ui.xul.swt.tags.SwtVbox;

public class SpoonPerspectiveManager {
    private static SpoonPerspectiveManager instance = new SpoonPerspectiveManager();
    private final Map<Class<? extends SpoonPerspective>, SpoonPerspective> perspectives;
    private final Map<SpoonPerspective, PerspectiveInitializer> initializerMap;
    private final LinkedHashSet<SpoonPerspective> orderedPerspectives;
    private XulDeck deck;
    private SpoonPerspective activePerspective;
    private XulDomContainer domContainer;
    private boolean forcePerspective = false;
    private String startupPerspective = null;
    private final LogChannelInterface log = new LogChannel((Object)this);
    private List<SpoonPerspective> installedPerspectives = new ArrayList<SpoonPerspective>();

    public String getStartupPerspective() {
        return this.startupPerspective;
    }

    public void setStartupPerspective(String startupPerspective) {
        this.startupPerspective = startupPerspective;
    }

    private SpoonPerspectiveManager() {
        this.perspectives = new LinkedHashMap<Class<? extends SpoonPerspective>, SpoonPerspective>();
        this.initializerMap = new HashMap<SpoonPerspective, PerspectiveInitializer>();
        this.orderedPerspectives = new LinkedHashSet();
    }

    public static SpoonPerspectiveManager getInstance() {
        return instance;
    }

    public void setDeck(XulDeck deck) {
        this.deck = deck;
    }

    public void setXulDoc(XulDomContainer doc) {
        this.domContainer = doc;
    }

    public void addPerspective(SpoonPerspective perspective) {
        if (this.activePerspective == null) {
            this.activePerspective = perspective;
        }
        this.perspectives.put(perspective.getClass(), perspective);
        this.orderedPerspectives.add(perspective);
        if (this.domContainer != null) {
            this.initialize();
        }
    }

    public List<SpoonPerspective> getPerspectives() {
        return Collections.unmodifiableList(new ArrayList<SpoonPerspective>(this.orderedPerspectives));
    }

    private void unloadPerspective(SpoonPerspective per) {
        per.setActive(false);
        List<XulOverlay> overlays = per.getOverlays();
        if (overlays != null) {
            for (XulOverlay overlay : overlays) {
                try {
                    this.domContainer.removeOverlay(overlay.getOverlayUri());
                }
                catch (XulException e) {
                    this.log.logError("Error unload perspective", (Throwable)e);
                }
            }
        }
        Spoon.getInstance().enableMenus();
    }

    public void activatePerspective(Class<? extends SpoonPerspective> clazz) throws KettleException {
        List<XulEventHandler> theXulEventHandlers;
        if (this.forcePerspective) {
            return;
        }
        SpoonPerspective sp = this.perspectives.get(clazz);
        if (sp == null) {
            throw new KettleException("Could not locate perspective by class: " + clazz);
        }
        PerspectiveInitializer perspectiveInitializer = this.initializerMap.remove(sp);
        if (perspectiveInitializer != null) {
            perspectiveInitializer.initialize();
        }
        this.unloadPerspective(this.activePerspective);
        this.activePerspective = sp;
        List<XulOverlay> overlays = sp.getOverlays();
        if (overlays != null) {
            for (XulOverlay overlay : overlays) {
                try {
                    ResourceBundle res = null;
                    if (overlay.getResourceBundleUri() != null) {
                        try {
                            res = ResourceBundle.getBundle(overlay.getResourceBundleUri());
                        }
                        catch (MissingResourceException missingResourceException) {}
                    } else {
                        try {
                            res = ResourceBundle.getBundle(overlay.getOverlayUri().replace(".xul", ".properties"));
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                    }
                    if (res == null) {
                        res = new XulSpoonResourceBundle(sp.getClass());
                    }
                    this.domContainer.loadOverlay(overlay.getOverlayUri(), (Object)res);
                }
                catch (XulException e) {
                    this.log.logError("Error activate perspective", (Throwable)e);
                }
            }
        }
        if ((theXulEventHandlers = sp.getEventHandlers()) != null) {
            for (XulEventHandler handler : theXulEventHandlers) {
                this.domContainer.addEventHandler(handler);
            }
        }
        sp.setActive(true);
        this.deck.setSelectedIndex(this.deck.getChildNodes().indexOf(this.deck.getElementById("perspective-" + sp.getId())));
        Spoon.getInstance().enableMenus();
    }

    public SpoonPerspective getActivePerspective() {
        return this.activePerspective;
    }

    public boolean isForcePerspective() {
        return this.forcePerspective;
    }

    public void setForcePerspective(boolean forcePerspective) {
        this.forcePerspective = forcePerspective;
    }

    public void removePerspective(SpoonPerspective per) {
        this.perspectives.remove(per);
        this.orderedPerspectives.remove(per);
        Document document = this.domContainer.getDocumentRoot();
        XulComponent comp = document.getElementById("perspective-" + per.getId());
        comp.getParent().removeChild((Element)comp);
        comp = document.getElementById("perspective-btn-" + per.getId());
        comp.getParent().removeChild((Element)comp);
        XulToolbar mainToolbar = (XulToolbar)this.domContainer.getDocumentRoot().getElementById("main-toolbar");
        ((Composite)mainToolbar.getManagedObject()).layout(true, true);
        this.deck.setSelectedIndex(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        XulToolbar mainToolbar = (XulToolbar)this.domContainer.getDocumentRoot().getElementById("main-toolbar");
        SwtDeck deck = (SwtDeck)this.domContainer.getDocumentRoot().getElementById("canvas-deck");
        int y = 0;
        int perspectiveIdx = 0;
        Class<?> perClass = null;
        List<SpoonPerspective> perspectives = this.getPerspectives();
        if (this.startupPerspective != null) {
            for (int i = 0; i < perspectives.size(); ++i) {
                if (!perspectives.get(i).getId().equals(this.startupPerspective)) continue;
                perspectiveIdx = i;
                break;
            }
        }
        CCombo perspectivesCombo = null;
        if (PropsUI.getInstance().isLegacyPerspectiveMode()) {
            this.log.logDebug("Use legacy perspective switcher");
        } else {
            this.log.logDebug("Use new perspective switcher");
            final ToolBar toolbar = (ToolBar)mainToolbar.getManagedObject();
            perspectivesCombo = new CCombo((Composite)toolbar, 2060);
            PropsUI.getInstance().setLook((Control)perspectivesCombo);
            final CCombo c = perspectivesCombo;
            perspectivesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    Spoon.getInstance().loadPerspective(c.getData(c.getText()).toString());
                    toolbar.forceFocus();
                }
            });
            perspectivesCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.character == '\r') {
                        Spoon.getInstance().loadPerspective(c.getText());
                    }
                }
            });
            ToolItem sep = new ToolItem(toolbar, 2);
            if (Const.isLinux()) {
                sep.setWidth(150);
            } else if (Const.isOSX()) {
                sep.setWidth(120);
            } else {
                sep.setWidth(140);
            }
            sep.setControl((Control)perspectivesCombo);
            toolbar.forceFocus();
        }
        for (SpoonPerspective per : this.getPerspectives()) {
            if (this.installedPerspectives.contains(per)) {
                ++y;
                continue;
            }
            String name = per.getDisplayName(LanguageChoice.getInstance().getDefaultLocale());
            SwtToolbarbutton btn = null;
            if (PropsUI.getInstance().isLegacyPerspectiveMode()) {
                InputStream in;
                try {
                    btn = (SwtToolbarbutton)this.domContainer.getDocumentRoot().createElement("toolbarbutton");
                }
                catch (XulException e) {
                    this.log.logError("Error create toolbarbutton", (Throwable)e);
                }
                btn.setType("toggle");
                btn.setLabel(name);
                btn.setTooltiptext(name);
                btn.setOnclick("spoon.loadPerspective(" + y + ")");
                btn.setId("perspective-btn-" + per.getId());
                mainToolbar.addChild((Element)btn);
                boolean iconSet = false;
                if (SpoonPerspectiveImageProvider.class.isAssignableFrom(per.getClass())) {
                    String location = ((SpoonPerspectiveImageProvider)per).getPerspectiveIconPath();
                    Image image = GUIResource.getInstance().getImage(location, per.getClass().getClassLoader(), 16, 16);
                    if (image != null) {
                        btn.setImage(image);
                        iconSet = true;
                    }
                }
                if (!iconSet && (in = per.getPerspectiveIcon()) != null) {
                    try {
                        btn.setImageFromStream(in);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
            } else {
                perspectivesCombo.add(name);
                perspectivesCombo.setData(name, (Object)per.getId());
            }
            SwtVbox box = deck.createVBoxCard();
            box.setId("perspective-" + per.getId());
            box.setFlex(1);
            deck.addChild((Element)box);
            PerspectiveInitializer perspectiveInitializer = new PerspectiveInitializer(per, (XulVbox)box, mainToolbar, btn, perspectivesCombo, name);
            if (perspectiveIdx == y || y == 0) {
                if (perspectiveIdx == y) {
                    if (btn != null) {
                        btn.setSelected(true);
                    }
                    perClass = per.getClass();
                }
                perspectiveInitializer.initialize();
            } else {
                this.initializerMap.put(per, perspectiveInitializer);
            }
            ++y;
            this.installedPerspectives.add(per);
        }
        deck.setSelectedIndex(perspectiveIdx);
        if (perClass != null) {
            try {
                this.activatePerspective(perClass);
                SpoonPerspectiveManager.getInstance().setForcePerspective(true);
            }
            catch (KettleException kettleException) {
                // empty catch block
            }
        }
    }

    private class PerspectiveInitializer {
        private final SpoonPerspective per;
        private final XulVbox box;
        private final XulToolbar mainToolbar;
        private final SwtToolbarbutton btn;
        private final CCombo perspectivesCombo;
        private final String name;

        public PerspectiveInitializer(SpoonPerspective per, XulVbox box, XulToolbar mainToolbar, SwtToolbarbutton btn, CCombo perspectivesCombo, String name) {
            this.per = per;
            this.box = box;
            this.mainToolbar = mainToolbar;
            this.btn = btn;
            this.perspectivesCombo = perspectivesCombo;
            this.name = name;
        }

        public void initialize() {
            this.per.getUI().setParent((Composite)this.box.getManagedObject());
            this.per.getUI().layout();
            ((Composite)this.mainToolbar.getManagedObject()).layout(true, true);
            this.per.addPerspectiveListener(new SpoonPerspectiveListener(){

                @Override
                public void onActivation() {
                    if (PerspectiveInitializer.this.btn != null) {
                        PerspectiveInitializer.this.btn.setSelected(true);
                    }
                    if (PerspectiveInitializer.this.perspectivesCombo != null) {
                        PerspectiveInitializer.this.perspectivesCombo.setText(PerspectiveInitializer.this.name);
                    }
                }

                @Override
                public void onDeactication() {
                    if (PerspectiveInitializer.this.btn != null) {
                        PerspectiveInitializer.this.btn.setSelected(false);
                    }
                }
            });
        }
    }

    protected static class SpoonPerspectiveComparator
    implements Comparator<SpoonPerspective> {
        protected SpoonPerspectiveComparator() {
        }

        @Override
        public int compare(SpoonPerspective o1, SpoonPerspective o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

