/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.copyfiles;

import java.util.HashMap;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.copyfiles.JobEntryCopyFiles;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVarButtonRenderCallback;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class JobEntryCopyFilesDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryCopyFiles.class;
    protected static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"JobCopyFiles.Filetype.All", (String[])new String[0])};
    public static final String LOCAL_ENVIRONMENT = "Local";
    public static final String STATIC_ENVIRONMENT = "<Static>";
    protected Text wName;
    protected Button wPrevious;
    protected Button wCopyEmptyFolders;
    protected Button wOverwriteFiles;
    protected Button wIncludeSubfolders;
    protected Button wRemoveSourceFiles;
    protected Button wAddFileToResult;
    protected Button wDestinationIsAFile;
    protected Button wCreateDestinationFolder;
    protected JobEntryCopyFiles jobEntry;
    protected Shell shell;
    protected boolean changed;
    private Label wlFields;
    protected TableView wFields;
    private ToolItem deleteToolItem;

    public JobEntryCopyFilesDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryCopyFiles)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobCopyFiles.Name.Default", (String[])new String[0]));
        }
    }

    protected void initUI() {
        int rows;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        Button helpButton = JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryCopyFilesDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobCopyFiles.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label wlName = new Label((Composite)this.shell, 16384);
        wlName.setText(BaseMessages.getString(PKG, (String)"JobCopyFiles.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(0, 0);
        fdName.top = new FormAttachment((Control)wlName, margin);
        fdName.right = new FormAttachment(40, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlIcon = new Label((Composite)this.shell, 131072);
        wlIcon.setImage(this.getImage());
        this.props.setLook((Control)wlIcon);
        FormData fdlIcon = new FormData();
        fdlIcon.top = new FormAttachment(0, margin * 3);
        fdlIcon.right = new FormAttachment(100, -margin);
        wlIcon.setLayoutData((Object)fdlIcon);
        Label lTopSeparator = new Label((Composite)this.shell, 258);
        FormData fdTopSeparator = new FormData();
        fdTopSeparator.top = new FormAttachment((Control)this.wName, margin * 3);
        fdTopSeparator.left = new FormAttachment(0, 0);
        fdTopSeparator.right = new FormAttachment(100, 0);
        lTopSeparator.setLayoutData((Object)fdTopSeparator);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)lTopSeparator, margin * 3);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, -60);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        CTabItem wFilesTab = new CTabItem(wTabFolder, 0);
        wFilesTab.setText(BaseMessages.getString(PKG, (String)"JobCopyFiles.Tab.Files.Label", (String[])new String[0]));
        Composite wFilesComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wFilesComp);
        FormLayout filesLayout = new FormLayout();
        filesLayout.marginWidth = 3;
        filesLayout.marginHeight = 3;
        wFilesComp.setLayout((Layout)filesLayout);
        FormData fdFilesComp = new FormData();
        fdFilesComp.left = new FormAttachment(0, 0);
        fdFilesComp.top = new FormAttachment(0, 0);
        fdFilesComp.right = new FormAttachment(100, 0);
        fdFilesComp.bottom = new FormAttachment(100, 0);
        wFilesComp.setLayoutData((Object)fdFilesComp);
        wFilesComp.layout();
        wFilesTab.setControl((Control)wFilesComp);
        CTabItem wSettingsTab = new CTabItem(wTabFolder, 0);
        wSettingsTab.setText(BaseMessages.getString(PKG, (String)"JobCopyFiles.Settings.Label", (String[])new String[0]));
        Composite wSettingsComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wSettingsComp);
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 3;
        settingsLayout.marginHeight = 3;
        wSettingsComp.setLayout((Layout)settingsLayout);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryCopyFilesDialog.this.jobEntry.setChanged();
            }
        };
        this.wIncludeSubfolders = this.createSettingsButton(wSettingsComp, "JobCopyFiles.IncludeSubfolders.Label", "JobCopyFiles.IncludeSubfolders.Tooltip", null, listener);
        this.wDestinationIsAFile = this.createSettingsButton(wSettingsComp, "JobCopyFiles.DestinationIsAFile.Label", "JobCopyFiles.DestinationIsAFile.Tooltip", (Control)this.wIncludeSubfolders, listener);
        this.wCopyEmptyFolders = this.createSettingsButton(wSettingsComp, "JobCopyFiles.CopyEmptyFolders.Label", "JobCopyFiles.CopyEmptyFolders.Tooltip", (Control)this.wDestinationIsAFile, listener);
        this.wCreateDestinationFolder = this.createSettingsButton(wSettingsComp, "JobCopyFiles.CreateDestinationFolder.Label", "JobCopyFiles.CreateDestinationFolder.Tooltip", (Control)this.wCopyEmptyFolders, listener);
        this.wOverwriteFiles = this.createSettingsButton(wSettingsComp, "JobCopyFiles.OverwriteFiles.Label", "JobCopyFiles.OverwriteFiles.Tooltip", (Control)this.wCreateDestinationFolder, listener);
        this.wRemoveSourceFiles = this.createSettingsButton(wSettingsComp, "JobCopyFiles.RemoveSourceFiles.Label", "JobCopyFiles.RemoveSourceFiles.Tooltip", (Control)this.wOverwriteFiles, listener);
        this.wPrevious = this.createSettingsButton(wSettingsComp, "JobCopyFiles.Previous.Label", "JobCopyFiles.Previous.Tooltip", (Control)this.wRemoveSourceFiles, listener);
        this.wAddFileToResult = this.createSettingsButton(wSettingsComp, "JobCopyFiles.AddFileToResult.Label", "JobCopyFiles.AddFileToResult.Tooltip", (Control)this.wPrevious, listener);
        FormData fdSettingsComp = new FormData();
        fdSettingsComp.left = new FormAttachment(0, 0);
        fdSettingsComp.top = new FormAttachment(0, 0);
        fdSettingsComp.right = new FormAttachment(100, 0);
        fdSettingsComp.bottom = new FormAttachment(100, 0);
        wSettingsComp.setLayoutData((Object)fdSettingsComp);
        wSettingsComp.layout();
        wSettingsTab.setControl((Control)wSettingsComp);
        this.props.setLook((Control)wSettingsComp);
        ToolBar tb = new ToolBar(wFilesComp, 0x800100);
        this.props.setLook((Control)tb);
        FormData fdTb = new FormData();
        fdTb.right = new FormAttachment(100, 0);
        fdTb.top = new FormAttachment((Control)wFilesComp, margin);
        tb.setLayoutData((Object)fdTb);
        this.deleteToolItem = new ToolItem(tb, 8);
        this.deleteToolItem.setImage(GUIResource.getInstance().getImageDelete());
        this.deleteToolItem.setToolTipText(BaseMessages.getString(PKG, (String)"JobCopyFiles.FilenameDelete.Tooltip", (String[])new String[0]));
        this.deleteToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = JobEntryCopyFilesDialog.this.wFields.getSelectionIndices();
                JobEntryCopyFilesDialog.this.wFields.remove(idx);
                JobEntryCopyFilesDialog.this.wFields.removeEmptyRows();
                JobEntryCopyFilesDialog.this.wFields.setRowNums();
            }
        });
        this.wlFields = new Label(wFilesComp, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"JobCopyFiles.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, margin);
        fdlFields.right = new FormAttachment(middle, -margin);
        fdlFields.top = new FormAttachment((Control)wFilesComp, 15);
        this.wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = rows = this.jobEntry.source_filefolder == null ? 1 : (this.jobEntry.source_filefolder.length == 0 ? 0 : this.jobEntry.source_filefolder.length);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobCopyFiles.Fields.SourceEnvironment.Label", (String[])new String[0]), 2, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobCopyFiles.Fields.SourceFileFolder.Label", (String[])new String[0]), 6, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobCopyFiles.Fields.Wildcard.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobCopyFiles.Fields.DestinationEnvironment.Label", (String[])new String[0]), 2, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobCopyFiles.Fields.DestinationFileFolder.Label", (String[])new String[0]), 6, false)};
        this.setComboValues(colinf[0]);
        TextVarButtonRenderCallback callback = new TextVarButtonRenderCallback(){

            @Override
            public boolean shouldRenderButton() {
                String envType = JobEntryCopyFilesDialog.this.wFields.getActiveTableItem().getText(JobEntryCopyFilesDialog.this.wFields.getActiveTableColumn() - 1);
                return !JobEntryCopyFilesDialog.STATIC_ENVIRONMENT.equalsIgnoreCase(envType);
            }
        };
        colinf[1].setUsingVariables(true);
        colinf[1].setToolTip(BaseMessages.getString(PKG, (String)"JobCopyFiles.Fields.SourceFileFolder.Tooltip", (String[])new String[0]));
        colinf[1].setTextVarButtonSelectionListener((SelectionListener)this.getFileSelectionAdapter());
        colinf[1].setRenderTextVarButtonCallback(callback);
        colinf[2].setUsingVariables(true);
        colinf[2].setToolTip(BaseMessages.getString(PKG, (String)"JobCopyFiles.Fields.Wildcard.Tooltip", (String[])new String[0]));
        this.setComboValues(colinf[3]);
        colinf[4].setUsingVariables(true);
        colinf[4].setToolTip(BaseMessages.getString(PKG, (String)"JobCopyFiles.Fields.DestinationFileFolder.Tooltip", (String[])new String[0]));
        colinf[4].setTextVarButtonSelectionListener((SelectionListener)this.getFileSelectionAdapter());
        this.wFields = new TableView((VariableSpace)this.jobMeta, wFilesComp, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, margin);
        fdFields.top = new FormAttachment((Control)tb, margin);
        fdFields.right = new FormAttachment(100, -margin);
        fdFields.bottom = new FormAttachment(100, -margin);
        this.wFields.setLayoutData(fdFields);
        this.refreshArgFromPrevious();
        Button wOK = new Button((Composite)this.shell, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        Label lBottomSeparator = new Label((Composite)this.shell, 258);
        FormData fdBottomSeparator = new FormData();
        fdBottomSeparator.top = new FormAttachment((Control)wTabFolder, margin * 3);
        fdBottomSeparator.left = new FormAttachment(0, 0);
        fdBottomSeparator.right = new FormAttachment(100, 0);
        lBottomSeparator.setLayoutData((Object)fdBottomSeparator);
        BaseStepDialog.positionBottomRightButtons((Composite)this.shell, new Button[]{wOK, wCancel}, margin, (Control)lBottomSeparator);
        FormData fdOK = (FormData)wOK.getLayoutData();
        FormData fdHelpButton = new FormData();
        fdHelpButton.top = fdOK.top;
        fdHelpButton.left = new FormAttachment(0, margin);
        helpButton.setLayoutData((Object)fdHelpButton);
        Listener lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryCopyFilesDialog.this.cancel();
            }
        };
        Listener lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryCopyFilesDialog.this.ok();
            }
        };
        wCancel.addListener(13, lsCancel);
        wOK.addListener(13, lsOK);
        SelectionAdapter lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryCopyFilesDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryCopyFilesDialog.this.cancel();
            }
        });
        this.getData();
        wTabFolder.setSelection(0);
    }

    public JobEntryInterface open() {
        this.initUI();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    protected Button createSettingsButton(Composite p, String text, String title, Control top, SelectionAdapter sa) {
        Button button = new Button(p, 32);
        button.setText(BaseMessages.getString(PKG, (String)text, (String[])new String[0]));
        button.setToolTipText(BaseMessages.getString(PKG, (String)title, (String[])new String[0]));
        this.props.setLook((Control)button);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 8);
        fd.top = top == null ? new FormAttachment(0, 10) : new FormAttachment(top, 5);
        fd.right = new FormAttachment(100, 0);
        button.setLayoutData((Object)fd);
        button.addSelectionListener((SelectionListener)sa);
        return button;
    }

    protected SelectionAdapter getFileSelectionAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileObject selectedFile = null;
                try {
                    FileObject rootFile = null;
                    FileObject initialFile = null;
                    FileObject defaultInitialFile = null;
                    String original = JobEntryCopyFilesDialog.this.wFields.getActiveTableItem().getText(JobEntryCopyFilesDialog.this.wFields.getActiveTableColumn());
                    if (original != null) {
                        String fileName = JobEntryCopyFilesDialog.this.jobMeta.environmentSubstitute(original);
                        if (fileName != null && !fileName.equals("")) {
                            try {
                                initialFile = KettleVFS.getFileObject((String)fileName);
                            }
                            catch (KettleException ex) {
                                initialFile = KettleVFS.getFileObject((String)"");
                            }
                            defaultInitialFile = KettleVFS.getFileObject((String)"file:///c:/");
                            rootFile = initialFile.getFileSystem().getRoot();
                        } else {
                            defaultInitialFile = KettleVFS.getFileObject((String)Spoon.getInstance().getLastFileOpened());
                        }
                    }
                    if (rootFile == null) {
                        rootFile = defaultInitialFile.getFileSystem().getRoot();
                        initialFile = defaultInitialFile;
                    }
                    VfsFileChooserDialog fileChooserDialog = Spoon.getInstance().getVfsFileChooserDialog(rootFile, initialFile);
                    fileChooserDialog.defaultInitialFile = defaultInitialFile;
                    selectedFile = fileChooserDialog.open(JobEntryCopyFilesDialog.this.shell, new String[]{"file"}, "file", true, null, new String[]{"*.*"}, FILETYPES, true, 2, false, false);
                    if (selectedFile != null) {
                        String url = selectedFile.getURL().toString();
                        JobEntryCopyFilesDialog.this.wFields.getActiveTableItem().setText(JobEntryCopyFilesDialog.this.wFields.getActiveTableColumn(), url);
                    }
                }
                catch (KettleFileException kettleFileException) {
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
            }
        };
    }

    private void refreshArgFromPrevious() {
        this.wlFields.setEnabled(!this.wPrevious.getSelection());
        this.wFields.setEnabled(!this.wPrevious.getSelection());
        this.deleteToolItem.setEnabled(!this.wPrevious.getSelection());
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.wName.setText(this.jobEntry.getName());
        }
        this.wCopyEmptyFolders.setSelection(this.jobEntry.copy_empty_folders);
        if (this.jobEntry.source_filefolder != null) {
            for (int i = 0; i < this.jobEntry.source_filefolder.length; ++i) {
                String clusterName;
                TableItem ti = this.wFields.table.getItem(i);
                if (this.jobEntry.source_filefolder[i] != null) {
                    String sourceUrl = this.jobEntry.source_filefolder[i];
                    clusterName = this.jobEntry.getConfigurationBy(sourceUrl);
                    ti.setText(1, STATIC_ENVIRONMENT);
                    if (clusterName != null) {
                        clusterName = clusterName.startsWith("LOCAL-SOURCE-FILE-") ? LOCAL_ENVIRONMENT : clusterName;
                        clusterName = clusterName.startsWith("STATIC-SOURCE-FILE-") ? STATIC_ENVIRONMENT : clusterName;
                        ti.setText(1, clusterName);
                        sourceUrl = clusterName.equals(LOCAL_ENVIRONMENT) || clusterName.equals(STATIC_ENVIRONMENT) ? sourceUrl : this.jobEntry.getUrlPath(sourceUrl);
                    }
                    ti.setText(2, sourceUrl);
                }
                if (this.jobEntry.wildcard[i] != null) {
                    ti.setText(3, this.jobEntry.wildcard[i]);
                }
                if (this.jobEntry.destination_filefolder[i] == null || Const.isEmpty((String)this.jobEntry.destination_filefolder[i])) continue;
                String destinationURL = this.jobEntry.destination_filefolder[i];
                clusterName = this.jobEntry.getConfigurationBy(destinationURL);
                ti.setText(4, STATIC_ENVIRONMENT);
                if (clusterName != null) {
                    clusterName = clusterName.startsWith("LOCAL-DEST-FILE-") ? LOCAL_ENVIRONMENT : clusterName;
                    clusterName = clusterName.startsWith("STATIC-DEST-FILE-") ? STATIC_ENVIRONMENT : clusterName;
                    ti.setText(4, clusterName);
                    destinationURL = clusterName.equals(LOCAL_ENVIRONMENT) || clusterName.equals(STATIC_ENVIRONMENT) ? destinationURL : this.jobEntry.getUrlPath(destinationURL);
                }
                ti.setText(5, destinationURL);
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        this.wPrevious.setSelection(this.jobEntry.arg_from_previous);
        this.wOverwriteFiles.setSelection(this.jobEntry.overwrite_files);
        this.wIncludeSubfolders.setSelection(this.jobEntry.include_subfolders);
        this.wRemoveSourceFiles.setSelection(this.jobEntry.remove_source_files);
        this.wDestinationIsAFile.setSelection(this.jobEntry.destination_is_a_file);
        this.wCreateDestinationFolder.setSelection(this.jobEntry.create_destination_folder);
        this.wAddFileToResult.setSelection(this.jobEntry.add_result_filesname);
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    protected void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setCopyEmptyFolders(this.wCopyEmptyFolders.getSelection());
        this.jobEntry.setoverwrite_files(this.wOverwriteFiles.getSelection());
        this.jobEntry.setIncludeSubfolders(this.wIncludeSubfolders.getSelection());
        this.jobEntry.setArgFromPrevious(this.wPrevious.getSelection());
        this.jobEntry.setRemoveSourceFiles(this.wRemoveSourceFiles.getSelection());
        this.jobEntry.setAddresultfilesname(this.wAddFileToResult.getSelection());
        this.jobEntry.setDestinationIsAFile(this.wDestinationIsAFile.getSelection());
        this.jobEntry.setCreateDestinationFolder(this.wCreateDestinationFolder.getSelection());
        int nritems = this.wFields.nrNonEmpty();
        int nr = 0;
        for (int i = 0; i < nritems; ++i) {
            String arg = this.wFields.getNonEmpty(i).getText(1);
            if (arg == null || arg.length() == 0) continue;
            ++nr;
        }
        HashMap sourceDestinationMappings = new HashMap();
        this.jobEntry.source_filefolder = new String[nr];
        this.jobEntry.destination_filefolder = new String[nr];
        this.jobEntry.wildcard = new String[nr];
        nr = 0;
        for (int i = 0; i < nritems; ++i) {
            String sourceNc = this.wFields.getNonEmpty(i).getText(1);
            sourceNc = sourceNc.equals(LOCAL_ENVIRONMENT) ? "LOCAL-SOURCE-FILE-" + i : sourceNc;
            sourceNc = sourceNc.equals(STATIC_ENVIRONMENT) ? "STATIC-SOURCE-FILE-" + i : sourceNc;
            String source = this.wFields.getNonEmpty(i).getText(2);
            String wild = this.wFields.getNonEmpty(i).getText(3);
            String destNc = this.wFields.getNonEmpty(i).getText(4);
            destNc = destNc.equals(LOCAL_ENVIRONMENT) ? "LOCAL-DEST-FILE-" + i : destNc;
            destNc = destNc.equals(STATIC_ENVIRONMENT) ? "STATIC-DEST-FILE-" + i : destNc;
            String dest = this.wFields.getNonEmpty(i).getText(5);
            if (Const.isEmpty((String)source) || this.jobEntry.source_filefolder.length <= 0) continue;
            this.jobEntry.source_filefolder[nr] = this.jobEntry.loadURL(source, sourceNc, this.getMetaStore(), sourceDestinationMappings);
            this.jobEntry.destination_filefolder[nr] = this.jobEntry.loadURL(dest, destNc, this.getMetaStore(), sourceDestinationMappings);
            this.jobEntry.wildcard[nr] = wild;
            ++nr;
        }
        this.jobEntry.setConfigurationMappings(sourceDestinationMappings);
        this.dispose();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    protected Image getImage() {
        return GUIResource.getInstance().getImage("ui/images/CPY.svg", 32, 32);
    }

    public boolean showFileButtons() {
        return true;
    }

    protected void setComboValues(ColumnInfo colInfo) {
        String[] values = new String[]{LOCAL_ENVIRONMENT, STATIC_ENVIRONMENT};
        colInfo.setComboValues(values);
    }
}

