/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.cluster.dialog;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.PasswordTextVar;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.DialogUtils;

public class SlaveServerDialog
extends Dialog {
    private static Class<?> PKG = SlaveServerDialog.class;
    private SlaveServer slaveServer;
    private Collection<SlaveServer> existingServers;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wServiceTab;
    private CTabItem wProxyTab;
    private Composite wServiceComp;
    private Composite wProxyComp;
    private FormData fdServiceComp;
    private FormData fdProxyComp;
    private Shell shell;
    private Text wName;
    private TextVar wHostname;
    private TextVar wPort;
    private TextVar wWebAppName;
    private TextVar wUsername;
    private TextVar wPassword;
    private Button wMaster;
    private Button wSSL;
    private TextVar wProxyHost;
    private TextVar wProxyPort;
    private TextVar wNonProxyHosts;
    private Button wOK;
    private Button wCancel;
    private ModifyListener lsMod;
    private PropsUI props;
    private int middle;
    private int margin;
    private SlaveServer originalServer;
    private boolean ok;

    public SlaveServerDialog(Shell par, SlaveServer slaveServer, Collection<SlaveServer> existingServers) {
        super(par, 0);
        this.slaveServer = (SlaveServer)slaveServer.clone();
        this.slaveServer.shareVariablesWith((VariableSpace)slaveServer);
        this.originalServer = slaveServer;
        this.existingServers = existingServers;
        this.props = PropsUI.getInstance();
        this.ok = false;
    }

    public SlaveServerDialog(Shell par, SlaveServer slaveServer) {
        this(par, slaveServer, Collections.emptyList());
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSlave());
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SlaveServerDialog.this.slaveServer.setChanged();
            }
        };
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.Shell.Title", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        Button[] buttons = new Button[]{this.wOK, this.wCancel};
        BaseStepDialog.positionBottomButtons((Composite)this.shell, buttons, this.margin, null);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.addServiceTab();
        this.addProxyTab();
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment(0, this.margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment((Control)this.wOK, -this.margin);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SlaveServerDialog.this.ok();
            }
        });
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SlaveServerDialog.this.cancel();
            }
        });
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SlaveServerDialog.this.ok();
            }
        };
        this.wUsername.addSelectionListener(selAdapter);
        this.wPassword.addSelectionListener(selAdapter);
        this.wHostname.addSelectionListener(selAdapter);
        this.wPort.addSelectionListener(selAdapter);
        this.wWebAppName.addSelectionListener(selAdapter);
        this.wProxyHost.addSelectionListener(selAdapter);
        this.wProxyPort.addSelectionListener(selAdapter);
        this.wNonProxyHosts.addSelectionListener(selAdapter);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SlaveServerDialog.this.cancel();
            }
        });
        this.wTabFolder.setSelection(0);
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.ok;
    }

    private void addServiceTab() {
        this.wServiceTab = new CTabItem(this.wTabFolder, 0);
        this.wServiceTab.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.USER_TAB_SERVICE", (String[])new String[0]));
        this.wServiceComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wServiceComp);
        FormLayout GenLayout = new FormLayout();
        GenLayout.marginWidth = 5;
        GenLayout.marginHeight = 5;
        this.wServiceComp.setLayout((Layout)GenLayout);
        Label wlName = new Label(this.wServiceComp, 131072);
        this.props.setLook((Control)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.ServerName.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, 0);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(this.middle, -this.margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(this.wServiceComp, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(this.lsMod);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment(0, 0);
        fdName.left = new FormAttachment(this.middle, 0);
        fdName.right = new FormAttachment(95, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlHostname = new Label(this.wServiceComp, 131072);
        this.props.setLook((Control)wlHostname);
        wlHostname.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.HostIP.Label", (String[])new String[0]));
        FormData fdlHostname = new FormData();
        fdlHostname.top = new FormAttachment((Control)this.wName, this.margin * 2);
        fdlHostname.left = new FormAttachment(0, 0);
        fdlHostname.right = new FormAttachment(this.middle, -this.margin);
        wlHostname.setLayoutData((Object)fdlHostname);
        this.wHostname = new TextVar((VariableSpace)this.slaveServer, this.wServiceComp, 18436);
        this.props.setLook((Control)this.wHostname);
        this.wHostname.addModifyListener(this.lsMod);
        FormData fdHostname = new FormData();
        fdHostname.top = new FormAttachment((Control)this.wName, this.margin * 2);
        fdHostname.left = new FormAttachment(this.middle, 0);
        fdHostname.right = new FormAttachment(95, 0);
        this.wHostname.setLayoutData(fdHostname);
        Label wlPort = new Label(this.wServiceComp, 131072);
        this.props.setLook((Control)wlPort);
        wlPort.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.Port.Label", (String[])new String[0]));
        FormData fdlPort = new FormData();
        fdlPort.top = new FormAttachment((Control)this.wHostname, this.margin);
        fdlPort.left = new FormAttachment(0, 0);
        fdlPort.right = new FormAttachment(this.middle, -this.margin);
        wlPort.setLayoutData((Object)fdlPort);
        this.wPort = new TextVar((VariableSpace)this.slaveServer, this.wServiceComp, 18436);
        this.props.setLook((Control)this.wPort);
        this.wPort.addModifyListener(this.lsMod);
        FormData fdPort = new FormData();
        fdPort.top = new FormAttachment((Control)this.wHostname, this.margin);
        fdPort.left = new FormAttachment(this.middle, 0);
        fdPort.right = new FormAttachment(95, 0);
        this.wPort.setLayoutData(fdPort);
        Label wlWebAppName = new Label(this.wServiceComp, 131072);
        wlWebAppName.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.WebAppName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlWebAppName);
        FormData fdlWebAppName = new FormData();
        fdlWebAppName.top = new FormAttachment((Control)this.wPort, this.margin);
        fdlWebAppName.left = new FormAttachment(0, 0);
        fdlWebAppName.right = new FormAttachment(this.middle, -this.margin);
        wlWebAppName.setLayoutData((Object)fdlWebAppName);
        this.wWebAppName = new TextVar((VariableSpace)this.slaveServer, this.wServiceComp, 18436);
        this.props.setLook((Control)this.wWebAppName);
        this.wWebAppName.addModifyListener(this.lsMod);
        FormData fdWebAppName = new FormData();
        fdWebAppName.top = new FormAttachment((Control)this.wPort, this.margin);
        fdWebAppName.left = new FormAttachment(this.middle, 0);
        fdWebAppName.right = new FormAttachment(95, 0);
        this.wWebAppName.setLayoutData(fdWebAppName);
        Label wlUsername = new Label(this.wServiceComp, 131072);
        wlUsername.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.UserName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUsername);
        FormData fdlUsername = new FormData();
        fdlUsername.top = new FormAttachment((Control)this.wWebAppName, this.margin);
        fdlUsername.left = new FormAttachment(0, 0);
        fdlUsername.right = new FormAttachment(this.middle, -this.margin);
        wlUsername.setLayoutData((Object)fdlUsername);
        this.wUsername = new TextVar((VariableSpace)this.slaveServer, this.wServiceComp, 18436);
        this.props.setLook((Control)this.wUsername);
        this.wUsername.addModifyListener(this.lsMod);
        FormData fdUsername = new FormData();
        fdUsername.top = new FormAttachment((Control)this.wWebAppName, this.margin);
        fdUsername.left = new FormAttachment(this.middle, 0);
        fdUsername.right = new FormAttachment(95, 0);
        this.wUsername.setLayoutData(fdUsername);
        Label wlPassword = new Label(this.wServiceComp, 131072);
        wlPassword.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.Password.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.top = new FormAttachment((Control)this.wUsername, this.margin);
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.right = new FormAttachment(this.middle, -this.margin);
        wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar((VariableSpace)this.slaveServer, this.wServiceComp, 18436);
        this.props.setLook((Control)this.wPassword);
        this.wPassword.addModifyListener(this.lsMod);
        FormData fdPassword = new FormData();
        fdPassword.top = new FormAttachment((Control)this.wUsername, this.margin);
        fdPassword.left = new FormAttachment(this.middle, 0);
        fdPassword.right = new FormAttachment(95, 0);
        this.wPassword.setLayoutData(fdPassword);
        Label wlMaster = new Label(this.wServiceComp, 131072);
        wlMaster.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.IsTheMaster.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaster);
        FormData fdlMaster = new FormData();
        fdlMaster.top = new FormAttachment((Control)this.wPassword, this.margin);
        fdlMaster.left = new FormAttachment(0, 0);
        fdlMaster.right = new FormAttachment(this.middle, -this.margin);
        wlMaster.setLayoutData((Object)fdlMaster);
        this.wMaster = new Button(this.wServiceComp, 32);
        this.props.setLook((Control)this.wMaster);
        FormData fdMaster = new FormData();
        fdMaster.top = new FormAttachment((Control)this.wPassword, this.margin);
        fdMaster.left = new FormAttachment(this.middle, 0);
        fdMaster.right = new FormAttachment(95, 0);
        this.wMaster.setLayoutData((Object)fdMaster);
        Button lastControl = this.wMaster;
        Label wlSSL = new Label(this.wServiceComp, 131072);
        wlSSL.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.UseSsl.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSSL);
        FormData fd = new FormData();
        fd.top = new FormAttachment((Control)lastControl, this.margin);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(this.middle, -this.margin);
        wlSSL.setLayoutData((Object)fd);
        wlSSL.setVisible(false);
        this.wSSL = new Button(this.wServiceComp, 32);
        this.props.setLook((Control)this.wSSL);
        FormData bfd = new FormData();
        bfd.top = new FormAttachment((Control)lastControl, this.margin);
        bfd.left = new FormAttachment(this.middle, 0);
        bfd.right = new FormAttachment(95, 0);
        this.wSSL.setLayoutData((Object)bfd);
        this.wSSL.setVisible(false);
        this.fdServiceComp = new FormData();
        this.fdServiceComp.left = new FormAttachment(0, 0);
        this.fdServiceComp.top = new FormAttachment(0, 0);
        this.fdServiceComp.right = new FormAttachment(100, 0);
        this.fdServiceComp.bottom = new FormAttachment(100, 0);
        this.wServiceComp.setLayoutData((Object)this.fdServiceComp);
        this.wServiceComp.layout();
        this.wServiceTab.setControl((Control)this.wServiceComp);
    }

    private void addProxyTab() {
        this.wProxyTab = new CTabItem(this.wTabFolder, 0);
        this.wProxyTab.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.USER_TAB_PROXY", (String[])new String[0]));
        FormLayout poolLayout = new FormLayout();
        poolLayout.marginWidth = 5;
        poolLayout.marginHeight = 5;
        this.wProxyComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wProxyComp);
        this.wProxyComp.setLayout((Layout)poolLayout);
        Label wlProxyHost = new Label(this.wProxyComp, 131072);
        this.props.setLook((Control)wlProxyHost);
        wlProxyHost.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.ProxyServerName.Label", (String[])new String[0]));
        FormData fdlProxyHost = new FormData();
        fdlProxyHost.top = new FormAttachment(0, 0);
        fdlProxyHost.left = new FormAttachment(0, 0);
        fdlProxyHost.right = new FormAttachment(this.middle, -this.margin);
        wlProxyHost.setLayoutData((Object)fdlProxyHost);
        this.wProxyHost = new TextVar((VariableSpace)this.slaveServer, this.wProxyComp, 18436);
        this.props.setLook((Control)this.wProxyHost);
        this.wProxyHost.addModifyListener(this.lsMod);
        FormData fdProxyHost = new FormData();
        fdProxyHost.top = new FormAttachment(0, 0);
        fdProxyHost.left = new FormAttachment(this.middle, 0);
        fdProxyHost.right = new FormAttachment(95, 0);
        this.wProxyHost.setLayoutData(fdProxyHost);
        Label wlProxyPort = new Label(this.wProxyComp, 131072);
        this.props.setLook((Control)wlProxyPort);
        wlProxyPort.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.ProxyServerPort.Label", (String[])new String[0]));
        FormData fdlProxyPort = new FormData();
        fdlProxyPort.top = new FormAttachment((Control)this.wProxyHost, this.margin);
        fdlProxyPort.left = new FormAttachment(0, 0);
        fdlProxyPort.right = new FormAttachment(this.middle, -this.margin);
        wlProxyPort.setLayoutData((Object)fdlProxyPort);
        this.wProxyPort = new TextVar((VariableSpace)this.slaveServer, this.wProxyComp, 18436);
        this.props.setLook((Control)this.wProxyPort);
        this.wProxyPort.addModifyListener(this.lsMod);
        FormData fdProxyPort = new FormData();
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, this.margin);
        fdProxyPort.left = new FormAttachment(this.middle, 0);
        fdProxyPort.right = new FormAttachment(95, 0);
        this.wProxyPort.setLayoutData(fdProxyPort);
        Label wlNonProxyHosts = new Label(this.wProxyComp, 131072);
        this.props.setLook((Control)wlNonProxyHosts);
        wlNonProxyHosts.setText(BaseMessages.getString(PKG, (String)"SlaveServerDialog.IgnoreProxyForHosts.Label", (String[])new String[0]));
        FormData fdlNonProxyHosts = new FormData();
        fdlNonProxyHosts.top = new FormAttachment((Control)this.wProxyPort, this.margin);
        fdlNonProxyHosts.left = new FormAttachment(0, 0);
        fdlNonProxyHosts.right = new FormAttachment(this.middle, -this.margin);
        wlNonProxyHosts.setLayoutData((Object)fdlNonProxyHosts);
        this.wNonProxyHosts = new TextVar((VariableSpace)this.slaveServer, this.wProxyComp, 18436);
        this.props.setLook((Control)this.wNonProxyHosts);
        this.wNonProxyHosts.addModifyListener(this.lsMod);
        FormData fdNonProxyHosts = new FormData();
        fdNonProxyHosts.top = new FormAttachment((Control)this.wProxyPort, this.margin);
        fdNonProxyHosts.left = new FormAttachment(this.middle, 0);
        fdNonProxyHosts.right = new FormAttachment(95, 0);
        this.wNonProxyHosts.setLayoutData(fdNonProxyHosts);
        this.fdProxyComp = new FormData();
        this.fdProxyComp.left = new FormAttachment(0, 0);
        this.fdProxyComp.top = new FormAttachment(0, 0);
        this.fdProxyComp.right = new FormAttachment(100, 0);
        this.fdProxyComp.bottom = new FormAttachment(100, 0);
        this.wProxyComp.setLayoutData((Object)this.fdProxyComp);
        this.wProxyComp.layout();
        this.wProxyTab.setControl((Control)this.wProxyComp);
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.slaveServer.getName(), (String)""));
        this.wHostname.setText(Const.NVL((String)this.slaveServer.getHostname(), (String)""));
        this.wPort.setText(Const.NVL((String)this.slaveServer.getPort(), (String)""));
        this.wWebAppName.setText(Const.NVL((String)this.slaveServer.getWebAppName(), (String)""));
        this.wUsername.setText(Const.NVL((String)this.slaveServer.getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)this.slaveServer.getPassword(), (String)""));
        this.wProxyHost.setText(Const.NVL((String)this.slaveServer.getProxyHostname(), (String)""));
        this.wProxyPort.setText(Const.NVL((String)this.slaveServer.getProxyPort(), (String)""));
        this.wNonProxyHosts.setText(Const.NVL((String)this.slaveServer.getNonProxyHosts(), (String)""));
        this.wMaster.setSelection(this.slaveServer.isMaster());
        this.wSSL.setSelection(this.slaveServer.isSslMode());
        this.wName.setFocus();
    }

    private void cancel() {
        this.originalServer = null;
        this.dispose();
    }

    public void ok() {
        this.getInfo();
        if (!this.slaveServer.getName().equals(this.originalServer.getName()) && DialogUtils.objectWithTheSameNameExists((SharedObjectInterface)this.slaveServer, this.existingServers)) {
            String title = BaseMessages.getString(PKG, (String)"SlaveServerDialog.SlaveServerNameExists.Title", (String[])new String[0]);
            String message = BaseMessages.getString(PKG, (String)"SlaveServerDialog.SlaveServerNameExists", (String[])new String[]{this.slaveServer.getName()});
            String okButton = BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]);
            MessageDialog dialog = new MessageDialog(this.shell, title, null, message, 1, new String[]{okButton}, 0);
            dialog.open();
            return;
        }
        this.originalServer.setName(this.slaveServer.getName());
        this.originalServer.setHostname(this.slaveServer.getHostname());
        this.originalServer.setPort(this.slaveServer.getPort());
        this.originalServer.setWebAppName(this.slaveServer.getWebAppName());
        this.originalServer.setUsername(this.slaveServer.getUsername());
        this.originalServer.setPassword(this.slaveServer.getPassword());
        this.originalServer.setProxyHostname(this.slaveServer.getProxyHostname());
        this.originalServer.setProxyPort(this.slaveServer.getProxyPort());
        this.originalServer.setNonProxyHosts(this.slaveServer.getNonProxyHosts());
        this.originalServer.setMaster(this.slaveServer.isMaster());
        this.originalServer.setSslMode(this.slaveServer.isSslMode());
        this.originalServer.setChanged();
        this.ok = true;
        this.dispose();
    }

    private void getInfo() {
        this.slaveServer.setName(this.wName.getText());
        this.slaveServer.setHostname(this.wHostname.getText());
        this.slaveServer.setPort(this.wPort.getText());
        this.slaveServer.setWebAppName(this.wWebAppName.getText());
        this.slaveServer.setUsername(this.wUsername.getText());
        this.slaveServer.setPassword(this.wPassword.getText());
        this.slaveServer.setProxyHostname(this.wProxyHost.getText());
        this.slaveServer.setProxyPort(this.wProxyPort.getText());
        this.slaveServer.setNonProxyHosts(this.wNonProxyHosts.getText());
        this.slaveServer.setMaster(this.wMaster.getSelection());
        this.slaveServer.setSslMode(this.wSSL.getSelection());
    }

    public void test() {
        try {
            this.getInfo();
            String xml = "<sample/>";
            String reply = this.slaveServer.sendXML(xml, "/kettle/registerTrans");
            String message = BaseMessages.getString(PKG, (String)"SlaveServer.Replay.Info1", (String[])new String[0]) + this.slaveServer.constructUrl("/kettle/registerTrans") + Const.CR + BaseMessages.getString(PKG, (String)"SlaveServer.Replay.Info2", (String[])new String[0]) + Const.CR + Const.CR;
            message = message + xml;
            message = message + Const.CR + Const.CR;
            message = message + "Reply was:" + Const.CR + Const.CR;
            message = message + reply + Const.CR;
            EnterTextDialog dialog = new EnterTextDialog(this.shell, "XML", BaseMessages.getString(PKG, (String)"SlaveServer.RetournedXMLInfo", (String[])new String[0]), message);
            dialog.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SlaveServer.ExceptionError", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SlaveServer.ExceptionUnableGetReplay.Error1", (String[])new String[0]) + this.slaveServer.getHostname() + BaseMessages.getString(PKG, (String)"SlaveServer.ExceptionUnableGetReplay.Error2", (String[])new String[0]), e);
        }
    }
}

