/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.dialect;

import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.dialect.Hive2DatabaseDialect;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.util.Const;

public class Hive2SimbaDatabaseDialect
extends Hive2DatabaseDialect {
    private static final long serialVersionUID = -8456961348836455937L;
    protected static final String JDBC_URL_TEMPLATE = "jdbc:hive2://%s:%s/%s;AuthMech=%d%s";
    private static final IDatabaseType DBTYPE = new DatabaseType("Hadoop Hive 2 (Simba)", "HIVE2SIMBA", DatabaseAccessType.getList(DatabaseAccessType.NATIVE, DatabaseAccessType.JNDI, DatabaseAccessType.ODBC), 10000, "http://www.simba.com/connectors/apache-hadoop-hive-driver");

    @Override
    public IDatabaseType getDatabaseType() {
        return DBTYPE;
    }

    @Override
    public String getNativeDriver() {
        return "org.apache.hive.jdbc.HiveSimbaDriver";
    }

    @Override
    public String getURL(IDatabaseConnection databaseConnection) throws DatabaseDialectException {
        switch (databaseConnection.getAccessType()) {
            case ODBC: {
                return String.format("jdbc:odbc:%s", databaseConnection.getDatabaseName());
            }
            case JNDI: {
                return "Url is configured through JNDI";
            }
        }
        Integer authMethod = 0;
        StringBuilder additional = new StringBuilder();
        String userName = databaseConnection.getUsername();
        String password = databaseConnection.getPassword();
        String krbFQDN = this.getProperty("KrbHostFQDN", databaseConnection);
        String extraKrbFQDN = this.getExtraProperty("KrbHostFQDN", databaseConnection);
        String krbPrincipal = this.getProperty("KrbServiceName", databaseConnection);
        String extraKrbPrincipal = this.getExtraProperty("KrbServiceName", databaseConnection);
        if (!(Const.isEmpty(krbPrincipal) && Const.isEmpty(extraKrbPrincipal) || Const.isEmpty(krbFQDN) && Const.isEmpty(extraKrbFQDN))) {
            authMethod = 1;
        } else if (!Const.isEmpty(userName)) {
            additional.append(";UID=");
            additional.append(userName);
            if (!Const.isEmpty(password)) {
                authMethod = 3;
                additional.append(";PWD=");
                additional.append(password);
            } else {
                authMethod = 2;
            }
        }
        return String.format(this.getJdbcUrlTemplate(), databaseConnection.getHostname(), databaseConnection.getDatabasePort(), databaseConnection.getDatabaseName(), authMethod, additional);
    }

    protected String getJdbcUrlTemplate() {
        return JDBC_URL_TEMPLATE;
    }

    private String getExtraProperty(String key, IDatabaseConnection databaseConnection) {
        return databaseConnection.getAttributes().get("EXTRA_OPTION_" + this.getDatabaseType().getShortName() + "." + key);
    }

    private String getProperty(String key, IDatabaseConnection databaseConnection) {
        return databaseConnection.getExtraOptions().get(this.getDatabaseType().getShortName() + "." + key);
    }

    @Override
    public String getNativeJdbcPre() {
        return "jdbc:hive2://";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"HiveJDBC41.jar"};
    }
}

