/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.openerp.objectdelete;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.steps.openerp.objectdelete.OpenERPObjectDeleteData;
import org.pentaho.di.trans.steps.openerp.objectdelete.OpenERPObjectDeleteMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class OpenERPObjectDeleteDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = OpenERPObjectDeleteMeta.class;
    private final OpenERPObjectDeleteMeta meta;
    private Label labelStepName;
    private Text textStepName;
    private CCombo addConnectionLine;
    private Label labelModelName;
    private CCombo comboModelName;
    private Label labelCommitBatchSize;
    private Text textCommitBatchSize;
    private Label labelIDFieldName;
    private CCombo comboIDFieldName;
    private Button buttonOk;
    private Button buttonCancel;

    public OpenERPObjectDeleteDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.meta = (OpenERPObjectDeleteMeta)((Object)in);
    }

    public String open() {
        Display display = this.getParent().getDisplay();
        this.shell = new Shell(this.getParent(), 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.labelStepName = new Label((Composite)this.shell, 131072);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.labelStepName.setLayoutData((Object)fd);
        this.textStepName = new Text((Composite)this.shell, 2048);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, margin);
        this.textStepName.setLayoutData((Object)fd);
        this.addConnectionLine = this.addConnectionLine((Composite)this.shell, (Control)this.textStepName, 35, margin);
        this.labelModelName = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.labelModelName.setLayoutData((Object)fd);
        this.comboModelName = new CCombo((Composite)this.shell, 2048);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.comboModelName.setLayoutData((Object)fd);
        this.labelCommitBatchSize = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.comboModelName, margin);
        this.labelCommitBatchSize.setLayoutData((Object)fd);
        this.textCommitBatchSize = new Text((Composite)this.shell, 2048);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.comboModelName, margin);
        this.textCommitBatchSize.setLayoutData((Object)fd);
        this.labelIDFieldName = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.textCommitBatchSize, margin);
        this.labelIDFieldName.setLayoutData((Object)fd);
        this.comboIDFieldName = new CCombo((Composite)this.shell, 2048);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.textCommitBatchSize, margin);
        this.comboIDFieldName.setLayoutData((Object)fd);
        this.buttonOk = new Button((Composite)this.shell, 0x1000000);
        this.buttonCancel = new Button((Composite)this.shell, 0x1000000);
        this.buttonOk.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.buttonCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.setButtonPositions(new Button[]{this.buttonOk, this.buttonCancel}, margin, null);
        this.addConnectionLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenERPObjectDeleteDialog.this.setModelComboOptions();
            }
        });
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenERPObjectDeleteDialog.this.cancel();
            }
        });
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenERPObjectDeleteDialog.this.ok();
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                OpenERPObjectDeleteDialog.this.setModelComboOptions();
                OpenERPObjectDeleteDialog.this.setIDComboOptions();
            }
        };
        display.asyncExec(runnable);
        this.fillLocalizationData();
        this.fillStoredData();
        this.props.setLook((Control)this.labelStepName);
        this.props.setLook((Control)this.textStepName);
        this.props.setLook((Control)this.addConnectionLine);
        this.props.setLook((Control)this.labelModelName);
        this.props.setLook((Control)this.comboModelName);
        this.props.setLook((Control)this.labelCommitBatchSize);
        this.props.setLook((Control)this.textCommitBatchSize);
        this.props.setLook((Control)this.labelIDFieldName);
        this.props.setLook((Control)this.comboIDFieldName);
        this.meta.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void fillLocalizationData() {
        this.shell.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectDeleteDialog.Title", (String[])new String[0]));
        this.labelStepName.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectDeleteDialog.StepName", (String[])new String[0]));
        this.labelModelName.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectDeleteDialog.ModelName", (String[])new String[0]));
        this.labelCommitBatchSize.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectDeleteDialog.CommitBatchSize", (String[])new String[0]));
        this.labelIDFieldName.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectDeleteDialog.IDFieldName", (String[])new String[0]));
    }

    private void setModelComboOptions() {
        String[] objectList = this.getModelList();
        if (objectList == null) {
            return;
        }
        for (String objectName : objectList) {
            if (this.comboModelName.indexOf(objectName) != -1) continue;
            this.comboModelName.add(objectName);
        }
    }

    private String[] getModelList() {
        DatabaseMeta dbMeta;
        String[] objectList = null;
        if (this.addConnectionLine.getText() != null && (dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText())) != null) {
            OpenERPObjectDeleteData data = null;
            try {
                data = new OpenERPObjectDeleteData(dbMeta);
                data.helper.StartSession();
                objectList = data.helper.getModelList();
            }
            catch (Exception e) {
                return null;
            }
        }
        return objectList;
    }

    private String[] getSteamFieldsNames(boolean showError) {
        String[] fields = null;
        try {
            RowMetaInterface row = this.transMeta.getPrevStepFields(this.stepMeta);
            fields = new String[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                fields[i] = row.getValueMeta(i).getName();
            }
        }
        catch (KettleStepException e) {
            if (showError) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OpenERPObjectOutputDialog.UnableToFindStreamFieldsTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OpenERPObjectOutputDialog.UnableToFindStreamFieldsMessage", (String[])new String[0]), (Exception)((Object)e));
            }
            return null;
        }
        return fields;
    }

    private void setIDComboOptions() {
        String[] steamFields = this.getSteamFieldsNames(false);
        if (steamFields != null) {
            for (String streamField : steamFields) {
                this.comboIDFieldName.add(streamField);
            }
        }
    }

    private void fillStoredData() {
        int index;
        if (this.stepname != null) {
            this.textStepName.setText(this.stepname);
        }
        if ((index = this.addConnectionLine.indexOf(this.meta.getDatabaseMeta() != null ? this.meta.getDatabaseMeta().getName() : "")) >= 0) {
            this.addConnectionLine.select(index);
        }
        if (this.meta.getModelName() != null) {
            this.comboModelName.add(this.meta.getModelName());
            this.comboModelName.select(0);
        }
        this.textCommitBatchSize.setText(String.valueOf(this.meta.getCommitBatchSize()));
        this.comboIDFieldName.setText(this.meta.getIdFieldName());
    }

    private void cancel() {
        this.stepname = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (this.SaveToMeta(this.meta)) {
            this.dispose();
        }
    }

    private boolean SaveToMeta(OpenERPObjectDeleteMeta targetMeta) {
        this.stepname = this.textStepName.getText();
        DatabaseMeta dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText());
        if (dbMeta != null) {
            try {
                new OpenERPObjectDeleteData(dbMeta);
            }
            catch (KettleException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OpenERPObjectDeleteDialog.ConnectionTypeErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OpenERPObjectDeleteDialog.ConnectionTypeErrorString", (String[])new String[0]), (Exception)((Object)e));
                return false;
            }
        }
        int commitBatchSize = 0;
        try {
            commitBatchSize = Integer.parseInt(this.textCommitBatchSize.getText());
        }
        catch (NumberFormatException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OpenERPObjectDeleteDialog.ParseErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OpenERPObjectDeleteDialog.ParseErrorString", (String[])new String[]{this.textCommitBatchSize.getText()}), (Exception)e);
            return false;
        }
        targetMeta.setIdFieldName(this.comboIDFieldName.getText());
        targetMeta.setDatabaseMeta(this.transMeta.findDatabase(this.addConnectionLine.getText()));
        targetMeta.setModelName(this.comboModelName.getText());
        targetMeta.setCommitBatchSize(commitBatchSize);
        targetMeta.setChanged(true);
        return true;
    }
}

