/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.openerp.objectinput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.openerp.core.FieldMapping;
import org.pentaho.di.openerp.core.OpenERPHelper;
import org.pentaho.di.openerp.core.ReadFilter;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.openerp.objectinput.OpenERPObjectInput;
import org.pentaho.di.trans.steps.openerp.objectinput.OpenERPObjectInputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="OpenERPObjectInput", image="OpenERPObjectInput.svg", i18nPackageName="org.pentaho.di.trans.steps.openerp.objectinput", name="OpenERPObjectInput.TransName", description="OpenERPObjectInput.TransDescription", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.OpenERP")
public class OpenERPObjectInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta;
    private String modelName;
    private int readBatchSize = 1000;
    private ArrayList<ReadFilter> filterList = new ArrayList();
    private ArrayList<FieldMapping> mappings = new ArrayList();

    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.databaseMeta == null) {
            throw new KettleStepException("There is no OpenERP database server connection defined");
        }
        OpenERPHelper helper = new OpenERPHelper(this.databaseMeta);
        try {
            helper.StartSession();
            RowMetaInterface rowMeta = this.getRowMeta();
            row.addRowMeta(rowMeta);
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    public RowMetaInterface getRowMeta() throws KettlePluginException {
        RowMeta rowMeta = new RowMeta();
        for (FieldMapping map : this.getMappings()) {
            rowMeta.addValueMeta(ValueMetaFactory.createValueMeta((String)map.target_field, (int)map.target_field_type));
        }
        return rowMeta;
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new OpenERPObjectInput(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        try {
            return new OpenERPObjectInputData(this.databaseMeta);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"modelName", (String)this.modelName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"readBatchSize", (int)this.readBatchSize));
        retval.append("    <mappings>").append(Const.CR);
        for (FieldMapping map : this.getMappings()) {
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"source_model", (String)map.source_model));
            retval.append("        ").append(XMLHandler.addTagValue((String)"source_field", (String)map.source_field));
            retval.append("        ").append(XMLHandler.addTagValue((String)"source_index", (int)map.source_index));
            retval.append("        ").append(XMLHandler.addTagValue((String)"target_model", (String)map.target_model));
            retval.append("        ").append(XMLHandler.addTagValue((String)"target_field", (String)map.target_field));
            retval.append("        ").append(XMLHandler.addTagValue((String)"target_field_label", (String)map.target_field_label));
            retval.append("        ").append(XMLHandler.addTagValue((String)"target_field_type", (int)map.target_field_type));
            retval.append("      </mapping>").append(Const.CR);
        }
        retval.append("    </mappings>").append(Const.CR);
        retval.append("    <filters>").append(Const.CR);
        for (ReadFilter filter : this.getFilterList()) {
            retval.append("      <filter>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"operator", (String)filter.getOperator()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_name", (String)filter.getFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"comparator", (String)filter.getComparator()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"value", (String)filter.getValue()));
            retval.append("      </filter>").append(Const.CR);
        }
        retval.append("    </filters>").append(Const.CR);
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId idStep, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(idStep, "connection", databases);
            this.modelName = rep.getStepAttributeString(idStep, "modelName");
            this.readBatchSize = Integer.parseInt(rep.getStepAttributeString(idStep, "readBatchSize"));
            int nrMappings = rep.countNrStepAttributes(idStep, "source_model");
            for (int i = 0; i < nrMappings; ++i) {
                FieldMapping map = new FieldMapping();
                map.source_model = rep.getStepAttributeString(idStep, i, "source_model");
                map.source_field = rep.getStepAttributeString(idStep, i, "source_field");
                map.source_index = Integer.valueOf(rep.getStepAttributeString(idStep, i, "source_index"));
                map.target_model = rep.getStepAttributeString(idStep, i, "target_model");
                map.target_field = rep.getStepAttributeString(idStep, i, "target_field");
                map.target_field_label = rep.getStepAttributeString(idStep, i, "target_field_label");
                map.target_field_type = Integer.valueOf(rep.getStepAttributeString(idStep, i, "target_field_type"));
                this.getMappings().add(map);
            }
            int nrFilters = rep.countNrStepAttributes(idStep, "field_name");
            for (int i = 0; i < nrFilters; ++i) {
                ReadFilter filter = new ReadFilter();
                filter.setOperator(rep.getStepAttributeString(idStep, i, "operator"));
                filter.setFieldName(rep.getStepAttributeString(idStep, i, "field_name"));
                filter.setComparator(rep.getStepAttributeString(idStep, i, "comparator"));
                filter.setValue(rep.getStepAttributeString(idStep, i, "value"));
                this.getFilterList().add(filter);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idTransformation, ObjectId idStep) throws KettleException {
        try {
            int i;
            rep.saveDatabaseMetaStepAttribute(idTransformation, idStep, "connection", this.databaseMeta);
            rep.saveStepAttribute(idTransformation, idStep, "modelName", this.modelName);
            rep.saveStepAttribute(idTransformation, idStep, "readBatchSize", (long)this.readBatchSize);
            for (i = 0; i < this.getMappings().size(); ++i) {
                FieldMapping map = this.getMappings().get(i);
                rep.saveStepAttribute(idTransformation, idStep, i, "source_model", map.source_model);
                rep.saveStepAttribute(idTransformation, idStep, i, "source_field", map.source_field);
                rep.saveStepAttribute(idTransformation, idStep, i, "source_index", (long)map.source_index);
                rep.saveStepAttribute(idTransformation, idStep, i, "target_model", map.target_model);
                rep.saveStepAttribute(idTransformation, idStep, i, "target_field", map.target_field);
                rep.saveStepAttribute(idTransformation, idStep, i, "target_field_label", map.target_field_label);
                rep.saveStepAttribute(idTransformation, idStep, i, "target_field_type", (long)map.target_field_type);
            }
            for (i = 0; i < this.getFilterList().size(); ++i) {
                ReadFilter filter = this.getFilterList().get(i);
                rep.saveStepAttribute(idTransformation, idStep, i, "operator", filter.getOperator());
                rep.saveStepAttribute(idTransformation, idStep, i, "field_name", filter.getFieldName());
                rep.saveStepAttribute(idTransformation, idStep, i, "comparator", filter.getComparator());
                rep.saveStepAttribute(idTransformation, idStep, i, "value", filter.getValue());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for idStep=" + idStep, (Throwable)e);
        }
    }

    public void setDefault() {
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"connection"));
            this.modelName = XMLHandler.getTagValue((Node)stepnode, (String)"modelName");
            this.readBatchSize = Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"readBatchSize"));
            this.setMappings(new ArrayList<FieldMapping>());
            Node mappings = XMLHandler.getSubNode((Node)stepnode, (String)"mappings");
            int nrLevels = XMLHandler.countNodes((Node)mappings, (String)"mapping");
            for (int i = 0; i < nrLevels; ++i) {
                FieldMapping map = new FieldMapping();
                Node fnode = XMLHandler.getSubNodeByNr((Node)mappings, (String)"mapping", (int)i);
                map.source_model = XMLHandler.getTagValue((Node)fnode, (String)"source_model");
                map.source_field = XMLHandler.getTagValue((Node)fnode, (String)"source_field");
                map.source_index = Integer.parseInt(XMLHandler.getTagValue((Node)fnode, (String)"source_index"));
                map.target_model = XMLHandler.getTagValue((Node)fnode, (String)"target_model");
                map.target_field = XMLHandler.getTagValue((Node)fnode, (String)"target_field");
                map.target_field_label = XMLHandler.getTagValue((Node)fnode, (String)"target_field_label");
                map.target_field_type = Integer.parseInt(XMLHandler.getTagValue((Node)fnode, (String)"target_field_type"));
                this.getMappings().add(map);
            }
            Node filters = XMLHandler.getSubNode((Node)stepnode, (String)"filters");
            int nrFilters = XMLHandler.countNodes((Node)filters, (String)"filter");
            for (int i = 0; i < nrFilters; ++i) {
                ReadFilter filter = new ReadFilter();
                Node fnode = XMLHandler.getSubNodeByNr((Node)filters, (String)"filter", (int)i);
                filter.setOperator(XMLHandler.getTagValue((Node)fnode, (String)"operator"));
                filter.setFieldName(XMLHandler.getTagValue((Node)fnode, (String)"field_name"));
                filter.setComparator(XMLHandler.getTagValue((Node)fnode, (String)"comparator"));
                filter.setValue(XMLHandler.getTagValue((Node)fnode, (String)"value"));
                this.getFilterList().add(filter);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public final void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public final DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setReadBatchSize(int readBatchSize) {
        this.readBatchSize = readBatchSize;
    }

    public int getReadBatchSize() {
        return this.readBatchSize;
    }

    public void setMappings(ArrayList<FieldMapping> mappings) {
        this.mappings = mappings;
    }

    public ArrayList<FieldMapping> getMappings() {
        return this.mappings;
    }

    public void setFilterList(ArrayList<ReadFilter> filterList) {
        this.filterList = filterList;
    }

    public ArrayList<ReadFilter> getFilterList() {
        return this.filterList;
    }
}

