/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class WorkflowJobsCountNotForPurgeFromCoordParentIdJPAExecutor
implements JPAExecutor<Long> {
    private static final long DAY_IN_MS = 86400000L;
    private long olderThanDays;
    private String parentId;

    public WorkflowJobsCountNotForPurgeFromCoordParentIdJPAExecutor(long olderThanDays, String parentId) {
        this.olderThanDays = olderThanDays;
        this.parentId = parentId;
    }

    @Override
    public String getName() {
        return "WorkflowJobsCountNotForPurgeFromCoordParentIdJPAExecutor";
    }

    @Override
    public Long execute(EntityManager em) throws JPAExecutorException {
        Long count = 0L;
        try {
            Timestamp maxEndTime = new Timestamp(System.currentTimeMillis() - this.olderThanDays * 86400000L);
            Query jobQ = em.createNamedQuery("GET_WORKFLOWS_COUNT_WITH_COORD_PARENT_ID_NOT_READY_FOR_PURGE");
            jobQ.setParameter("parentId", (Object)(this.parentId + "%"));
            jobQ.setParameter("endTime", (Object)maxEndTime);
            count = (Long)jobQ.getSingleResult();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return count;
    }
}

