/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.validation;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.CheckStepsExtension;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.serialization.DataServiceMetaStoreUtil;
import org.pentaho.di.trans.dataservice.validation.StepValidation;
import org.pentaho.di.trans.step.StepMeta;

@ExtensionPoint(id="StepValidationExtensionPointPlugin", extensionPointId="AfterCheckStep", description="Perform DataService specific step validation.")
public class StepValidationExtensionPointPlugin
implements ExtensionPointInterface {
    private final DataServiceMetaStoreUtil metaStoreUtil;
    private List<StepValidation> stepValidations = new ArrayList<StepValidation>();

    public StepValidationExtensionPointPlugin(DataServiceContext context) {
        this.metaStoreUtil = context.getMetaStoreUtil();
    }

    public void callExtensionPoint(LogChannelInterface log, Object o) throws KettleException {
        if (!this.validInputs(o, log)) {
            return;
        }
        CheckStepsExtension checkStepExtension = (CheckStepsExtension)o;
        TransMeta transMeta = checkStepExtension.getTransMeta();
        for (StepValidation stepValidation : this.getStepValidations()) {
            StepMeta stepMeta;
            if (!stepValidation.supportsStep(stepMeta = checkStepExtension.getStepMetas()[0], log)) continue;
            DataServiceMeta dataServiceMeta = this.metaStoreUtil.getDataServiceByStepName(transMeta, stepMeta.getName());
            if (dataServiceMeta == null) {
                return;
            }
            stepValidation.checkStep(checkStepExtension, dataServiceMeta, log);
        }
    }

    private boolean validInputs(Object o, LogChannelInterface log) {
        if (!(o instanceof CheckStepsExtension)) {
            log.logError("StepValidationExtensionPointPlugin invoked with wrong object type, should be CheckStepsExtension");
            return false;
        }
        CheckStepsExtension checkStepExtension = (CheckStepsExtension)o;
        if (checkStepExtension.getStepMetas().length != 1) {
            log.logError("StepValidationExtensionPointPlugin invoked with wrong number of StepMeta objects.  Should be 1 step.");
            return false;
        }
        return true;
    }

    public List<StepValidation> getStepValidations() {
        return this.stepValidations;
    }

    public void setStepValidations(List<StepValidation> stepValidations) {
        this.stepValidations = stepValidations;
    }
}

