/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.paramgen;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;

class DatabaseWrapper
extends Database {
    Map<String, RuntimePushDown> pushDownMap = new HashMap<String, RuntimePushDown>();
    private final LogChannelInterface log;

    public DatabaseWrapper(Database db) {
        super((LoggingObjectInterface)db, db.getDatabaseMeta());
        this.log = new LogChannel((Object)this, (LoggingObjectInterface)db);
        this.shareVariablesWith((VariableSpace)db);
        this.setConnectionGroup(db.getConnectionGroup());
        this.setPartitionId(db.getPartitionId());
    }

    public synchronized void connect() throws KettleDatabaseException {
        super.connect(this.getConnectionGroup(), this.getPartitionId());
    }

    public ResultSet openQuery(String sql, RowMetaInterface paramsMeta, Object[] data, int fetch_mode, boolean lazyConversion) throws KettleDatabaseException {
        ArrayList<Object> params = data == null ? new ArrayList<Object>() : new ArrayList<Object>(Arrays.asList(data));
        paramsMeta = paramsMeta == null ? new RowMeta() : paramsMeta;
        sql = this.injectRuntime(this.pushDownMap, sql, paramsMeta, params);
        if (params.size() > 0 && this.log.isDetailed()) {
            this.log.logDetailed(this.parameterizedQueryToString(sql, params));
        }
        return super.openQuery(sql, paramsMeta, params.toArray(), fetch_mode, lazyConversion);
    }

    protected String parameterizedQueryToString(String sql, List<Object> params) {
        return String.format("Parameterized SQL:  %s   %s", sql, this.paramsToString(params));
    }

    private String paramsToString(List<Object> params) {
        StringBuilder paramStr = new StringBuilder();
        paramStr.append("{");
        for (int i = 1; i <= params.size(); ++i) {
            paramStr.append(i).append(": ").append(params.get(i - 1));
            if (i >= params.size()) continue;
            paramStr.append(", ");
        }
        return paramStr.append("}").toString();
    }

    protected String injectRuntime(Map<String, RuntimePushDown> runtimeMap, String sql, RowMetaInterface paramsMeta, List<Object> params) {
        if (!params.isEmpty()) {
            return sql;
        }
        StringBuilder sqlBuilder = new StringBuilder(sql);
        TreeMap<Integer, RuntimePushDown> sortedMap = new TreeMap<Integer, RuntimePushDown>();
        for (String fragmentId : runtimeMap.keySet()) {
            int pos = sqlBuilder.indexOf(fragmentId);
            if (pos < 0) continue;
            sortedMap.put(pos, runtimeMap.get(fragmentId));
        }
        for (RuntimePushDown runtime : sortedMap.values()) {
            int start = sqlBuilder.indexOf(runtime.fragmentId);
            int end = start + runtime.fragmentId.length();
            sqlBuilder.replace(start, end, runtime.sqlFragment);
            paramsMeta.addRowMeta((RowMetaInterface)runtime.paramsMeta);
            params.addAll(runtime.params);
        }
        return sqlBuilder.toString();
    }

    public String createRuntimePushDown(String sqlFragment, RowMeta paramsMeta, List<Object> params, String defaultValue) {
        String fragmentId = "/*" + UUID.randomUUID().toString() + "*/" + defaultValue;
        RuntimePushDown runtimePushDown = new RuntimePushDown(fragmentId, sqlFragment, paramsMeta, params);
        this.pushDownMap.put(fragmentId, runtimePushDown);
        return fragmentId;
    }

    static class RuntimePushDown {
        final String fragmentId;
        final String sqlFragment;
        final RowMeta paramsMeta;
        final List<Object> params;

        public RuntimePushDown(String fragmentId, String sqlFragment, RowMeta paramsMeta, List<Object> params) {
            this.fragmentId = fragmentId;
            this.sqlFragment = sqlFragment;
            this.paramsMeta = paramsMeta;
            this.params = params;
        }
    }
}

