/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.cache;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.List;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.core.sql.SQLCondition;
import org.pentaho.di.core.sql.SQLField;
import org.pentaho.di.core.sql.SQLFields;
import org.pentaho.di.core.sql.SQLLimit;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;

class CachedService
implements Serializable {
    private final ImmutableList<RowMetaAndData> rowMetaAndData;
    private final Optional<Integer> ranking;

    private CachedService(List<RowMetaAndData> rowMetaAndData, Optional<Integer> ranking) {
        this.rowMetaAndData = ImmutableList.copyOf(rowMetaAndData);
        this.ranking = ranking;
    }

    public static CachedService complete(List<RowMetaAndData> rowMetaAndData) {
        return new CachedService(rowMetaAndData, (Optional<Integer>)Optional.absent());
    }

    public static CachedService partial(List<RowMetaAndData> rowMetaAndData, DataServiceExecutor executor) {
        return new CachedService(rowMetaAndData, (Optional<Integer>)Optional.of((Object)CachedService.calculateRank(executor)));
    }

    public List<RowMetaAndData> getRowMetaAndData() {
        return this.rowMetaAndData;
    }

    public Optional<Integer> getRanking() {
        return this.ranking;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("rowMetaAndData.length", this.rowMetaAndData.size()).add("ranking", this.ranking).toString();
    }

    public boolean isComplete() {
        return !this.ranking.isPresent();
    }

    private static int calculateRank(DataServiceExecutor executor) {
        SQLLimit limitValues = executor.getSql().getLimitValues();
        if (limitValues != null) {
            return limitValues.getLimit() + limitValues.getOffset();
        }
        if (executor.getRowLimit() > 0) {
            return executor.getRowLimit();
        }
        return Integer.MAX_VALUE;
    }

    public boolean answersQuery(DataServiceExecutor executor) {
        SQL sql = executor.getSql();
        if (this.isComplete()) {
            return true;
        }
        SQLFields selectFields = sql.getSelectFields();
        SQLFields groupFields = sql.getGroupFields();
        if (selectFields.hasAggregates() || selectFields.isDistinct() || !groupFields.getFields().isEmpty()) {
            return false;
        }
        return (Integer)this.ranking.get() >= CachedService.calculateRank(executor);
    }

    public static final class CacheKey
    implements Serializable {
        private final int transMetaVersionId;
        private final ImmutableMap<String, String> parameters;
        private final Optional<String> whereClause;
        private final ImmutableList<String> orderByFields;

        private CacheKey(int transMetaVersionId, ImmutableMap<String, String> parameters, Optional<String> whereClause, ImmutableList<String> orderByFields) {
            this.transMetaVersionId = transMetaVersionId;
            this.parameters = parameters;
            this.whereClause = whereClause;
            this.orderByFields = orderByFields;
        }

        public static CacheKey create(DataServiceExecutor executor) {
            int version;
            SQL sql = executor.getSql();
            try {
                version = executor.getService().getServiceTrans().getXML().hashCode();
            }
            catch (KettleException e) {
                throw new IllegalStateException("Unable to determine version of transMeta", e);
            }
            Optional whereClause = Optional.fromNullable((Object)sql.getWhereCondition()).transform((Function)new Function<SQLCondition, String>(){

                public String apply(SQLCondition input) {
                    Condition clone = (Condition)input.getCondition().clone();
                    clone.simplify();
                    return clone.toString();
                }
            });
            ImmutableList orderByFields = FluentIterable.from((Iterable)Optional.fromNullable((Object)sql.getOrderFields()).asSet()).transformAndConcat((Function)new Function<SQLFields, Iterable<SQLField>>(){

                public Iterable<SQLField> apply(SQLFields input) {
                    return input.getFields();
                }
            }).transform((Function)new Function<SQLField, String>(){

                public String apply(SQLField input) {
                    return input.getField();
                }
            }).toList();
            ImmutableMap parameters = ImmutableMap.copyOf(executor.getParameters());
            return new CacheKey(version, (ImmutableMap<String, String>)parameters, (Optional<String>)whereClause, (ImmutableList<String>)orderByFields);
        }

        public ImmutableSet<CacheKey> all() {
            return ImmutableSet.of((Object)this, (Object)this.withoutOrder(), (Object)this.withoutOrder().withoutCondition());
        }

        public CacheKey withoutCondition() {
            return new CacheKey(this.transMetaVersionId, this.parameters, (Optional<String>)Optional.absent(), this.orderByFields);
        }

        public CacheKey withoutOrder() {
            return new CacheKey(this.transMetaVersionId, this.parameters, this.whereClause, (ImmutableList<String>)ImmutableList.of());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equal((Object)this.transMetaVersionId, (Object)cacheKey.transMetaVersionId) && Objects.equal(this.parameters, cacheKey.parameters) && Objects.equal(this.whereClause, cacheKey.whereClause) && Objects.equal(this.orderByFields, cacheKey.orderByFields);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.transMetaVersionId, this.parameters, this.whereClause, this.orderByFields});
        }

        public String toString() {
            return Objects.toStringHelper(CacheKey.class).add("transMetaVersionId", this.transMetaVersionId).add("parameters", this.parameters).add("whereClause", this.whereClause).add("orderByFields", this.orderByFields).toString();
        }
    }
}

