/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.execution;

import com.google.common.base.Throwables;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.execution.DefaultTransWiringRowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepAdapter;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepListener;
import org.pentaho.di.trans.step.StepMeta;

public class DefaultTransWiring
implements Runnable {
    private final DataServiceExecutor dataServiceExecutor;

    public DefaultTransWiring(DataServiceExecutor dataServiceExecutor) {
        this.dataServiceExecutor = dataServiceExecutor;
    }

    @Override
    public void run() {
        RowProducer rowProducer;
        final Trans serviceTrans = this.dataServiceExecutor.getServiceTrans();
        Trans genTrans = this.dataServiceExecutor.getGenTrans();
        try {
            rowProducer = this.dataServiceExecutor.addRowProducer();
        }
        catch (KettleException e) {
            throw Throwables.propagate((Throwable)e);
        }
        StepInterface serviceStep = serviceTrans.findRunThread(this.dataServiceExecutor.getService().getStepname());
        serviceStep.addRowListener((RowListener)new DefaultTransWiringRowAdapter(serviceTrans, genTrans, rowProducer));
        serviceStep.addStepListener((StepListener)new StepAdapter(){

            public void stepFinished(Trans trans, StepMeta stepMeta, StepInterface step) {
                rowProducer.finished();
            }
        });
        this.dataServiceExecutor.getGenTrans().findRunThread(this.dataServiceExecutor.getResultStepName()).addStepListener((StepListener)new StepAdapter(){

            public void stepFinished(Trans trans, StepMeta stepMeta, StepInterface step) {
                if (serviceTrans.isRunning()) {
                    trans.getLogChannel().logBasic("Query finished, stopping service transformation");
                    serviceTrans.stopAll();
                }
            }
        });
    }
}

