/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.test.util;

import java.lang.reflect.Field;
import junit.framework.Assert;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.value.ValueMetaBase;

public class FieldAccessor {
    private static final boolean ValueMetaBase_EMPTY_STRING_AND_NULL_ARE_DIFFERENT = ValueMetaBase.EMPTY_STRING_AND_NULL_ARE_DIFFERENT;
    private static final boolean ValueMeta_EMPTY_STRING_AND_NULL_ARE_DIFFERENT = ValueMeta.EMPTY_STRING_AND_NULL_ARE_DIFFERENT;
    private static final String EMPTY_AND_NULL_ARE_DIFF_FIELD = "EMPTY_STRING_AND_NULL_ARE_DIFFERENT";

    public static void ensureBooleanStaticFieldVal(Field f, boolean newValue) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        boolean value = f.getBoolean(null);
        if (value != newValue) {
            boolean fieldAccessibleBak = f.isAccessible();
            Field.setAccessible(new Field[]{f}, true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            int modifiersBak = f.getModifiers();
            int modifiersNew = modifiersBak & 0xFFFFFFEF;
            boolean modifAccessibleBak = modifiersField.isAccessible();
            if (modifiersBak != modifiersNew) {
                if (!modifAccessibleBak) {
                    modifiersField.setAccessible(true);
                }
                modifiersField.setInt(f, modifiersNew);
            }
            f.setBoolean(null, newValue);
            if (modifiersBak != modifiersNew) {
                modifiersField.setInt(f, modifiersBak);
                if (!modifAccessibleBak) {
                    modifiersField.setAccessible(false);
                }
            }
            if (!fieldAccessibleBak) {
                Field.setAccessible(new Field[]{f}, false);
            }
        }
    }

    public static void ensureEmptyStringIsNotNull(boolean newValue) {
        try {
            FieldAccessor.ensureBooleanStaticFieldVal(ValueMetaBase.class.getField(EMPTY_AND_NULL_ARE_DIFF_FIELD), newValue);
            FieldAccessor.ensureBooleanStaticFieldVal(ValueMeta.class.getField(EMPTY_AND_NULL_ARE_DIFF_FIELD), newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((String)"ValueMetaBase", (boolean)newValue, (boolean)ValueMetaBase.EMPTY_STRING_AND_NULL_ARE_DIFFERENT);
        Assert.assertEquals((String)"ValueMeta", (boolean)newValue, (boolean)ValueMeta.EMPTY_STRING_AND_NULL_ARE_DIFFERENT);
    }

    public static void resetEmptyStringIsNotNull() throws NoSuchFieldException, IllegalAccessException {
        FieldAccessor.ensureBooleanStaticFieldVal(ValueMetaBase.class.getField(EMPTY_AND_NULL_ARE_DIFF_FIELD), ValueMetaBase_EMPTY_STRING_AND_NULL_ARE_DIFFERENT);
        FieldAccessor.ensureBooleanStaticFieldVal(ValueMeta.class.getField(EMPTY_AND_NULL_ARE_DIFF_FIELD), ValueMeta_EMPTY_STRING_AND_NULL_ARE_DIFFERENT);
    }
}

