/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.GetStatusServlet;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.ServletTestUtils;
import org.pentaho.di.www.TransformationMap;

public class GetStatusServletTest {
    private TransformationMap mockTransformationMap;
    private JobMap mockJobMap;
    private GetStatusServlet getStatusServlet;

    @Before
    public void setup() {
        this.mockTransformationMap = (TransformationMap)Mockito.mock(TransformationMap.class);
        this.mockJobMap = (JobMap)Mockito.mock(JobMap.class);
        this.getStatusServlet = new GetStatusServlet(this.mockTransformationMap, this.mockJobMap);
    }

    @Test
    public void testGetStatusServletEscapesHtmlWhenTransNotFound() throws ServletException, IOException {
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/kettle/status");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%^&*()<>/");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        this.getStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(ServletTestUtils.getInsideOfTag("H1", out.toString())));
    }

    @Test
    public void testGetStatusServletEscapesHtmlWhenTransFound() throws ServletException, IOException {
        KettleLogStore.init();
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Trans mockTrans = (Trans)Mockito.mock(Trans.class);
        TransMeta mockTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        LogChannelInterface mockChannelInterface = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/kettle/status");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%^&*()<>/");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        Mockito.when((Object)this.mockTransformationMap.getTransformation((CarteObjectEntry)Matchers.any(CarteObjectEntry.class))).thenReturn((Object)mockTrans);
        Mockito.when((Object)mockTrans.getLogChannel()).thenReturn((Object)mockChannelInterface);
        Mockito.when((Object)mockTrans.getTransMeta()).thenReturn((Object)mockTransMeta);
        Mockito.when((Object)mockTransMeta.getMaximum()).thenReturn((Object)new Point(10, 10));
        this.getStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)out.toString().contains("!@#$%^&*()<>/"));
    }
}

