/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.update;

import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.update.Update;
import org.pentaho.di.trans.steps.update.UpdateData;
import org.pentaho.di.trans.steps.update.UpdateMeta;
import org.pentaho.metastore.api.IMetaStore;

public class UpdateMetaTest
extends TestCase {
    private StepMeta stepMeta;
    private Update upd;
    private UpdateData ud;
    private UpdateMeta umi;
    public static final String databaseXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><connection><name>lookup</name><server>127.0.0.1</server><type>H2</type><access>Native</access><database>mem:db</database><port></port><username>sa</username><password></password></connection>";

    @Before
    protected void setUp() throws KettleException {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("delete1");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("max.sz", "10");
        transMeta.injectVariables(vars);
        this.umi = new UpdateMeta();
        this.ud = new UpdateData();
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String deletePid = plugReg.getPluginId(StepPluginType.class, (Object)this.umi);
        this.stepMeta = new StepMeta(deletePid, "delete", (StepMetaInterface)this.umi);
        Trans trans = new Trans(transMeta);
        transMeta.addStep(this.stepMeta);
        this.upd = new Update(this.stepMeta, (StepDataInterface)this.ud, 1, transMeta, trans);
        this.upd.copyVariablesFrom((VariableSpace)transMeta);
    }

    @Test
    public void testCommitCountFixed() {
        this.umi.setCommitSize("100");
        UpdateMetaTest.assertTrue((this.umi.getCommitSize((VariableSpace)this.upd) == 100 ? 1 : 0) != 0);
    }

    @Test
    public void testCommitCountVar() {
        this.umi.setCommitSize("${max.sz}");
        UpdateMetaTest.assertTrue((this.umi.getCommitSize((VariableSpace)this.upd) == 10 ? 1 : 0) != 0);
    }

    @Test
    public void testCommitCountMissedVar() {
        this.umi.setCommitSize("missed-var");
        try {
            this.umi.getCommitSize((VariableSpace)this.upd);
            UpdateMetaTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUseDefaultSchemaName() throws Exception {
        String schemaName = "";
        String tableName = "tableName";
        String schemaTable = "default.tableName";
        DatabaseMeta databaseMeta = (DatabaseMeta)Mockito.spy((Object)new DatabaseMeta(databaseXML){

            public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc) {
                return "someValue";
            }
        });
        Mockito.when((Object)databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName)).thenReturn((Object)schemaTable);
        ValueMetaInterface valueMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        Mockito.when((Object)valueMeta.clone()).thenReturn(Mockito.mock(ValueMetaInterface.class));
        RowMetaInterface rowMetaInterface = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)rowMetaInterface.size()).thenReturn((Object)1);
        Mockito.when((Object)rowMetaInterface.searchValueMeta(Matchers.anyString())).thenReturn((Object)valueMeta);
        UpdateMeta updateMeta = new UpdateMeta();
        updateMeta.setDatabaseMeta(databaseMeta);
        updateMeta.setTableName(tableName);
        updateMeta.setSchemaName(schemaName);
        updateMeta.setKeyLookup(new String[]{"KeyLookup1", "KeyLookup2"});
        updateMeta.setKeyStream(new String[]{"KeyStream1", "KeyStream2"});
        updateMeta.setUpdateLookup(new String[]{"updateLookup1", "updateLookup2"});
        updateMeta.setUpdateStream(new String[]{"UpdateStream1", "UpdateStream2"});
        SQLStatement sqlStatement = updateMeta.getSQLStatements(new TransMeta(), (StepMeta)Mockito.mock(StepMeta.class), rowMetaInterface, (Repository)Mockito.mock(Repository.class), (IMetaStore)Mockito.mock(IMetaStore.class));
        String sql = sqlStatement.getSQL();
        Assert.assertTrue((StringUtils.countMatches((String)sql, (String)schemaTable) == 2 ? 1 : 0) != 0);
    }
}

