/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.univariatestats;

import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStats;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsData;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsMeta;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsMetaFunction;
import org.pentaho.metastore.api.IMetaStore;

public class UnivariateStatsMetaTest {
    private final FieldLoadSaveValidator<UnivariateStatsMetaFunction> univariateFunctionFieldLoadSaveValidator = new FieldLoadSaveValidator<UnivariateStatsMetaFunction>(){
        final Random random = new Random();

        @Override
        public boolean validateTestObject(UnivariateStatsMetaFunction testObject, Object actual) {
            return testObject.getXML().equals(((UnivariateStatsMetaFunction)actual).getXML());
        }

        @Override
        public UnivariateStatsMetaFunction getTestObject() {
            return new UnivariateStatsMetaFunction(UUID.randomUUID().toString(), this.random.nextBoolean(), this.random.nextBoolean(), this.random.nextBoolean(), this.random.nextBoolean(), this.random.nextBoolean(), this.random.nextBoolean(), this.random.nextDouble(), this.random.nextBoolean());
        }
    };
    private final ArrayLoadSaveValidator<UnivariateStatsMetaFunction> univariateFunctionArrayFieldLoadSaveValidator = new ArrayLoadSaveValidator<UnivariateStatsMetaFunction>(this.univariateFunctionFieldLoadSaveValidator);

    @Test
    public void testGetAndSetSetInputFieldMetaFunctions() {
        UnivariateStatsMetaFunction[] stats = new UnivariateStatsMetaFunction[3];
        UnivariateStatsMeta meta = new UnivariateStatsMeta();
        meta.setInputFieldMetaFunctions(stats);
        Assert.assertTrue((stats == meta.getInputFieldMetaFunctions() ? 1 : 0) != 0);
    }

    @Test
    public void testAllocateAndGetNumFieldsToProcess() {
        UnivariateStatsMeta meta = new UnivariateStatsMeta();
        meta.allocate(13);
        Assert.assertEquals((long)13L, (long)meta.getNumFieldsToProcess());
    }

    @Test
    public void testLegacyLoadXml() throws IOException, KettleXMLException {
        String legacyXml = IOUtils.toString((InputStream)UnivariateStatsMetaTest.class.getClassLoader().getResourceAsStream("org/pentaho/di/trans/steps/univariatestats/legacyUnivariateStatsMetaTest.xml"));
        IMetaStore mockMetaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        UnivariateStatsMeta meta = new UnivariateStatsMeta();
        meta.loadXML(XMLHandler.loadXMLString((String)legacyXml).getFirstChild(), new ArrayList(), mockMetaStore);
        Assert.assertEquals((long)2L, (long)meta.getNumFieldsToProcess());
        UnivariateStatsMetaFunction first = meta.getInputFieldMetaFunctions()[0];
        Assert.assertEquals((Object)"a", (Object)first.getSourceFieldName());
        Assert.assertEquals((Object)true, (Object)first.getCalcN());
        Assert.assertEquals((Object)true, (Object)first.getCalcMean());
        Assert.assertEquals((Object)true, (Object)first.getCalcStdDev());
        Assert.assertEquals((Object)true, (Object)first.getCalcMin());
        Assert.assertEquals((Object)true, (Object)first.getCalcMax());
        Assert.assertEquals((Object)true, (Object)first.getCalcMedian());
        Assert.assertEquals((double)0.5, (double)first.getCalcPercentile(), (double)0.0);
        Assert.assertEquals((Object)true, (Object)first.getInterpolatePercentile());
        UnivariateStatsMetaFunction second = meta.getInputFieldMetaFunctions()[1];
        Assert.assertEquals((Object)"b", (Object)second.getSourceFieldName());
        Assert.assertEquals((Object)false, (Object)second.getCalcN());
        Assert.assertEquals((Object)false, (Object)second.getCalcMean());
        Assert.assertEquals((Object)false, (Object)second.getCalcStdDev());
        Assert.assertEquals((Object)false, (Object)second.getCalcMin());
        Assert.assertEquals((Object)false, (Object)second.getCalcMax());
        Assert.assertEquals((Object)false, (Object)second.getCalcMedian());
        Assert.assertEquals((double)-1.0, (double)second.getCalcPercentile(), (double)0.0);
        Assert.assertEquals((Object)false, (Object)second.getInterpolatePercentile());
    }

    @Test
    public void loadSaveRoundTripTest() throws KettleException {
        List<String> attributes = Arrays.asList("inputFieldMetaFunctions");
        HashMap fieldLoadSaveValidatorTypeMap = new HashMap();
        fieldLoadSaveValidatorTypeMap.put(UnivariateStatsMetaFunction[].class.getCanonicalName(), this.univariateFunctionArrayFieldLoadSaveValidator);
        LoadSaveTester loadSaveTester = new LoadSaveTester(UnivariateStatsMeta.class, attributes, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap(), fieldLoadSaveValidatorTypeMap);
        loadSaveTester.testRepoRoundTrip();
        loadSaveTester.testXmlRoundTrip();
    }

    private void assertContains(Map<String, Integer> map, String key, Integer value) {
        Assert.assertTrue((String)("Expected map to contain " + key), (boolean)map.containsKey(key));
        Assert.assertTrue((String)("Expected key of " + key + " to be of type " + ValueMetaBase.getTypeDesc((int)value)), (map.get(key) == value ? 1 : 0) != 0);
    }

    @Test
    public void testGetFields() throws KettleStepException {
        UnivariateStatsMeta meta = new UnivariateStatsMeta();
        UnivariateStatsMetaFunction[] functions = this.univariateFunctionArrayFieldLoadSaveValidator.getTestObject();
        meta.setInputFieldMetaFunctions(functions);
        RowMetaInterface mockRowMetaInterface = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        final AtomicBoolean clearCalled = new AtomicBoolean(false);
        final ArrayList valueMetaInterfaces = new ArrayList();
        ((RowMetaInterface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                clearCalled.set(true);
                return null;
            }
        }).when((Object)mockRowMetaInterface)).clear();
        ((RowMetaInterface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                if (!clearCalled.get()) {
                    throw new RuntimeException("Clear not called before adding value metas");
                }
                valueMetaInterfaces.add((ValueMetaInterface)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)mockRowMetaInterface)).addValueMeta((ValueMetaInterface)Matchers.any(ValueMetaInterface.class));
        meta.getFields(mockRowMetaInterface, null, null, null, null, null, null);
        HashMap<String, Integer> valueMetas = new HashMap<String, Integer>();
        for (ValueMetaInterface vmi : valueMetaInterfaces) {
            valueMetas.put(vmi.getName(), vmi.getType());
        }
        for (UnivariateStatsMetaFunction function : functions) {
            if (function.getCalcN()) {
                this.assertContains(valueMetas, function.getSourceFieldName() + "(N)", 1);
            }
            if (function.getCalcMean()) {
                this.assertContains(valueMetas, function.getSourceFieldName() + "(mean)", 1);
            }
            if (function.getCalcStdDev()) {
                this.assertContains(valueMetas, function.getSourceFieldName() + "(stdDev)", 1);
            }
            if (function.getCalcMin()) {
                this.assertContains(valueMetas, function.getSourceFieldName() + "(min)", 1);
            }
            if (function.getCalcMax()) {
                this.assertContains(valueMetas, function.getSourceFieldName() + "(max)", 1);
            }
            if (function.getCalcMedian()) {
                this.assertContains(valueMetas, function.getSourceFieldName() + "(median)", 1);
            }
            if (!(function.getCalcPercentile() >= 0.0)) continue;
            NumberFormat pF = NumberFormat.getInstance();
            pF.setMaximumFractionDigits(2);
            String res = pF.format(function.getCalcPercentile() * 100.0);
            this.assertContains(valueMetas, function.getSourceFieldName() + "(" + res + "th percentile)", 1);
        }
    }

    @Test
    public void testCheckNullPrev() {
        UnivariateStatsMeta meta = new UnivariateStatsMeta();
        ArrayList remarks = new ArrayList();
        meta.check(remarks, null, null, null, new String[0], null, null, null, null, null);
        Assert.assertEquals((long)2L, (long)remarks.size());
        Assert.assertEquals((Object)"Not receiving any fields from previous steps!", (Object)((CheckResultInterface)remarks.get(0)).getText());
    }

    @Test
    public void testCheckEmptyPrev() {
        UnivariateStatsMeta meta = new UnivariateStatsMeta();
        RowMetaInterface mockRowMetaInterface = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)mockRowMetaInterface.size()).thenReturn((Object)0);
        ArrayList remarks = new ArrayList();
        meta.check(remarks, null, null, mockRowMetaInterface, new String[0], null, null, null, null, null);
        Assert.assertEquals((long)2L, (long)remarks.size());
        Assert.assertEquals((Object)"Not receiving any fields from previous steps!", (Object)((CheckResultInterface)remarks.get(0)).getText());
    }

    @Test
    public void testCheckGoodPrev() {
        UnivariateStatsMeta meta = new UnivariateStatsMeta();
        RowMetaInterface mockRowMetaInterface = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)mockRowMetaInterface.size()).thenReturn((Object)500);
        ArrayList remarks = new ArrayList();
        meta.check(remarks, null, null, mockRowMetaInterface, new String[0], null, null, null, null, null);
        Assert.assertEquals((long)2L, (long)remarks.size());
        Assert.assertEquals((Object)"Step is connected to previous one, receiving 500 fields", (Object)((CheckResultInterface)remarks.get(0)).getText());
    }

    @Test
    public void testCheckWithInput() {
        UnivariateStatsMeta meta = new UnivariateStatsMeta();
        ArrayList remarks = new ArrayList();
        meta.check(remarks, null, null, null, new String[1], null, null, null, null, null);
        Assert.assertEquals((long)2L, (long)remarks.size());
        Assert.assertEquals((Object)"Step is receiving info from other steps.", (Object)((CheckResultInterface)remarks.get(1)).getText());
    }

    @Test
    public void testCheckWithoutInput() {
        UnivariateStatsMeta meta = new UnivariateStatsMeta();
        ArrayList remarks = new ArrayList();
        meta.check(remarks, null, null, null, new String[0], null, null, null, null, null);
        Assert.assertEquals((long)2L, (long)remarks.size());
        Assert.assertEquals((Object)"No input received from other steps!", (Object)((CheckResultInterface)remarks.get(1)).getText());
    }

    @Test
    public void testGetStep() {
        StepMeta mockStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)mockStepMeta.getName()).thenReturn((Object)"testName");
        StepDataInterface mockStepDataInterface = (StepDataInterface)Mockito.mock(StepDataInterface.class);
        int cnr = 10;
        TransMeta mockTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        Trans mockTrans = (Trans)Mockito.mock(Trans.class);
        Mockito.when((Object)mockTransMeta.findStep("testName")).thenReturn((Object)mockStepMeta);
        StepInterface step = new UnivariateStatsMeta().getStep(mockStepMeta, mockStepDataInterface, cnr, mockTransMeta, mockTrans);
        Assert.assertTrue((String)("Expected Step to be instanceof " + UnivariateStats.class), (boolean)(step instanceof UnivariateStats));
    }

    @Test
    public void testGetStepData() {
        Assert.assertTrue((String)("Expected StepData to be instanceof " + UnivariateStatsData.class), (boolean)(new UnivariateStatsMeta().getStepData() instanceof UnivariateStatsData));
    }
}

