/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.univariatestats;

import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.json.simple.parser.ParseException;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.steps.loadsave.MemoryRepository;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsMetaFunction;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsMetaTest;
import org.pentaho.test.util.GetterSetterTester;
import org.pentaho.test.util.ObjectTester;
import org.pentaho.test.util.ObjectTesterBuilder;
import org.pentaho.test.util.ObjectValidator;

public class UnivariateStatsMetaFunctionTest {
    @Test
    public void testValuesConstructor() {
        UnivariateStatsMetaFunction function = new UnivariateStatsMetaFunction(null, false, false, false, false, false, false, 0.0, false);
        Assert.assertNull((Object)function.getSourceFieldName());
        Assert.assertFalse((boolean)function.getCalcN());
        Assert.assertFalse((boolean)function.getCalcMean());
        Assert.assertFalse((boolean)function.getCalcStdDev());
        Assert.assertFalse((boolean)function.getCalcMin());
        Assert.assertFalse((boolean)function.getCalcMax());
        Assert.assertFalse((boolean)function.getCalcMedian());
        Assert.assertEquals((double)0.0, (double)function.getCalcPercentile(), (double)0.0);
        Assert.assertFalse((boolean)function.getInterpolatePercentile());
        function = new UnivariateStatsMetaFunction("test", true, true, true, true, true, true, 0.5, true);
        Assert.assertEquals((Object)"test", (Object)function.getSourceFieldName());
        Assert.assertTrue((boolean)function.getCalcN());
        Assert.assertTrue((boolean)function.getCalcMean());
        Assert.assertTrue((boolean)function.getCalcStdDev());
        Assert.assertTrue((boolean)function.getCalcMin());
        Assert.assertTrue((boolean)function.getCalcMax());
        Assert.assertTrue((boolean)function.getCalcMedian());
        Assert.assertEquals((double)0.5, (double)function.getCalcPercentile(), (double)0.0);
        Assert.assertTrue((boolean)function.getInterpolatePercentile());
    }

    @Test
    public void testNodeConstructor() throws IOException, KettleXMLException {
        String functionXml = IOUtils.toString((InputStream)UnivariateStatsMetaTest.class.getClassLoader().getResourceAsStream("org/pentaho/di/trans/steps/univariatestats/trueValuesUnivariateStatsMetaFunctionNode.xml"));
        UnivariateStatsMetaFunction function = new UnivariateStatsMetaFunction(XMLHandler.loadXMLString((String)functionXml).getFirstChild());
        Assert.assertEquals((Object)"a", (Object)function.getSourceFieldName());
        Assert.assertTrue((boolean)function.getCalcN());
        Assert.assertTrue((boolean)function.getCalcMean());
        Assert.assertTrue((boolean)function.getCalcStdDev());
        Assert.assertTrue((boolean)function.getCalcMin());
        Assert.assertTrue((boolean)function.getCalcMax());
        Assert.assertTrue((boolean)function.getCalcMedian());
        Assert.assertEquals((double)0.5, (double)function.getCalcPercentile(), (double)0.0);
        Assert.assertTrue((boolean)function.getInterpolatePercentile());
        functionXml = IOUtils.toString((InputStream)UnivariateStatsMetaTest.class.getClassLoader().getResourceAsStream("org/pentaho/di/trans/steps/univariatestats/falseValuesUnivariateStatsMetaFunctionNode.xml"));
        function = new UnivariateStatsMetaFunction(XMLHandler.loadXMLString((String)functionXml).getFirstChild());
        Assert.assertTrue((boolean)Const.isEmpty((String)function.getSourceFieldName()));
        Assert.assertFalse((boolean)function.getCalcN());
        Assert.assertFalse((boolean)function.getCalcMean());
        Assert.assertFalse((boolean)function.getCalcStdDev());
        Assert.assertFalse((boolean)function.getCalcMin());
        Assert.assertFalse((boolean)function.getCalcMax());
        Assert.assertFalse((boolean)function.getCalcMedian());
        Assert.assertEquals((double)-1.0, (double)function.getCalcPercentile(), (double)0.0);
        Assert.assertFalse((boolean)function.getInterpolatePercentile());
    }

    @Test
    public void testRepoConstructor() throws ParseException, KettleException, IOException {
        String jsString = IOUtils.toString((InputStream)UnivariateStatsMetaTest.class.getClassLoader().getResourceAsStream("org/pentaho/di/trans/steps/univariatestats/trueValuesUnivariateStatsMetaFunctionNode.json"));
        MemoryRepository repo = new MemoryRepository(jsString);
        UnivariateStatsMetaFunction function = new UnivariateStatsMetaFunction((Repository)repo, (ObjectId)new StringObjectId("test"), 0);
        Assert.assertEquals((Object)"test", (Object)function.getSourceFieldName());
        Assert.assertTrue((boolean)function.getCalcN());
        Assert.assertTrue((boolean)function.getCalcMean());
        Assert.assertTrue((boolean)function.getCalcStdDev());
        Assert.assertTrue((boolean)function.getCalcMin());
        Assert.assertTrue((boolean)function.getCalcMax());
        Assert.assertTrue((boolean)function.getCalcMedian());
        Assert.assertEquals((double)0.5, (double)function.getCalcPercentile(), (double)0.0);
        Assert.assertTrue((boolean)function.getInterpolatePercentile());
        jsString = IOUtils.toString((InputStream)UnivariateStatsMetaTest.class.getClassLoader().getResourceAsStream("org/pentaho/di/trans/steps/univariatestats/falseValuesUnivariateStatsMetaFunctionNode.json"));
        repo = new MemoryRepository(jsString);
        function = new UnivariateStatsMetaFunction((Repository)repo, (ObjectId)new StringObjectId("test"), 0);
        Assert.assertTrue((boolean)Const.isEmpty((String)function.getSourceFieldName()));
        Assert.assertFalse((boolean)function.getCalcN());
        Assert.assertFalse((boolean)function.getCalcMean());
        Assert.assertFalse((boolean)function.getCalcStdDev());
        Assert.assertFalse((boolean)function.getCalcMin());
        Assert.assertFalse((boolean)function.getCalcMax());
        Assert.assertFalse((boolean)function.getCalcMedian());
        Assert.assertEquals((double)-1.0, (double)function.getCalcPercentile(), (double)0.0);
        Assert.assertFalse((boolean)function.getInterpolatePercentile());
    }

    @Test
    public void testEquals() throws IOException, KettleXMLException {
        String functionXml = IOUtils.toString((InputStream)UnivariateStatsMetaTest.class.getClassLoader().getResourceAsStream("org/pentaho/di/trans/steps/univariatestats/trueValuesUnivariateStatsMetaFunctionNode.xml"));
        UnivariateStatsMetaFunction function = new UnivariateStatsMetaFunction(XMLHandler.loadXMLString((String)functionXml).getFirstChild());
        UnivariateStatsMetaFunction function2 = new UnivariateStatsMetaFunction(XMLHandler.loadXMLString((String)functionXml).getFirstChild());
        Assert.assertEquals((Object)function, (Object)function2);
        functionXml = IOUtils.toString((InputStream)UnivariateStatsMetaTest.class.getClassLoader().getResourceAsStream("org/pentaho/di/trans/steps/univariatestats/falseValuesUnivariateStatsMetaFunctionNode.xml"));
        function = new UnivariateStatsMetaFunction(XMLHandler.loadXMLString((String)functionXml).getFirstChild());
        Assert.assertFalse((boolean)function.equals((Object)function2));
        function2 = new UnivariateStatsMetaFunction(XMLHandler.loadXMLString((String)functionXml).getFirstChild());
        Assert.assertEquals((Object)function, (Object)function2);
    }

    @Test
    public void testClone() {
        UnivariateStatsMetaFunction function = new UnivariateStatsMetaFunction(null, false, false, false, false, false, false, 0.0, false);
        Assert.assertEquals(UnivariateStatsMetaFunction.class, function.clone().getClass());
    }

    @Test
    public void testGettersAndSetters() {
        GetterSetterTester<UnivariateStatsMetaFunction> getterSetterTest = new GetterSetterTester<UnivariateStatsMetaFunction>(UnivariateStatsMetaFunction.class);
        ObjectTester<Boolean> primitiveBooleanTester = new ObjectTesterBuilder<Boolean>().addObject(true).addObject(false).build();
        getterSetterTest.addObjectTester("sourceFieldName", new ObjectTesterBuilder<Object>().addObject(null).addObject(UUID.randomUUID().toString()).build());
        getterSetterTest.addObjectTester("calcN", primitiveBooleanTester);
        getterSetterTest.addObjectTester("calcMean", primitiveBooleanTester);
        getterSetterTest.addObjectTester("calcStdDev", primitiveBooleanTester);
        getterSetterTest.addObjectTester("calcMin", primitiveBooleanTester);
        getterSetterTest.addObjectTester("calcMax", primitiveBooleanTester);
        getterSetterTest.addObjectTester("calcMedian", primitiveBooleanTester);
        getterSetterTest.addObjectTester("interpolatePercentile", primitiveBooleanTester);
        getterSetterTest.addObjectTester("calcPercentile", new ObjectTesterBuilder<Double>().addObject(-100.0).addObject(0.0).addObject(55.5).addObject(100.0).setValidator(new ObjectValidator<Double>(){

            @Override
            public void validate(Double expected, Object actual) {
                Assert.assertEquals(Double.class, actual.getClass());
                double actualValue = (Double)actual;
                if (0.0 <= expected && expected <= 100.0) {
                    Assert.assertEquals((double)(expected / 100.0), (double)actualValue, (double)0.0);
                } else {
                    Assert.assertEquals((double)-1.0, (double)actualValue, (double)0.0);
                }
            }
        }).build());
        getterSetterTest.test(new UnivariateStatsMetaFunction(null, false, false, false, false, false, false, 0.0, false));
    }
}

