/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.selectvalues;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.trans.TransTestingUtil;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepAttributesInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.selectvalues.SelectMetadataChange;
import org.pentaho.di.trans.steps.selectvalues.SelectValues;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesData;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;

public class SelectValues_LocaleHandling_Test {
    private SelectValues step;
    private Locale current;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.current = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        StepMockHelper<SelectValuesMeta, StepDataInterface> helper = StepMockUtil.getStepMockHelper(SelectValuesMeta.class, "SelectValues_LocaleHandling_Test");
        Mockito.when((Object)helper.stepMeta.isDoingErrorHandling()).thenReturn((Object)true);
        this.step = new SelectValues(helper.stepMeta, helper.stepDataInterface, 1, helper.transMeta, helper.trans);
        this.step = (SelectValues)Mockito.spy((Object)this.step);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2015, 11, 28, 0, 0, 0);
        ((SelectValues)Mockito.doReturn((Object)new Object[]{calendar.getTime()}).doReturn(null).when((Object)this.step)).getRow();
    }

    @After
    public void tearDown() throws Exception {
        this.step = null;
        Locale.setDefault(this.current);
        this.current = null;
    }

    @Test
    public void returns53_ForNull() throws Exception {
        this.executeAndCheck(null, "53");
    }

    @Test
    public void returns53_ForEmpty() throws Exception {
        this.executeAndCheck("", "53");
    }

    @Test
    public void returns53_ForEn_GB() throws Exception {
        this.executeAndCheck("en_GB", "53");
    }

    @Test
    public void returns01_ForEn_US() throws Exception {
        this.executeAndCheck("en_US", "01");
    }

    private void executeAndCheck(String locale, String expectedWeekNumber) throws Exception {
        RowMeta inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaDate("field"));
        this.step.setInputRowMeta((RowMetaInterface)inputRowMeta);
        SelectValuesMeta stepMeta = new SelectValuesMeta();
        stepMeta.allocate(1, 0, 1);
        stepMeta.getSelectName()[0] = "field";
        stepMeta.getMeta()[0] = new SelectMetadataChange((StepAttributesInterface)stepMeta, "field", null, 2, -2, -2, 0, "ww", false, locale, null, false, null, null, null);
        SelectValuesData stepData = new SelectValuesData();
        stepData.select = true;
        stepData.metadata = true;
        stepData.firstselect = true;
        stepData.firstmetadata = true;
        List<Object[]> execute = TransTestingUtil.execute((BaseStep)this.step, (StepMetaInterface)stepMeta, (StepDataInterface)stepData, 1, true);
        TransTestingUtil.assertResult(execute, Collections.singletonList(new Object[]{expectedWeekNumber}));
    }
}

