/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.replacestring;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.BooleanLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveBooleanArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntegerArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringMeta;
import org.pentaho.metastore.api.IMetaStore;

public class ReplaceStringMetaTest {
    private static final String FIELD_NAME = "test";
    private static final String ENCODING_NAME = "UTF-8";

    @Test
    public void testGetFields() throws KettleStepException {
        ReplaceStringMeta meta = new ReplaceStringMeta();
        meta.setFieldInStream(new String[]{FIELD_NAME});
        meta.setFieldOutStream(new String[]{FIELD_NAME});
        ValueMetaInterface inputFieldMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        Mockito.when((Object)inputFieldMeta.getStringEncoding()).thenReturn((Object)ENCODING_NAME);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)inputRowMeta.searchValueMeta(Mockito.anyString())).thenReturn((Object)inputFieldMeta);
        StepMeta nextStep = (StepMeta)Mockito.mock(StepMeta.class);
        VariableSpace space = (VariableSpace)Mockito.mock(VariableSpace.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        meta.getFields(inputRowMeta, FIELD_NAME, null, nextStep, space, repository, metaStore);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)inputRowMeta)).addValueMeta((ValueMetaInterface)argument.capture());
        Assert.assertEquals((Object)ENCODING_NAME, (Object)((ValueMetaInterface)argument.getValue()).getStringEncoding());
    }

    @Test
    public void testRoundTrips() throws KettleException {
        List<String> attributes = Arrays.asList("in_stream_name", "out_stream_name", "use_regex", "replace_string", "replace_by_string", "set_empty_string", "replace_field_by_string", "whole_word", "case_sensitive");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        getterMap.put("in_stream_name", "getFieldInStream");
        getterMap.put("out_stream_name", "getFieldOutStream");
        getterMap.put("use_regex", "getUseRegEx");
        getterMap.put("replace_string", "getReplaceString");
        getterMap.put("replace_by_string", "getReplaceByString");
        getterMap.put("set_empty_string", "isSetEmptyString");
        getterMap.put("replace_field_by_string", "getFieldReplaceByString");
        getterMap.put("whole_word", "getWholeWord");
        getterMap.put("case_sensitive", "getCaseSensitive");
        HashMap<String, String> setterMap = new HashMap<String, String>();
        setterMap.put("in_stream_name", "setFieldInStream");
        setterMap.put("out_stream_name", "setFieldOutStream");
        setterMap.put("use_regex", "setUseRegEx");
        setterMap.put("replace_string", "setReplaceString");
        setterMap.put("replace_by_string", "setReplaceByString");
        setterMap.put("set_empty_string", "setEmptyString");
        setterMap.put("replace_field_by_string", "setFieldReplaceByString");
        setterMap.put("whole_word", "setWholeWord");
        setterMap.put("case_sensitive", "setCaseSensitive");
        HashMap fieldLoadSaveValidatorAttributeMap = new HashMap();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 25);
        PrimitiveBooleanArrayLoadSaveValidator booleanArrayLoadSaveValidator = new PrimitiveBooleanArrayLoadSaveValidator(new BooleanLoadSaveValidator(), 25);
        PrimitiveIntegerArrayLoadSaveValidator useRegExArrayLoadSaveValidator = new PrimitiveIntegerArrayLoadSaveValidator(new UseRegExLoadSaveValidator(), 25);
        PrimitiveIntegerArrayLoadSaveValidator wholeWordArrayLoadSaveValidator = new PrimitiveIntegerArrayLoadSaveValidator(new WholeWordLoadSaveValidator(), 25);
        PrimitiveIntegerArrayLoadSaveValidator caseSensitiveArrayLoadSaveValidator = new PrimitiveIntegerArrayLoadSaveValidator(new CaseSensitiveLoadSaveValidator(), 25);
        fieldLoadSaveValidatorAttributeMap.put("in_stream_name", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("out_stream_name", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("use_regex", useRegExArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("replace_string", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("replace_by_string", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("set_empty_string", booleanArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("replace_field_by_string", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("whole_word", wholeWordArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("case_sensitive", caseSensitiveArrayLoadSaveValidator);
        LoadSaveTester loadSaveTester = new LoadSaveTester(ReplaceStringMeta.class, attributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, new HashMap());
        loadSaveTester.testRepoRoundTrip();
        loadSaveTester.testXmlRoundTrip();
    }

    public class CaseSensitiveLoadSaveValidator
    implements FieldLoadSaveValidator<Integer> {
        @Override
        public Integer getTestObject() {
            return new Random().nextInt(ReplaceStringMeta.caseSensitiveCode.length);
        }

        @Override
        public boolean validateTestObject(Integer testObject, Object actual) {
            return testObject.equals(actual);
        }
    }

    public class WholeWordLoadSaveValidator
    implements FieldLoadSaveValidator<Integer> {
        @Override
        public Integer getTestObject() {
            return new Random().nextInt(ReplaceStringMeta.wholeWordCode.length);
        }

        @Override
        public boolean validateTestObject(Integer testObject, Object actual) {
            return testObject.equals(actual);
        }
    }

    public class UseRegExLoadSaveValidator
    implements FieldLoadSaveValidator<Integer> {
        @Override
        public Integer getTestObject() {
            return new Random().nextInt(ReplaceStringMeta.useRegExCode.length);
        }

        @Override
        public boolean validateTestObject(Integer testObject, Object actual) {
            return testObject.equals(actual);
        }
    }
}

